/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.dirgra;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jruby.dirgra.Edge;
import org.jruby.dirgra.EdgeTypeIterable;
import org.jruby.dirgra.ExplicitVertexID;
import org.jruby.dirgra.Vertex;

public class DirectedGraph<T extends ExplicitVertexID> {
    private static int INITIAL_SIZE = 4;
    private Map<T, Vertex<T>> vertices = new HashMap<T, Vertex<T>>();
    private Edge<T>[] edges = new Edge[INITIAL_SIZE];
    private int edgeLength = 0;
    private ArrayList inOrderVerticeData = new ArrayList();
    int vertexIDCounter = 0;

    protected Edge<T>[] growEdges(Edge<T>[] array, int realLength) {
        int newLength = array.length == 0 ? 2 : array.length * 2;
        Edge[] newEdges = new Edge[newLength];
        System.arraycopy(array, 0, newEdges, 0, realLength);
        return newEdges;
    }

    protected Edge<T>[] getEdges() {
        return this.edges;
    }

    protected Edge<T> addEdge(Edge<T> newEdge) {
        for (int i2 = 0; i2 < this.edgeLength; ++i2) {
            if (!this.edges[i2].equals(newEdge)) continue;
            return newEdge;
        }
        if (this.edgeLength >= this.edges.length) {
            this.edges = this.growEdges(this.edges, this.edgeLength);
        }
        this.edges[this.edgeLength++] = newEdge;
        return newEdge;
    }

    public void removeEdge(Edge<T> edge) {
        int splitPoint = -1;
        for (int i2 = 0; i2 < this.edgeLength; ++i2) {
            if (!this.edges[i2].equals(edge)) continue;
            splitPoint = i2;
            break;
        }
        if (splitPoint != -1) {
            Edge<T> edgeToRemove = this.edges[splitPoint];
            if (splitPoint < this.edgeLength - 1) {
                System.arraycopy(this.edges, splitPoint + 1, this.edges, splitPoint, this.edgeLength - 1 - splitPoint);
            }
            this.edges[this.edgeLength - 1] = null;
            --this.edgeLength;
            edge.getSource().removeOutgoingEdge(edgeToRemove);
            edge.getDestination().removeIncomingEdge(edgeToRemove);
        }
    }

    public Collection<Vertex<T>> vertices() {
        return this.vertices.values();
    }

    public Collection<Edge<T>> edges() {
        return Arrays.asList(Arrays.copyOf(this.edges, this.edgeLength));
    }

    public Iterable<Edge<T>> edgesOfType(Object type2) {
        return new EdgeTypeIterable<T>(this.edges, this.edgeLength, type2);
    }

    public Collection<T> allData() {
        return this.vertices.keySet();
    }

    public Collection<T> getInorderData() {
        return this.inOrderVerticeData;
    }

    public void addEdge(T source2, T destination, Object type2) {
        this.findOrCreateVertexFor(source2).addEdgeTo(destination, type2);
    }

    public void removeEdge(T source2, T destination) {
        if (this.findVertexFor(source2) != null) {
            for (Edge<T> edge : this.findOrCreateVertexFor(source2).getOutgoingEdges()) {
                if (edge.getDestination().getData() != destination) continue;
                this.findOrCreateVertexFor(source2).removeEdgeTo(edge.getDestination());
                return;
            }
        }
    }

    public Vertex<T> findVertexFor(T data2) {
        return this.vertices.get(data2);
    }

    public Vertex<T> findOrCreateVertexFor(T data2) {
        Vertex<T> vertex = this.vertices.get(data2);
        if (vertex != null) {
            return vertex;
        }
        vertex = new Vertex<T>(this, data2, this.vertexIDCounter++);
        this.inOrderVerticeData.add(data2);
        this.vertices.put(data2, vertex);
        return vertex;
    }

    public void removeVertexFor(T data2) {
        if (this.findVertexFor(data2) != null) {
            Vertex<T> vertex = this.findOrCreateVertexFor(data2);
            this.vertices.remove(data2);
            this.inOrderVerticeData.remove(data2);
            vertex.removeAllEdges();
        }
    }

    public int size() {
        return this.allData().size();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        ArrayList<Vertex<T>> verts = new ArrayList<Vertex<T>>(this.vertices.values());
        Collections.sort(verts);
        for (Vertex<T> vertex : verts) {
            buf.append(vertex);
        }
        return buf.toString();
    }
}

