/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.thread;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.thread.ThreadLibrary;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Queue"})
public class Queue
extends RubyObject {
    protected BlockingQueue<IRubyObject> queue;
    protected AtomicLong numWaiting = new AtomicLong();
    final RubyThread.Task<Queue, IRubyObject> takeTask = new RubyThread.Task<Queue, IRubyObject>(){

        @Override
        public IRubyObject run(ThreadContext context, Queue queue) throws InterruptedException {
            return queue.getQueueSafe().take();
        }

        @Override
        public void wakeup(RubyThread thread2, Queue data2) {
            thread2.getNativeThread().interrupt();
        }
    };
    final RubyThread.Task<IRubyObject[], IRubyObject> putTask = new RubyThread.Task<IRubyObject[], IRubyObject>(){

        @Override
        public IRubyObject run(ThreadContext context, IRubyObject[] args2) throws InterruptedException {
            BlockingQueue<IRubyObject> queue = Queue.this.getQueueSafe();
            if (args2.length == 2 && args2[1].isTrue() && queue.remainingCapacity() == 0) {
                throw context.runtime.newThreadError("queue full");
            }
            queue.put(args2[0]);
            return context.nil;
        }

        @Override
        public void wakeup(RubyThread thread2, IRubyObject[] data2) {
            thread2.getNativeThread().interrupt();
        }
    };

    public Queue(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    public static void setup(Ruby runtime) {
        RubyClass cQueue = runtime.defineClass("Queue", runtime.getObject(), new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new Queue(runtime, klass);
            }
        });
        cQueue.undefineMethod("initialize_copy");
        cQueue.setReifiedClass(Queue.class);
        cQueue.defineAnnotatedMethods(Queue.class);
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        this.queue = new LinkedBlockingQueue<IRubyObject>();
        return this;
    }

    @JRubyMethod(name={"shutdown!"})
    public IRubyObject shutdown(ThreadContext context) {
        this.queue = null;
        return context.runtime.getNil();
    }

    public synchronized void shutdown() {
        this.queue = null;
    }

    public boolean isShutdown() {
        return this.queue == null;
    }

    public BlockingQueue<IRubyObject> getQueueSafe() {
        BlockingQueue<IRubyObject> queue = this.queue;
        this.checkShutdown();
        return queue;
    }

    public synchronized void checkShutdown() {
        if (this.queue == null) {
            Ruby runtime = this.getRuntime();
            throw new RaiseException(runtime, runtime.getThreadError(), "queue shut down", false);
        }
    }

    @JRubyMethod
    public synchronized IRubyObject clear(ThreadContext context) {
        BlockingQueue<IRubyObject> queue = this.getQueueSafe();
        queue.clear();
        return this;
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p(ThreadContext context) {
        BlockingQueue<IRubyObject> queue = this.getQueueSafe();
        return context.runtime.newBoolean(queue.size() == 0);
    }

    @JRubyMethod(name={"length", "size"})
    public RubyNumeric length(ThreadContext context) {
        this.checkShutdown();
        return RubyNumeric.int2fix(context.runtime, this.queue.size());
    }

    protected long java_length() {
        return this.queue.size();
    }

    @JRubyMethod
    public RubyNumeric num_waiting(ThreadContext context) {
        return context.runtime.newFixnum(this.numWaiting.longValue());
    }

    @JRubyMethod(name={"pop", "deq", "shift"})
    public IRubyObject pop(ThreadContext context) {
        return this.pop(context, true);
    }

    @JRubyMethod(name={"pop", "deq", "shift"})
    public IRubyObject pop(ThreadContext context, IRubyObject arg0) {
        return this.pop(context, !arg0.isTrue());
    }

    @JRubyMethod(name={"push", "<<", "enq"}, required=1, optional=1)
    public IRubyObject push(ThreadContext context, IRubyObject[] args2) {
        this.checkShutdown();
        try {
            context.getThread().executeTask(context, args2, this.putTask);
            return this;
        }
        catch (InterruptedException ie) {
            throw context.runtime.newThreadError("interrupted in " + this.getMetaClass().getName() + "#push");
        }
    }

    @JRubyMethod
    public IRubyObject marshal_dump(ThreadContext context) {
        return ThreadLibrary.undumpable(context, this);
    }

    private IRubyObject pop(ThreadContext context, boolean should_block) {
        BlockingQueue<IRubyObject> queue = this.getQueueSafe();
        if (!should_block && queue.size() == 0) {
            throw new RaiseException(context.runtime, context.runtime.getThreadError(), "queue empty", false);
        }
        this.numWaiting.incrementAndGet();
        try {
            IRubyObject iRubyObject = context.getThread().executeTask(context, this, this.takeTask);
            return iRubyObject;
        }
        catch (InterruptedException ie) {
            throw context.runtime.newThreadError("interrupted in " + this.getMetaClass().getName() + "#pop");
        }
        finally {
            this.numWaiting.decrementAndGet();
        }
    }
}

