/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.compiler.Compilable;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.IRMethodArgs;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class InterpretedIRMethod
extends DynamicMethod
implements IRMethodArgs,
PositionAware,
Compilable<InterpreterContext> {
    private static final Logger LOG = LoggerFactory.getLogger("InterpretedIRMethod");
    private Signature signature;
    private boolean displayedCFG = false;
    protected final IRScope method;
    protected InterpreterContext interpreterContext = null;
    protected int callCount = 0;

    public InterpretedIRMethod(IRScope method, Visibility visibility, RubyModule implementationClass) {
        super(implementationClass, visibility, method.getName());
        this.method = method;
        this.method.getStaticScope().determineModule();
        this.signature = this.getStaticScope().getSignature();
        if (Options.JIT_THRESHOLD.load() == -1) {
            this.callCount = -1;
        }
    }

    @Override
    public IRScope getIRScope() {
        return this.method;
    }

    @Override
    public void setCallCount(int callCount) {
        this.callCount = callCount;
    }

    public StaticScope getStaticScope() {
        return this.method.getStaticScope();
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        this.ensureInstrsReady();
        return ((IRMethod)this.method).getArgumentDescriptors();
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public Arity getArity() {
        return this.signature.arity();
    }

    protected void post(InterpreterContext ic, ThreadContext context) {
        context.popFrame();
        if (ic.popDynScope()) {
            context.popScope();
        }
    }

    protected void pre(InterpreterContext ic, ThreadContext context, IRubyObject self2, String name2, Block block, RubyModule implClass) {
        context.preMethodFrameOnly(implClass, name2, self2, block);
        if (ic.pushNewDynScope()) {
            context.pushScope(DynamicScope.newDynamicScope(ic.getStaticScope()));
        }
    }

    @Override
    public InterpreterContext ensureInstrsReady() {
        if (this.interpreterContext == null) {
            if (this.method instanceof IRMethod) {
                this.interpreterContext = ((IRMethod)this.method).lazilyAcquireInterpreterContext();
            }
            this.interpreterContext = this.method.getInterpreterContext();
        }
        return this.interpreterContext;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            this.promoteToFullBuild(context);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), this.getImplementationClass().getMethodLocation(), self2, name2, args2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, implClass, name2, args2, block, null);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, implClass, name2, args2, block, null);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            this.promoteToFullBuild(context);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), this.getImplementationClass().getMethodLocation(), self2, name2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, implClass, name2, block, null);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, implClass, name2, block, null);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            this.promoteToFullBuild(context);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), this.getImplementationClass().getMethodLocation(), self2, name2, arg0, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, IRubyObject arg1, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, implClass, name2, arg1, block, null);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, implClass, name2, arg1, block, null);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            this.promoteToFullBuild(context);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), this.getImplementationClass().getMethodLocation(), self2, name2, arg0, arg1, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, IRubyObject arg1, IRubyObject arg2, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, implClass, name2, arg1, arg2, block, null);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, implClass, name2, arg1, arg2, block, null);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            this.promoteToFullBuild(context);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), this.getImplementationClass().getMethodLocation(), self2, name2, arg0, arg1, arg2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, implClass, name2, arg1, arg2, arg3, block, null);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, implClass, name2, arg1, arg2, arg3, block, null);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    protected void doDebug() {
        this.ensureInstrsReady();
        LOG.info("Executing '" + this.method.getName() + "'", new Object[0]);
        if (!this.displayedCFG) {
            LOG.info(this.method.debugOutput(), new Object[0]);
            this.displayedCFG = true;
        }
    }

    @Override
    public void completeBuild(InterpreterContext interpreterContext) {
        this.interpreterContext = interpreterContext;
    }

    protected void promoteToFullBuild(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (runtime.isBooting()) {
            return;
        }
        if (this.callCount++ >= Options.JIT_THRESHOLD.load()) {
            runtime.getJITCompiler().buildThresholdReached(context, this);
        }
    }

    @Override
    public DynamicMethod dup() {
        return new InterpretedIRMethod(this.method, this.getVisibility(), this.implementationClass);
    }

    @Override
    public String getClassName(ThreadContext context) {
        return null;
    }

    @Override
    public String getFile() {
        return this.method.getFileName();
    }

    @Override
    public int getLine() {
        return this.method.getLineNumber();
    }
}

