/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer;

import org.jcodings.Encoding;
import org.jruby.RubyArray;
import org.jruby.RubyString;
import org.jruby.lexer.LexerSource;
import org.jruby.util.ByteList;

public class ByteListLexerSource
extends LexerSource {
    private ByteList completeSource;
    private int offset = 0;

    public ByteListLexerSource(String sourceName, int line, ByteList in, RubyArray list2) {
        super(sourceName, line, list2);
        this.completeSource = in;
    }

    @Override
    public Encoding getEncoding() {
        return this.completeSource.getEncoding();
    }

    @Override
    public void setEncoding(Encoding encoding2) {
        this.completeSource.setEncoding(encoding2);
        this.encodeExistingScriptLines(encoding2);
    }

    @Override
    public ByteList gets() {
        int length2 = this.completeSource.length();
        if (this.offset >= length2) {
            return null;
        }
        int end2 = this.completeSource.indexOf(10, this.offset) + 1;
        if (end2 == 0) {
            end2 = length2;
        }
        ByteList line = this.completeSource.makeShared(this.offset, end2 - this.offset);
        this.offset = end2;
        if (this.scriptLines != null) {
            this.scriptLines.append(RubyString.newString(this.scriptLines.getRuntime(), line));
        }
        return line;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }
}

