/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ThreeVarDynamicScope;

public class FourVarDynamicScope
extends ThreeVarDynamicScope {
    private static final int SIZE = 4;
    private static final String SIZE_ERROR = "FourVarDynamicScope only supports scopes with four variables";
    private static final String GROW_ERROR = "FourVarDynamicScope cannot be grown; use ManyVarsDynamicScope";
    protected IRubyObject variableValueThree;

    public FourVarDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
    }

    public FourVarDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    @Override
    public void growIfNeeded() {
        this.growIfNeeded(4, GROW_ERROR);
    }

    @Override
    public DynamicScope cloneScope() {
        return new ThreeVarDynamicScope(this.staticScope, this.parent);
    }

    @Override
    public IRubyObject[] getValues() {
        return new IRubyObject[]{this.variableValueZero, this.variableValueOne, this.variableValueTwo, this.variableValueThree};
    }

    @Override
    public IRubyObject getValue(int offset2, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset2, depth - 1);
        }
        assert (offset2 < 4) : "FourVarDynamicScope only supports scopes with four variables";
        switch (offset2) {
            case 0: {
                return this.variableValueZero;
            }
            case 1: {
                return this.variableValueOne;
            }
            case 2: {
                return this.variableValueTwo;
            }
            case 3: {
                return this.variableValueThree;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    @Override
    public IRubyObject getValueOrNil(int offset2, int depth, IRubyObject nil) {
        if (depth > 0) {
            return this.parent.getValueOrNil(offset2, depth - 1, nil);
        }
        return this.getValueDepthZeroOrNil(offset2, nil);
    }

    @Override
    public IRubyObject getValueDepthZeroOrNil(int offset2, IRubyObject nil) {
        assert (offset2 < 4) : "FourVarDynamicScope only supports scopes with four variables";
        switch (offset2) {
            case 0: {
                if (this.variableValueZero == null) {
                    this.variableValueZero = nil;
                    return this.variableValueZero;
                }
                return this.variableValueZero;
            }
            case 1: {
                if (this.variableValueOne == null) {
                    this.variableValueOne = nil;
                    return this.variableValueOne;
                }
                return this.variableValueOne;
            }
            case 2: {
                if (this.variableValueTwo == null) {
                    this.variableValueTwo = nil;
                    return this.variableValueTwo;
                }
                return this.variableValueTwo;
            }
            case 3: {
                if (this.variableValueThree == null) {
                    this.variableValueThree = nil;
                    return this.variableValueThree;
                }
                return this.variableValueThree;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    @Override
    public IRubyObject getValueThreeDepthZeroOrNil(IRubyObject nil) {
        if (this.variableValueThree == null) {
            this.variableValueThree = nil;
            return this.variableValueThree;
        }
        return this.variableValueThree;
    }

    @Override
    public IRubyObject setValue(int offset2, IRubyObject value2, int depth) {
        if (depth > 0) {
            assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
            return this.parent.setValue(offset2, value2, depth - 1);
        }
        assert (offset2 < 4) : "FourVarDynamicScope only supports scopes with four variables";
        switch (offset2) {
            case 0: {
                this.variableValueZero = value2;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = value2;
                return this.variableValueOne;
            }
            case 2: {
                this.variableValueTwo = value2;
                return this.variableValueTwo;
            }
            case 3: {
                this.variableValueThree = value2;
                return this.variableValueThree;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    @Override
    public IRubyObject setValueDepthZero(IRubyObject value2, int offset2) {
        assert (offset2 < 4) : "FourVarDynamicScope only supports scopes with four variables";
        switch (offset2) {
            case 0: {
                this.variableValueZero = value2;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = value2;
                return this.variableValueOne;
            }
            case 2: {
                this.variableValueTwo = value2;
                return this.variableValueTwo;
            }
            case 3: {
                this.variableValueThree = value2;
                return this.variableValueThree;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    @Override
    public IRubyObject setValueThreeDepthZero(IRubyObject value2) {
        this.variableValueThree = value2;
        return this.variableValueThree;
    }
}

