/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.NoVarsDynamicScope;

public class OneVarDynamicScope
extends NoVarsDynamicScope {
    private static final int SIZE = 1;
    private static final String SIZE_ERROR = "OneVarDynamicScope only supports scopes with one variable";
    private static final String GROW_ERROR = "OneVarDynamicScope cannot be grown; use ManyVarsDynamicScope";
    protected IRubyObject variableValueZero;

    public OneVarDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
    }

    public OneVarDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    @Override
    public void growIfNeeded() {
        this.growIfNeeded(1, GROW_ERROR);
    }

    @Override
    public DynamicScope cloneScope() {
        return new OneVarDynamicScope(this.staticScope, this.parent);
    }

    @Override
    public IRubyObject[] getValues() {
        return new IRubyObject[]{this.variableValueZero};
    }

    @Override
    public IRubyObject getValue(int offset2, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset2, depth - 1);
        }
        assert (offset2 < 1) : "OneVarDynamicScope only supports scopes with one variable";
        return this.variableValueZero;
    }

    @Override
    public IRubyObject getValueOrNil(int offset2, int depth, IRubyObject nil) {
        if (depth > 0) {
            return this.parent.getValueOrNil(offset2, depth - 1, nil);
        }
        return this.getValueDepthZeroOrNil(offset2, nil);
    }

    @Override
    public IRubyObject getValueDepthZeroOrNil(int offset2, IRubyObject nil) {
        IRubyObject value2 = this.variableValueZero;
        if (value2 == null) {
            this.variableValueZero = nil;
            return this.variableValueZero;
        }
        return value2;
    }

    @Override
    public IRubyObject getValueZeroDepthZeroOrNil(IRubyObject nil) {
        IRubyObject value2 = this.variableValueZero;
        if (value2 == null) {
            this.variableValueZero = nil;
            return this.variableValueZero;
        }
        return value2;
    }

    @Override
    public IRubyObject setValue(int offset2, IRubyObject value2, int depth) {
        if (depth > 0) {
            return this.parent.setValue(offset2, value2, depth - 1);
        }
        this.variableValueZero = value2;
        return this.variableValueZero;
    }

    @Override
    public IRubyObject setValueDepthZero(IRubyObject value2, int offset2) {
        this.variableValueZero = value2;
        return this.variableValueZero;
    }

    @Override
    public IRubyObject setValueZeroDepthZero(IRubyObject value2) {
        this.variableValueZero = value2;
        return this.variableValueZero;
    }
}

