/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.utilities;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.Truffle;
import java.util.concurrent.atomic.AtomicReference;

public class CyclicAssumption {
    private final String name;
    private final AtomicReference<Assumption> assumption;

    public CyclicAssumption(String name) {
        this.name = name;
        this.assumption = new AtomicReference<Assumption>(Truffle.getRuntime().createAssumption(name));
    }

    public void invalidate() {
        Assumption newAssumption = Truffle.getRuntime().createAssumption(this.name);
        Assumption oldAssumption = this.assumption.getAndSet(newAssumption);
        oldAssumption.invalidate();
    }

    public Assumption getAssumption() {
        return this.assumption.get();
    }
}

