/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.interop.node;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.messages.Message;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.interop.ForeignAccessArguments;
import com.oracle.truffle.interop.node.ObjectAccessNode;

class GenericObjectAccessNode
extends ObjectAccessNode {
    private final Message access;
    @Node.Child
    private IndirectCallNode indirectCallNode;

    public GenericObjectAccessNode(Message access) {
        this.access = access;
        this.indirectCallNode = Truffle.getRuntime().createIndirectCallNode();
    }

    public GenericObjectAccessNode(GenericObjectAccessNode prev) {
        this(prev.access);
    }

    @Override
    public Object executeWith(VirtualFrame frame, TruffleObject truffleObject, Object[] arguments) {
        return this.indirectCallNode.call(frame, truffleObject.getForeignAccessFactory().getAccess(this.access), ForeignAccessArguments.create(truffleObject, arguments));
    }
}

