/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ForeignAccessFactory;
import com.oracle.truffle.api.object.DebugCounter;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.LocationFactory;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.Locations;
import com.oracle.truffle.object.ObjectStorageOptions;
import com.oracle.truffle.object.ShapeImpl;
import com.oracle.truffle.object.Transition;
import com.oracle.truffle.object.debug.ShapeProfiler;
import java.util.List;

public abstract class DynamicObjectImpl
extends DynamicObject
implements Cloneable {
    private ShapeImpl shape;
    public static final DebugCounter reshapeCount = DebugCounter.create("Reshape count");

    public DynamicObjectImpl(Shape shape) {
        assert (shape instanceof ShapeImpl);
        this.initialize(shape);
        this.setShape(shape);
        if (ObjectStorageOptions.Profile) {
            DynamicObjectImpl.trackObject(this);
        }
    }

    @Override
    public Object getTypeIdentifier() {
        return this.getShape();
    }

    @Override
    public ShapeImpl getShape() {
        return this.shape;
    }

    protected void setShape(Shape shape) {
        assert (shape.getLayout().getType().isInstance(this));
        this.shape = (ShapeImpl)shape;
    }

    protected abstract void initialize(Shape var1);

    public final void setShapeAndResize(Shape newShape) {
        this.setShapeAndResize(this.getShape(), newShape);
    }

    @Override
    public final void setShapeAndResize(Shape oldShape, Shape newShape) {
        assert (this.getShape() == oldShape) : "wrong old shape";
        if (oldShape != newShape) {
            this.setShape(newShape);
            this.resizeStore(oldShape, newShape);
            assert (this.checkExtensionArrayInvariants(newShape));
        }
    }

    @Override
    public final void setShapeAndGrow(Shape oldShape, Shape newShape) {
        assert (this.getShape() == oldShape) : "wrong old shape";
        if (oldShape != newShape) {
            assert (this.checkSetShape(oldShape, newShape));
            this.setShape(newShape);
            this.growStore(oldShape, newShape);
            assert (this.checkExtensionArrayInvariants(newShape));
        }
    }

    private void growStore(Shape oldShape, Shape newShape) {
        this.growObjectStore(oldShape, newShape);
        if (((ShapeImpl)newShape).hasPrimitiveArray) {
            this.growPrimitiveStore(oldShape, newShape);
        }
    }

    protected abstract void growObjectStore(Shape var1, Shape var2);

    protected abstract void growPrimitiveStore(Shape var1, Shape var2);

    private void resizeStore(Shape oldShape, Shape newShape) {
        this.resizeObjectStore(oldShape, newShape);
        if (((ShapeImpl)newShape).hasPrimitiveArray) {
            this.resizePrimitiveStore(oldShape, newShape);
        }
    }

    protected abstract void resizePrimitiveStore(Shape var1, Shape var2);

    protected abstract void resizeObjectStore(Shape var1, Shape var2);

    private boolean checkSetShape(Shape oldShape, Shape newShape) {
        ShapeImpl currentShape = this.getShape();
        assert (oldShape != newShape) : "Wrong old shape assumption?";
        assert (newShape != currentShape) : "Redundant shape change? shape=" + currentShape;
        return true;
    }

    protected abstract boolean checkExtensionArrayInvariants(Shape var1);

    protected final DynamicObject clone() {
        try {
            return (DynamicObject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    protected abstract DynamicObject cloneWithShape(Shape var1);

    void reshapeAfterDelete(Shape newShape, Shape deletedParentShape) {
        DynamicObject original = this.cloneWithShape(this.getShape());
        this.setShapeAndResize(newShape);
        this.copyProperties(original, deletedParentShape);
    }

    /*
     * Unable to fully structure code
     */
    public final void copyProperties(DynamicObject fromObject, Shape ancestor) {
        fromShape = (ShapeImpl)fromObject.getShape();
        toShape = this.getShape();
        if (!DynamicObjectImpl.$assertionsDisabled && !toShape.isRelated(ancestor)) {
            throw new AssertionError();
        }
        if (!DynamicObjectImpl.$assertionsDisabled && !toShape.isValid()) {
            throw new AssertionError();
        }
        if (DynamicObjectImpl.$assertionsDisabled || ancestor.isValid()) ** GOTO lbl20
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            transitionFromParent = toShape.getTransitionFromParent();
            if (transitionFromParent instanceof Transition.AddPropertyTransition) {
                toProperty = ((Transition.AddPropertyTransition)transitionFromParent).getProperty();
                fromProperty = fromShape.getProperty(toProperty.getKey());
                if (toProperty.getLocation() != null && !(toProperty.getLocation() instanceof Locations.ValueLocation) && !toProperty.getLocation().equals(fromProperty.getLocation())) {
                    toProperty.setInternal(this, fromProperty.get(fromObject, false));
                    if (!DynamicObjectImpl.$assertionsDisabled && !toShape.isValid()) {
                        throw new AssertionError();
                    }
                }
                if (fromShape.getTransitionFromParent() instanceof Transition.AddPropertyTransition && ((Transition.AddPropertyTransition)fromShape.getTransitionFromParent()).getProperty() == fromProperty) {
                    fromShape = fromShape.getParent();
                }
            }
            toShape = toShape.getParent();
lbl20:
            // 2 sources

            ** while (toShape != ancestor)
        }
lbl21:
        // 1 sources

    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean changeFlags(Object id, int newFlags) {
        ShapeImpl oldShape = this.getShape();
        Property existing = ((Shape)oldShape).getProperty(id);
        if (existing != null) {
            if (existing.getFlags() != newFlags) {
                Property newProperty = existing.copyWithFlags(newFlags);
                Shape newShape = ((Shape)oldShape).replaceProperty(existing, newProperty);
                this.setShape(newShape);
            }
            return true;
        }
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean changeFlags(Object id, DynamicObject.FlagsFunction updateFunction) {
        ShapeImpl oldShape = this.getShape();
        Property existing = ((Shape)oldShape).getProperty(id);
        if (existing != null) {
            Integer newFlags = updateFunction.apply(existing.getFlags());
            if (newFlags != null && existing.getFlags() != newFlags.intValue()) {
                Property newProperty = existing.copyWithFlags(newFlags);
                Shape newShape = ((Shape)oldShape).replaceProperty(existing, newProperty);
                this.setShape(newShape);
            }
            return true;
        }
        return false;
    }

    public String debugDump(int level) {
        return this.debugDump(0, level);
    }

    public String debugDump(int level, int levelStop) {
        List<Property> properties = this.getShape().getPropertyListInternal(true);
        StringBuilder sb = new StringBuilder(properties.size() * 10);
        sb.append("{\n");
        for (Property property : properties) {
            DynamicObjectImpl.indent(sb, level + 1);
            sb.append(property.getKey());
            sb.append('[').append(property.getLocation()).append(']');
            Object value = property.get((DynamicObject)this, false);
            if (value instanceof DynamicObjectImpl) {
                value = level < levelStop ? ((DynamicObjectImpl)value).debugDump(level + 1, levelStop) : value.toString();
            }
            sb.append(": ");
            sb.append(value);
            if (property != properties.get(properties.size() - 1)) {
                sb.append(",");
            }
            sb.append("\n");
        }
        DynamicObjectImpl.indent(sb, level);
        sb.append("}");
        return sb.toString();
    }

    private static StringBuilder indent(StringBuilder sb, int level) {
        int i = 0;
        while (i < level) {
            sb.append(' ');
            ++i;
        }
        return sb;
    }

    public String toString() {
        return this.getShape().getObjectType().toString(this);
    }

    public boolean equals(Object obj) {
        return this.getShape().getObjectType().equals(this, obj);
    }

    public int hashCode() {
        return this.getShape().getObjectType().hashCode(this);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object get(Object id, Object defaultValue) {
        Property existing = this.getShape().getProperty(id);
        if (existing != null) {
            return existing.get((DynamicObject)this, false);
        }
        return defaultValue;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(Object id, Object value) {
        Property existing = this.getShape().getProperty(id);
        if (existing != null) {
            existing.setGeneric(this, value, null);
            return true;
        }
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void define(Object id, Object value, int flags) {
        ShapeImpl oldShape = this.getShape();
        Property existing = oldShape.getProperty(id);
        if (existing == null) {
            this.updateShape();
            oldShape = this.getShape();
            ShapeImpl newShape = oldShape.addProperty(Property.create(id, oldShape.allocator().locationForValue(value, true, true), flags));
            this.updateShape();
            ((Shape)newShape).getLastProperty().setGeneric(this, value, oldShape, newShape);
        } else {
            this.defineExisting(id, value, flags, existing, oldShape);
        }
    }

    private void defineExisting(Object id, Object value, int flags, Property existing, ShapeImpl oldShape) {
        if (existing.getFlags() == flags) {
            existing.setGeneric(this, value, null);
        } else {
            Property newProperty = Property.create(id, oldShape.getLayout().existingLocationForValue(value, existing.getLocation(), oldShape), flags);
            ShapeImpl newShape = oldShape.replaceProperty(existing, newProperty);
            this.setShapeAndResize(newShape);
            newProperty.setInternal(this, value);
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void define(Object id, Object value, int flags, LocationFactory locationFactory) {
        ShapeImpl oldShape = this.getShape();
        Property existing = oldShape.getProperty(id);
        if (existing == null) {
            this.updateShape();
            oldShape = this.getShape();
            ShapeImpl newShape = oldShape.addProperty(Property.create(id, locationFactory.createLocation(oldShape, value), flags));
            this.updateShape();
            ((Shape)newShape).getLastProperty().setGeneric(this, value, oldShape, newShape);
        } else {
            this.defineExisting(id, value, flags, existing, oldShape);
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(Object id) {
        ShapeImpl oldShape = this.getShape();
        Property existing = oldShape.getProperty(id);
        if (existing != null) {
            ShapeImpl newShape = oldShape.removeProperty(existing);
            this.reshapeAfterDelete(newShape, ShapeImpl.findCommonAncestor(oldShape, newShape));
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.getShape().getPropertyCount();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final boolean updateShape() {
        return this.getShape().getLayout().getStrategy().updateShape(this);
    }

    private static void trackObject(DynamicObject obj) {
        ShapeProfiler.getInstance().track(obj);
    }

    @Override
    public ForeignAccessFactory getForeignAccessFactory() {
        return this.getShape().getForeignAccessFactory();
    }
}

