/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes.type;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;

@NodeChildren(value={@NodeChild(value="value", type=PackNode.class)})
public abstract class ToIntegerNode
extends PackNode {
    @Node.Child
    private CallDispatchHeadNode integerNode;

    public ToIntegerNode(RubyContext context) {
        super(context);
    }

    public abstract Object executeToInteger(VirtualFrame var1, Object var2);

    @Specialization
    public int toInteger(VirtualFrame frame, int value) {
        return value;
    }

    @Specialization
    public long toInteger(VirtualFrame frame, long value) {
        return value;
    }

    @Specialization(guards={"isRubyBignum(value)"})
    public DynamicObject toInteger(VirtualFrame frame, DynamicObject value) {
        return value;
    }

    @Specialization
    public long toInteger(VirtualFrame frame, double value) {
        return (long)value;
    }

    @Specialization(guards={"!isInteger(value)", "!isLong(value)", "!isRubyBignum(value)"})
    public Object toInteger(VirtualFrame frame, Object value) {
        if (this.integerNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.integerNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
        }
        return this.integerNode.call(frame, this.getContext().getCoreLibrary().getKernelModule(), "Integer", null, value);
    }
}

