/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.constants;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeChildren(value={@NodeChild(value="module", type=RubyNode.class), @NodeChild(value="name", type=RubyNode.class)})
public abstract class LookupConstantNode
extends RubyNode {
    private final boolean ignoreVisibility;
    private final boolean lookInObject;

    public LookupConstantNode(RubyContext context, SourceSection sourceSection, boolean ignoreVisibility, boolean lookInObject) {
        super(context, sourceSection);
        this.ignoreVisibility = ignoreVisibility;
        this.lookInObject = lookInObject;
    }

    public abstract RubyConstant executeLookupConstant(VirtualFrame var1, Object var2, String var3);

    @Specialization(guards={"isRubyModule(module)", "module == cachedModule", "guardName(name, cachedName, sameNameProfile)"}, assumptions={"getUnmodifiedAssumption(cachedModule)"}, limit="getCacheLimit()")
    protected RubyConstant lookupConstant(VirtualFrame frame, DynamicObject module, String name, @Cached(value="module") DynamicObject cachedModule, @Cached(value="name") String cachedName, @Cached(value="doLookup(cachedModule, cachedName)") RubyConstant constant, @Cached(value="isVisible(cachedModule, constant)") boolean isVisible, @Cached(value="createBinaryProfile()") ConditionProfile sameNameProfile) {
        if (!isVisible) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().nameErrorPrivateConstant(module, name, this));
        }
        return constant;
    }

    public Assumption getUnmodifiedAssumption(DynamicObject module) {
        return Layouts.MODULE.getFields(module).getUnmodifiedAssumption();
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isRubyModule(module)"})
    protected RubyConstant lookupConstantUncached(DynamicObject module, String name) {
        RubyConstant constant = this.doLookup(module, name);
        boolean isVisible = this.isVisible(module, constant);
        if (!isVisible) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().nameErrorPrivateConstant(module, name, this));
        }
        return constant;
    }

    @Specialization(guards={"!isRubyModule(module)"})
    protected RubyConstant lookupNotModule(Object module, String name) {
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().typeErrorIsNotA(module.toString(), "class/module", this));
    }

    protected boolean guardName(String name, String cachedName, ConditionProfile sameNameProfile) {
        if (sameNameProfile.profile(name == cachedName)) {
            return true;
        }
        return name.equals(cachedName);
    }

    protected RubyConstant doLookup(DynamicObject module, String name) {
        if (this.lookInObject) {
            return ModuleOperations.lookupConstantAndObject(this.getContext(), module, name);
        }
        return ModuleOperations.lookupConstant(this.getContext(), module, name);
    }

    protected boolean isVisible(DynamicObject module, RubyConstant constant) {
        return this.ignoreVisibility || constant == null || constant.isVisibleTo(this.getContext(), LexicalScope.NONE, module);
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().CONSTANT_LOOKUP_CACHE;
    }
}

