/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.IntegerFixnumRangeLayout;

public class IntegerFixnumRangeLayoutImpl
extends BasicObjectLayoutImpl
implements IntegerFixnumRangeLayout {
    public static final IntegerFixnumRangeLayout INSTANCE = new IntegerFixnumRangeLayoutImpl();
    protected static final Shape.Allocator INTEGER_FIXNUM_RANGE_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey EXCLUDED_END_IDENTIFIER = new HiddenKey("excludedEnd");
    protected static final Property EXCLUDED_END_PROPERTY = Property.create(EXCLUDED_END_IDENTIFIER, INTEGER_FIXNUM_RANGE_ALLOCATOR.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey BEGIN_IDENTIFIER = new HiddenKey("begin");
    protected static final Property BEGIN_PROPERTY = Property.create(BEGIN_IDENTIFIER, INTEGER_FIXNUM_RANGE_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey END_IDENTIFIER = new HiddenKey("end");
    protected static final Property END_PROPERTY = Property.create(END_IDENTIFIER, INTEGER_FIXNUM_RANGE_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);

    protected IntegerFixnumRangeLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createIntegerFixnumRangeShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new IntegerFixnumRangeType(logicalClass, metaClass)).addProperty(EXCLUDED_END_PROPERTY).addProperty(BEGIN_PROPERTY).addProperty(END_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createIntegerFixnumRange(DynamicObjectFactory factory, boolean excludedEnd, int begin, int end) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsIntegerFixnumRange(factory));
        assert (factory.getShape().hasProperty(EXCLUDED_END_IDENTIFIER));
        assert (factory.getShape().hasProperty(BEGIN_IDENTIFIER));
        assert (factory.getShape().hasProperty(END_IDENTIFIER));
        return factory.newInstance(excludedEnd, begin, end);
    }

    @Override
    public boolean isIntegerFixnumRange(Object object) {
        return object instanceof DynamicObject && this.isIntegerFixnumRange((DynamicObject)object);
    }

    @Override
    public boolean isIntegerFixnumRange(DynamicObject object) {
        return this.isIntegerFixnumRange(object.getShape().getObjectType());
    }

    private boolean isIntegerFixnumRange(ObjectType objectType) {
        return objectType instanceof IntegerFixnumRangeType;
    }

    private boolean createsIntegerFixnumRange(DynamicObjectFactory factory) {
        return this.isIntegerFixnumRange(factory.getShape().getObjectType());
    }

    @Override
    public boolean getExcludedEnd(DynamicObject object) {
        assert (this.isIntegerFixnumRange(object));
        assert (object.getShape().hasProperty(EXCLUDED_END_IDENTIFIER));
        return (Boolean)EXCLUDED_END_PROPERTY.get(object, true);
    }

    @Override
    public int getBegin(DynamicObject object) {
        assert (this.isIntegerFixnumRange(object));
        assert (object.getShape().hasProperty(BEGIN_IDENTIFIER));
        return (Integer)BEGIN_PROPERTY.get(object, true);
    }

    @Override
    public int getEnd(DynamicObject object) {
        assert (this.isIntegerFixnumRange(object));
        assert (object.getShape().hasProperty(END_IDENTIFIER));
        return (Integer)END_PROPERTY.get(object, true);
    }

    protected static class IntegerFixnumRangeType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public IntegerFixnumRangeType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public IntegerFixnumRangeType setLogicalClass(DynamicObject logicalClass) {
            return new IntegerFixnumRangeType(logicalClass, this.metaClass);
        }

        @Override
        public IntegerFixnumRangeType setMetaClass(DynamicObject metaClass) {
            return new IntegerFixnumRangeType(this.logicalClass, metaClass);
        }
    }
}

