/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.MutexLayout;

public class MutexLayoutImpl
extends BasicObjectLayoutImpl
implements MutexLayout {
    public static final MutexLayout INSTANCE = new MutexLayoutImpl();
    protected static final Shape.Allocator MUTEX_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey LOCK_IDENTIFIER = new HiddenKey("lock");
    protected static final Property LOCK_PROPERTY = Property.create(LOCK_IDENTIFIER, MUTEX_ALLOCATOR.locationForType(ReentrantLock.class, EnumSet.of(LocationModifier.NonNull)), 0);

    protected MutexLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createMutexShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new MutexType(logicalClass, metaClass)).addProperty(LOCK_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createMutex(DynamicObjectFactory factory, ReentrantLock lock) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsMutex(factory));
        assert (factory.getShape().hasProperty(LOCK_IDENTIFIER));
        assert (lock != null);
        return factory.newInstance(lock);
    }

    @Override
    public boolean isMutex(DynamicObject object) {
        return this.isMutex(object.getShape().getObjectType());
    }

    private boolean isMutex(ObjectType objectType) {
        return objectType instanceof MutexType;
    }

    private boolean createsMutex(DynamicObjectFactory factory) {
        return this.isMutex(factory.getShape().getObjectType());
    }

    @Override
    public ReentrantLock getLock(DynamicObject object) {
        assert (this.isMutex(object));
        assert (object.getShape().hasProperty(LOCK_IDENTIFIER));
        return (ReentrantLock)LOCK_PROPERTY.get(object, true);
    }

    protected static class MutexType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public MutexType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public MutexType setLogicalClass(DynamicObject logicalClass) {
            return new MutexType(logicalClass, this.metaClass);
        }

        @Override
        public MutexType setMetaClass(DynamicObject metaClass) {
            return new MutexType(this.logicalClass, metaClass);
        }
    }
}

