'use strict';

Object.defineProperty(exports, '__esModule', {
    value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _colourNames = require('./colourNames');

var _colourNames2 = _interopRequireDefault(_colourNames);

var _toLonghand = require('./toLonghand');

var _toLonghand2 = _interopRequireDefault(_toLonghand);

var isHex = function isHex(colour) {
    if (colour[0] === '#') {
        var c = (0, _toLonghand2['default'])(colour).substring(1);
        return c.length === 6 && !isNaN(parseInt(c, 16));
    }
    return false;
};

exports.isHex = isHex;
var isRGBorHSL = function isRGBorHSL(colour) {
    return (/^(rgb|hsl)a?\(.*?\)/.test(colour)
    );
};

exports.isRGBorHSL = isRGBorHSL;
var isKeyword = function isKeyword(colour) {
    return ~Object.keys(_colourNames2['default']).indexOf(colour.toLowerCase());
};
exports.isKeyword = isKeyword;