/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.content;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.content.ContentStyleKeys;
import org.jfree.layouting.input.style.keys.content.MoveToValues;
import org.jfree.layouting.input.style.values.CSSStringType;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.computed.CounterToken;
import org.jfree.layouting.layouter.content.computed.CountersToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedCounterToken;
import org.jfree.layouting.layouter.context.ContentSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class MoveToResolveHandler
implements ResolveHandler {
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    private boolean isCounterUsed(LayoutElement layoutElement, String string) {
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        ContentSpecification contentSpecification = layoutContext.getContentSpecification();
        ContentToken[] contentTokenArray = contentSpecification.getContents();
        for (int i = 0; i < contentTokenArray.length; ++i) {
            ContentToken contentToken;
            ContentToken contentToken2 = contentTokenArray[i];
            if (contentToken2 instanceof ResolvedCounterToken) {
                contentToken = (ResolvedCounterToken)contentToken2;
                contentToken2 = ((ResolvedCounterToken)contentToken).getParent();
            }
            if (!(contentToken2 instanceof CounterToken ? ((CounterToken)(contentToken = (CounterToken)contentToken2)).getName().equals(string) : contentToken2 instanceof CountersToken && ((CountersToken)(contentToken = (CountersToken)contentToken2)).getName().equals(string))) continue;
            return true;
        }
        return false;
    }

    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(ContentStyleKeys.MOVE_TO);
        if (MoveToValues.NORMAL.equals(cSSValue)) {
            if ("alternate".equals(layoutContext.getPseudoElement())) {
                if (this.isCounterUsed(layoutElement.getParent(), "footnote")) {
                    layoutContext.setValue(ContentStyleKeys.MOVE_TO, new CSSStringValue(CSSStringType.STRING, "footnotes"));
                    return;
                }
                if (this.isCounterUsed(layoutElement.getParent(), "endnote")) {
                    layoutContext.setValue(ContentStyleKeys.MOVE_TO, new CSSStringValue(CSSStringType.STRING, "endnotes"));
                    return;
                }
                if (this.isCounterUsed(layoutElement.getParent(), "section-note")) {
                    layoutContext.setValue(ContentStyleKeys.MOVE_TO, new CSSStringValue(CSSStringType.STRING, "section-notes"));
                    return;
                }
            }
            layoutContext.setValue(ContentStyleKeys.MOVE_TO, MoveToValues.HERE);
        }
    }
}

