/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.XCompletedExecution;
import com.sun.star.sdb.XResultSetAccess;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.sdbc.XRow;
import com.sun.star.sdbcx.XColumnsSupplier;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.InvalidQueryException;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.db.QueryMetaData;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordParser
extends QueryMetaData {
    private XNameAccess xColumns;
    private XRow xResultSetRow;
    public XResultSet ResultSet;
    private XInterface xRowSet;
    private XCompletedExecution xExecute;
    private XComponent xRowSetComponent;
    private XInteractionHandler xInteraction;
    public FieldColumn[] GroupFieldColumns;
    public FieldColumn[] RecordFieldColumns;

    public RecordParser(XMultiServiceFactory xMultiServiceFactory) {
        super(xMultiServiceFactory);
        this.getInterfaces();
    }

    private void getInterfaces() {
        try {
            this.xRowSet = (XInterface)this.xMSF.createInstance("com.sun.star.sdb.RowSet");
            UnoRuntime.queryInterface(XColumnsSupplier.class, (Object)this.xRowSet);
            this.xRowSetComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.xRowSet);
            this.xExecute = (XCompletedExecution)UnoRuntime.queryInterface(XCompletedExecution.class, (Object)this.xRowSet);
            XInterface xInterface = (XInterface)this.xMSF.createInstance("com.sun.star.task.InteractionHandler");
            this.xInteraction = (XInteractionHandler)UnoRuntime.queryInterface(XInteractionHandler.class, (Object)xInterface);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private Object getColumnStringValue(int n) {
        try {
            String string = this.xResultSetRow.getString(n);
            Type type = new Type(String.class);
            Object object = AnyConverter.toObject((Type)type, (Object)string);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    private Object getColumnDoubleValue(int n, boolean bl) {
        try {
            Double d = bl ? new Double(this.xResultSetRow.getDouble(n) + (double)super.getNullDateCorrection()) : new Double(this.xResultSetRow.getDouble(n));
            if (!this.xResultSetRow.wasNull()) {
                return d;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return Any.VOID;
    }

    private Object getColumnValue(int n, int n2) {
        Object object = Any.VOID;
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 92: {
                object = this.getColumnDoubleValue(n, false);
                break;
            }
            case 91: 
            case 93: {
                object = this.getColumnDoubleValue(n, true);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                object = this.getColumnStringValue(n);
            }
        }
        return object;
    }

    public boolean executeCommand(int n) throws InvalidQueryException {
        try {
            Helper.setUnoPropertyValue(this.xRowSet, "DataSourceName", this.DataSourceName);
            Helper.setUnoPropertyValue(this.xRowSet, PropertyNames.ACTIVE_CONNECTION, this.DBConnection);
            Helper.setUnoPropertyValue(this.xRowSet, PropertyNames.COMMAND, this.Command);
            Helper.setUnoPropertyValue(this.xRowSet, PropertyNames.COMMAND_TYPE, n);
            this.xExecute.executeWithCompletion(this.xInteraction);
            XResultSetAccess xResultSetAccess = (XResultSetAccess)UnoRuntime.queryInterface(XResultSetAccess.class, (Object)this.xRowSet);
            this.ResultSet = xResultSetAccess.createResultSet();
            this.xResultSetRow = (XRow)UnoRuntime.queryInterface(XRow.class, (Object)this.ResultSet);
            XColumnsSupplier xColumnsSupplier = (XColumnsSupplier)UnoRuntime.queryInterface(XColumnsSupplier.class, (Object)this.ResultSet);
            this.xColumns = xColumnsSupplier.getColumns();
            this.setCommandType(n);
            return true;
        }
        catch (Exception exception) {
            throw new InvalidQueryException(this.xMSF, this.Command, exception);
        }
    }

    public boolean getFields(String[] stringArray, boolean bl) {
        try {
            if (bl) {
                this.initializeFieldColumns(stringArray, this.xColumns);
            }
            String[] stringArray2 = this.xColumns.getElementNames();
            for (int i = 0; i < this.FieldColumns.length; ++i) {
                int n;
                String string = this.FieldColumns[i].getFieldName();
                this.FieldColumns[i].ColIndex = n = JavaTools.FieldInList(stringArray2, string) + 1;
                if (n != -1) continue;
                throw new InvalidQueryException(this.xMSF, this.Command);
            }
            this.GroupFieldColumns = this.getFieldColumnList(this.GroupFieldNames);
            this.RecordFieldColumns = this.getFieldColumnList(this.getRecordFieldNames());
            return true;
        }
        catch (InvalidQueryException invalidQueryException) {
            invalidQueryException.printStackTrace(System.err);
            return false;
        }
    }

    private FieldColumn[] getFieldColumnList(String[] stringArray) {
        FieldColumn[] fieldColumnArray = new FieldColumn[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fieldColumnArray[i] = super.getFieldColumnByFieldName(stringArray[i]);
        }
        return fieldColumnArray;
    }

    public Object getGroupColumnValue(int n) {
        FieldColumn fieldColumn = this.GroupFieldColumns[n];
        return this.getColumnValue(fieldColumn.ColIndex, fieldColumn.getFieldType());
    }

    public boolean getcurrentRecordData(ArrayList<Object[]> arrayList) {
        Object[] objectArray = new Object[this.RecordFieldColumns.length];
        for (int i = 0; i < this.RecordFieldColumns.length; ++i) {
            FieldColumn fieldColumn = this.RecordFieldColumns[i];
            objectArray[i] = this.getColumnValue(fieldColumn.ColIndex, fieldColumn.getFieldType());
        }
        arrayList.add(objectArray);
        return true;
    }

    @Override
    public void dispose() {
        if (this.xRowSetComponent != null) {
            this.xRowSetComponent.dispose();
        }
        super.dispose();
    }
}

