/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.document;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.WindowClass;
import com.sun.star.awt.WindowDescriptor;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XFrames;
import com.sun.star.frame.XFramesSupplier;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XTerminateListener;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.sheet.XCellRangeData;
import com.sun.star.table.XCellRange;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XModifiable;
import com.sun.star.wizards.common.Desktop;

public class OfficeDocument {
    public static void dispose(XMultiServiceFactory xMultiServiceFactory, XComponent xComponent) {
        try {
            if (xComponent != null) {
                XModifiable xModifiable = (XModifiable)UnoRuntime.queryInterface(XModifiable.class, (Object)xComponent);
                XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
                XFrame xFrame = xModel.getCurrentController().getFrame();
                if (xModifiable.isModified()) {
                    xModifiable.setModified(false);
                }
                Desktop.dispatchURL(xMultiServiceFactory, ".uno:CloseDoc", xFrame);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace(System.err);
        }
    }

    public static XFrame createNewFrame(XMultiServiceFactory xMultiServiceFactory, XTerminateListener xTerminateListener) {
        return OfficeDocument.createNewFrame(xMultiServiceFactory, xTerminateListener, "_blank");
    }

    private static XFrame createNewFrame(XMultiServiceFactory xMultiServiceFactory, XTerminateListener xTerminateListener, String string) {
        XFrame xFrame = null;
        if (string.equalsIgnoreCase("WIZARD_LIVE_PREVIEW")) {
            xFrame = OfficeDocument.createNewPreviewFrame(xMultiServiceFactory, xTerminateListener);
        } else {
            XFrame xFrame2 = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)Desktop.getDesktop(xMultiServiceFactory));
            xFrame = xFrame2.findFrame(string, 0);
            if (xTerminateListener != null) {
                XFramesSupplier xFramesSupplier = (XFramesSupplier)UnoRuntime.queryInterface(XFramesSupplier.class, (Object)xFrame2);
                XFrames xFrames = xFramesSupplier.getFrames();
                xFrames.remove(xFrame);
                XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)xFrame2);
                xDesktop.addTerminateListener(xTerminateListener);
            }
        }
        return xFrame;
    }

    private static XFrame createNewPreviewFrame(XMultiServiceFactory xMultiServiceFactory, XTerminateListener xTerminateListener) {
        XToolkit xToolkit = null;
        try {
            xToolkit = (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)xMultiServiceFactory.createInstance("com.sun.star.awt.Toolkit"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        WindowDescriptor windowDescriptor = new WindowDescriptor();
        windowDescriptor.Type = WindowClass.TOP;
        windowDescriptor.WindowServiceName = "window";
        windowDescriptor.ParentIndex = (short)-1;
        windowDescriptor.Parent = null;
        windowDescriptor.Bounds = new Rectangle(10, 10, 640, 480);
        windowDescriptor.WindowAttributes = 524400;
        XWindowPeer xWindowPeer = null;
        try {
            xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)xToolkit.createWindow(windowDescriptor));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xWindowPeer);
        XFrame xFrame = null;
        try {
            xFrame = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)xMultiServiceFactory.createInstance("com.sun.star.frame.Frame"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        xFrame.initialize(xWindow);
        if (xTerminateListener != null) {
            Desktop.getDesktop(xMultiServiceFactory).addTerminateListener(xTerminateListener);
        }
        return xFrame;
    }

    public static Object load(XInterface xInterface, String string, String string2, PropertyValue[] propertyValueArray) {
        Object object = null;
        XComponentLoader xComponentLoader = null;
        try {
            xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)xInterface);
            XComponent xComponent = xComponentLoader.loadComponentFromURL(string, string2, 0, propertyValueArray);
            XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)xComponent);
            if (xServiceInfo.supportsService("com.sun.star.text.TextDocument")) {
                object = UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return object;
    }

    public static boolean close(XComponent xComponent) {
        boolean bl = false;
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
        if (xModel != null) {
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)xModel);
            if (xCloseable != null) {
                try {
                    xCloseable.close(true);
                    bl = true;
                }
                catch (CloseVetoException closeVetoException) {
                    System.out.println("could not close doc");
                    bl = false;
                }
            } else {
                XComponent xComponent2 = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xModel);
                xComponent2.dispose();
                bl = true;
            }
        }
        return bl;
    }

    public static void ArraytoCellRange(Object[][] objectArray, Object object, int n, int n2) {
        try {
            int n3;
            int n4 = objectArray.length;
            if (n4 > 0 && (n3 = objectArray[0].length) > 0) {
                XCellRange xCellRange = (XCellRange)UnoRuntime.queryInterface(XCellRange.class, (Object)object);
                XCellRange xCellRange2 = xCellRange.getCellRangeByPosition(n, n2, n3 + n - 1, n4 + n2 - 1);
                XCellRangeData xCellRangeData = (XCellRangeData)UnoRuntime.queryInterface(XCellRangeData.class, (Object)xCellRange2);
                xCellRangeData.setDataArray(objectArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

