/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.logging.Logger;

public class InternalFlags {
    private static final Logger logger = Logger.getLogger(InternalFlags.class.getName());
    private static final IncludeStackTraceOption INCLUDE_STACK_TRACES = InternalFlags.parseIncludeStackTraceOption();
    private static final CustomClassLoadingOption CUSTOM_CLASS_LOADING = InternalFlags.parseCustomClassLoadingOption();

    public static IncludeStackTraceOption getIncludeStackTraceOption() {
        return INCLUDE_STACK_TRACES;
    }

    public static CustomClassLoadingOption getCustomClassLoadingOption() {
        return CUSTOM_CLASS_LOADING;
    }

    private static IncludeStackTraceOption parseIncludeStackTraceOption() {
        return InternalFlags.getSystemOption("guice_include_stack_traces", IncludeStackTraceOption.ONLY_FOR_DECLARING_SOURCE);
    }

    private static CustomClassLoadingOption parseCustomClassLoadingOption() {
        return InternalFlags.getSystemOption("guice_custom_class_loading", CustomClassLoadingOption.BRIDGE, CustomClassLoadingOption.OFF);
    }

    private static <T extends Enum<T>> T getSystemOption(String name, T defaultValue) {
        return InternalFlags.getSystemOption(name, defaultValue, defaultValue);
    }

    private static <T extends Enum<T>> T getSystemOption(final String name, T defaultValue, T secureValue) {
        Class<T> enumType = defaultValue.getDeclaringClass();
        String value = null;
        try {
            value = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(name);
                }
            });
            return value != null && value.length() > 0 ? Enum.valueOf(enumType, value) : defaultValue;
        }
        catch (SecurityException e) {
            return secureValue;
        }
        catch (IllegalArgumentException e) {
            logger.warning(value + " is not a valid flag value for " + name + ". " + " Values must be one of " + Arrays.asList(enumType.getEnumConstants()));
            return defaultValue;
        }
    }

    public static enum CustomClassLoadingOption {
        OFF,
        BRIDGE;

    }

    public static enum IncludeStackTraceOption {
        OFF,
        ONLY_FOR_DECLARING_SOURCE,
        COMPLETE;

    }
}

