/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RC2CBCParameter;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.jruby.ext.openssl.Cipher;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.ext.openssl.impl.CipherSpec;
import org.jruby.ext.openssl.impl.PKCS10Request;
import org.jruby.ext.openssl.impl.PKey;
import org.jruby.ext.openssl.x509store.X509Aux;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;

public class PEMInputOutput {
    public static final String BEF = "-----";
    public static final String AFT = "-----";
    public static final String BEF_G = "-----BEGIN ";
    public static final String BEF_E = "-----END ";
    public static final String PEM_STRING_X509_OLD = "X509 CERTIFICATE";
    public static final String PEM_STRING_X509 = "CERTIFICATE";
    public static final String PEM_STRING_X509_PAIR = "CERTIFICATE PAIR";
    public static final String PEM_STRING_X509_TRUSTED = "TRUSTED CERTIFICATE";
    public static final String PEM_STRING_X509_REQ_OLD = "NEW CERTIFICATE REQUEST";
    public static final String PEM_STRING_X509_REQ = "CERTIFICATE REQUEST";
    public static final String PEM_STRING_X509_CRL = "X509 CRL";
    public static final String PEM_STRING_EVP_PKEY = "ANY PRIVATE KEY";
    public static final String PEM_STRING_PUBLIC = "PUBLIC KEY";
    public static final String PEM_STRING_RSA = "RSA PRIVATE KEY";
    public static final String PEM_STRING_RSA_PUBLIC = "RSA PUBLIC KEY";
    public static final String PEM_STRING_DSA = "DSA PRIVATE KEY";
    public static final String PEM_STRING_DSA_PUBLIC = "DSA PUBLIC KEY";
    public static final String PEM_STRING_PKCS7 = "PKCS7";
    public static final String PEM_STRING_PKCS8 = "ENCRYPTED PRIVATE KEY";
    public static final String PEM_STRING_PKCS8INF = "PRIVATE KEY";
    public static final String PEM_STRING_DHPARAMS = "DH PARAMETERS";
    public static final String PEM_STRING_SSL_SESSION = "SSL SESSION PARAMETERS";
    public static final String PEM_STRING_DSAPARAMS = "DSA PARAMETERS";
    public static final String PEM_STRING_ECDSA_PUBLIC = "ECDSA PUBLIC KEY";
    public static final String PEM_STRING_ECPARAMETERS = "EC PARAMETERS";
    public static final String PEM_STRING_ECPRIVATEKEY = "EC PRIVATE KEY";
    private static final String BEG_STRING_PUBLIC = "-----BEGIN PUBLIC KEY";
    private static final String BEG_STRING_DSA = "-----BEGIN DSA PRIVATE KEY";
    private static final String BEG_STRING_RSA = "-----BEGIN RSA PRIVATE KEY";
    private static final String BEG_STRING_RSA_PUBLIC = "-----BEGIN RSA PUBLIC KEY";
    private static final String BEG_STRING_X509_OLD = "-----BEGIN X509 CERTIFICATE";
    private static final String BEG_STRING_X509 = "-----BEGIN CERTIFICATE";
    private static final String BEG_STRING_X509_TRUSTED = "-----BEGIN TRUSTED CERTIFICATE";
    private static final String BEG_STRING_X509_CRL = "-----BEGIN X509 CRL";
    private static final String BEG_STRING_X509_REQ = "-----BEGIN CERTIFICATE REQUEST";
    private static SecureRandom random;

    private static BufferedReader makeBuffered(Reader in) {
        if (in instanceof BufferedReader) {
            return (BufferedReader)in;
        }
        return new BufferedReader(in);
    }

    private static BufferedWriter makeBuffered(Writer out) {
        if (out instanceof BufferedWriter) {
            return (BufferedWriter)out;
        }
        return new BufferedWriter(out);
    }

    public static Object readPEM(Reader in, char[] passwd) throws IOException {
        return PEMInputOutput.readPEM(PEMInputOutput.makeBuffered(in), passwd);
    }

    public static Object readPEM(BufferedReader reader, char[] passwd) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(BEG_STRING_PUBLIC) != -1) {
                try {
                    return PEMInputOutput.readPublicKey(reader, "-----END PUBLIC KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating public key: " + e.toString(), e);
                }
            }
            if (line.indexOf(BEG_STRING_DSA) != -1) {
                try {
                    return PEMInputOutput.readKeyPair(reader, passwd, "DSA", "-----END DSA PRIVATE KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating DSA private key: " + e.toString(), e);
                }
            }
            if (line.indexOf(BEG_STRING_RSA_PUBLIC) != -1) {
                try {
                    return PEMInputOutput.readPublicKey(reader, "-----END RSA PUBLIC KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating RSA public key: " + e.toString(), e);
                }
            }
            if (line.indexOf(BEG_STRING_X509_OLD) != -1) {
                try {
                    return PEMInputOutput.readAuxCertificate(reader, "-----END X509 CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 Aux certificate: " + e.toString(), e);
                }
            }
            if (line.indexOf(BEG_STRING_X509) != -1) {
                try {
                    return PEMInputOutput.readAuxCertificate(reader, "-----END CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 Aux certificate: " + e.toString(), e);
                }
            }
            if (line.indexOf(BEG_STRING_X509_TRUSTED) != -1) {
                try {
                    return PEMInputOutput.readAuxCertificate(reader, "-----END TRUSTED CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 Aux certificate: " + e.toString(), e);
                }
            }
            if (line.indexOf(BEG_STRING_X509_CRL) != -1) {
                try {
                    return PEMInputOutput.readCRL(reader, "-----END X509 CRL");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 CRL: " + e.toString(), e);
                }
            }
            if (line.indexOf(BEG_STRING_X509_REQ) == -1) continue;
            try {
                return PEMInputOutput.readCertificateRequest(reader, "-----END CERTIFICATE REQUEST");
            }
            catch (Exception e) {
                throw new IOException("problem creating X509 REQ: " + e.toString(), e);
            }
        }
        return null;
    }

    public static byte[] readX509PEM(Reader in) throws IOException {
        String line;
        BufferedReader reader = PEMInputOutput.makeBuffered(in);
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(BEG_STRING_X509_OLD) != -1) {
                try {
                    return PEMInputOutput.readBase64Bytes(reader, "-----END X509 CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem reading PEM X509 Aux certificate: " + e.toString(), e);
                }
            }
            if (line.indexOf(BEG_STRING_X509) != -1) {
                try {
                    return PEMInputOutput.readBase64Bytes(reader, "-----END CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem reading PEM X509 Aux certificate: " + e.toString(), e);
                }
            }
            if (line.indexOf(BEG_STRING_X509_TRUSTED) != -1) {
                try {
                    return PEMInputOutput.readBase64Bytes(reader, "-----END TRUSTED CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem reading PEM X509 Aux certificate: " + e.toString(), e);
                }
            }
            if (line.indexOf(BEG_STRING_X509_CRL) != -1) {
                try {
                    return PEMInputOutput.readBase64Bytes(reader, "-----END X509 CRL");
                }
                catch (Exception e) {
                    throw new IOException("problem reading PEM X509 CRL: " + e.toString(), e);
                }
            }
            if (line.indexOf(BEG_STRING_X509_REQ) == -1) continue;
            try {
                return PEMInputOutput.readBase64Bytes(reader, "-----END CERTIFICATE REQUEST");
            }
            catch (Exception e) {
                throw new IOException("problem reading PEM X509 REQ: " + e.toString(), e);
            }
        }
        return null;
    }

    public static KeyPair readPrivateKey(Reader in, char[] passwd) throws IOException {
        String line;
        String BEG_STRING_ECPRIVATEKEY = "-----BEGIN EC PRIVATE KEY";
        String BEG_STRING_PKCS8INF = "-----BEGIN PRIVATE KEY";
        String BEG_STRING_PKCS8 = "-----BEGIN ENCRYPTED PRIVATE KEY";
        BufferedReader reader = PEMInputOutput.makeBuffered(in);
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(BEG_STRING_RSA) != -1) {
                try {
                    return PEMInputOutput.readKeyPair(reader, passwd, "RSA", "-----END RSA PRIVATE KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating RSA private key: " + e.toString(), e);
                }
            }
            if (line.indexOf(BEG_STRING_DSA) != -1) {
                try {
                    return PEMInputOutput.readKeyPair(reader, passwd, "DSA", "-----END DSA PRIVATE KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating DSA private key: " + e.toString(), e);
                }
            }
            if (line.indexOf("-----BEGIN EC PRIVATE KEY") != -1) {
                throw new UnsupportedOperationException("EC private key not supported");
            }
            if (line.indexOf("-----BEGIN PRIVATE KEY") != -1) {
                try {
                    byte[] bytes = PEMInputOutput.readBase64Bytes(reader, "-----END PRIVATE KEY");
                    PrivateKeyInfo info = PrivateKeyInfo.getInstance((Object)bytes);
                    String type = PEMInputOutput.getPrivateKeyTypeFromObjectId(info.getPrivateKeyAlgorithm().getAlgorithm());
                    return PKey.readPrivateKey(((ASN1Object)info.parsePrivateKey()).getEncoded("DER"), type);
                }
                catch (Exception e) {
                    throw new IOException("problem creating private key: " + e.toString(), e);
                }
            }
            if (line.indexOf("-----BEGIN ENCRYPTED PRIVATE KEY") == -1) continue;
            try {
                byte[] bytes = PEMInputOutput.readBase64Bytes(reader, "-----END ENCRYPTED PRIVATE KEY");
                EncryptedPrivateKeyInfo eIn = EncryptedPrivateKeyInfo.getInstance((Object)bytes);
                AlgorithmIdentifier algId = eIn.getEncryptionAlgorithm();
                PrivateKey privKey = algId.getAlgorithm().toString().equals("1.2.840.113549.1.5.13") ? PEMInputOutput.derivePrivateKeyPBES2(eIn, algId, passwd) : PEMInputOutput.derivePrivateKeyPBES1(eIn, algId, passwd);
                return new KeyPair(null, privKey);
            }
            catch (Exception e) {
                throw new IOException("problem creating private key: " + e.toString(), e);
            }
        }
        return null;
    }

    private static PrivateKey derivePrivateKeyPBES1(EncryptedPrivateKeyInfo eIn, AlgorithmIdentifier algId, char[] password) throws GeneralSecurityException, IOException {
        PKCS12PBEParams pkcs12Params = PKCS12PBEParams.getInstance((Object)algId.getParameters());
        PBEKeySpec pbeSpec = new PBEKeySpec(password);
        PBEParameterSpec pbeParams = new PBEParameterSpec(pkcs12Params.getIV(), pkcs12Params.getIterations().intValue());
        String algorithm = ASN1Registry.o2a(algId.getAlgorithm());
        algorithm = algorithm.split("-")[0];
        SecretKeyFactory secKeyFactory = SecurityHelper.getSecretKeyFactory(algorithm);
        Cipher cipher2 = SecurityHelper.getCipher(algorithm);
        cipher2.init(2, (Key)secKeyFactory.generateSecret(pbeSpec), pbeParams);
        PrivateKeyInfo pInfo = PrivateKeyInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])cipher2.doFinal(eIn.getEncryptedData())));
        KeyFactory keyFactory = PEMInputOutput.getKeyFactory(pInfo.getPrivateKeyAlgorithm());
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(pInfo.getEncoded()));
    }

    private static PrivateKey derivePrivateKeyPBES2(EncryptedPrivateKeyInfo eIn, AlgorithmIdentifier algId, char[] password) throws GeneralSecurityException, InvalidCipherTextException {
        PaddedBufferedBlockCipher cipher2;
        PBES2Parameters pbeParams = PBES2Parameters.getInstance((Object)((ASN1Sequence)algId.getParameters()));
        CipherParameters cipherParams = PEMInputOutput.extractPBES2CipherParams(password, pbeParams);
        EncryptionScheme scheme = pbeParams.getEncryptionScheme();
        if (scheme.getAlgorithm().equals((Object)PKCSObjectIdentifiers.RC2_CBC)) {
            RC2CBCParameter rc2Params = RC2CBCParameter.getInstance((Object)scheme);
            byte[] iv = rc2Params.getIV();
            ParametersWithIV param = new ParametersWithIV(cipherParams, iv);
            cipher2 = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new RC2Engine()));
            cipher2.init(false, (CipherParameters)param);
        } else {
            byte[] iv = ASN1OctetString.getInstance((Object)scheme.getParameters()).getOctets();
            ParametersWithIV param = new ParametersWithIV(cipherParams, iv);
            cipher2 = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new DESedeEngine()));
            cipher2.init(false, (CipherParameters)param);
        }
        byte[] data = eIn.getEncryptedData();
        byte[] out = new byte[cipher2.getOutputSize(data.length)];
        int len = cipher2.processBytes(data, 0, data.length, out, 0);
        len += cipher2.doFinal(out, len);
        byte[] pkcs8 = new byte[len];
        System.arraycopy(out, 0, pkcs8, 0, len);
        KeyFactory fact = SecurityHelper.getKeyFactory("RSA");
        return fact.generatePrivate(new PKCS8EncodedKeySpec(pkcs8));
    }

    private static CipherParameters extractPBES2CipherParams(char[] password, PBES2Parameters pbeParams) {
        PBKDF2Params pbkdfParams = PBKDF2Params.getInstance((Object)pbeParams.getKeyDerivationFunc().getParameters());
        int keySize = 192;
        if (pbkdfParams.getKeyLength() != null) {
            keySize = pbkdfParams.getKeyLength().intValue() * 8;
        }
        int iterationCount = pbkdfParams.getIterationCount().intValue();
        byte[] salt = pbkdfParams.getSalt();
        PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator();
        generator.init(PBEParametersGenerator.PKCS5PasswordToBytes((char[])password), salt, iterationCount);
        return generator.generateDerivedParameters(keySize);
    }

    public static PublicKey readPubKey(Reader in) throws IOException {
        PublicKey pubKey = PEMInputOutput.readRSAPubKey(in);
        if (pubKey == null) {
            pubKey = PEMInputOutput.readDSAPubKey(in);
        }
        return pubKey;
    }

    public static DSAPublicKey readDSAPubKey(Reader in) throws IOException {
        String line;
        String BEG_STRING_DSA_PUBLIC = "-----BEGIN DSA PUBLIC KEY";
        BufferedReader reader = PEMInputOutput.makeBuffered(in);
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("-----BEGIN DSA PUBLIC KEY") == -1) continue;
            try {
                return (DSAPublicKey)PEMInputOutput.readPublicKey(reader, "DSA", "-----END DSA PUBLIC KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating DSA public key: " + e.toString(), e);
            }
        }
        return null;
    }

    public static DSAPublicKey readDSAPublicKey(Reader in, char[] passwd) throws IOException {
        String line;
        BufferedReader reader = PEMInputOutput.makeBuffered(in);
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(BEG_STRING_PUBLIC) == -1) continue;
            try {
                return (DSAPublicKey)PEMInputOutput.readPublicKey(reader, "DSA", "-----END PUBLIC KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating DSA public key: " + e.toString(), e);
            }
        }
        return null;
    }

    public static KeyPair readDSAPrivateKey(Reader in, char[] passwd) throws IOException {
        String line;
        BufferedReader reader = PEMInputOutput.makeBuffered(in);
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(BEG_STRING_DSA) == -1) continue;
            try {
                return PEMInputOutput.readKeyPair(reader, passwd, "DSA", "-----END DSA PRIVATE KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating DSA private key: " + e.toString(), e);
            }
        }
        return null;
    }

    public static RSAPublicKey readRSAPubKey(Reader in) throws IOException {
        String line;
        BufferedReader reader = PEMInputOutput.makeBuffered(in);
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(BEG_STRING_PUBLIC) != -1) {
                try {
                    return PEMInputOutput.readRSAPublicKey(reader, "-----END PUBLIC KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating RSA public key: " + e.toString(), e);
                }
            }
            if (line.indexOf(BEG_STRING_RSA_PUBLIC) == -1) continue;
            try {
                return PEMInputOutput.readRSAPublicKey(reader, "-----END RSA PUBLIC KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating RSA public key: " + e.toString(), e);
            }
        }
        return null;
    }

    public static RSAPublicKey readRSAPublicKey(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader reader = PEMInputOutput.makeBuffered(in);
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(BEG_STRING_PUBLIC) != -1) {
                try {
                    return (RSAPublicKey)PEMInputOutput.readPublicKey(reader, "RSA", "-----END PUBLIC KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating RSA public key: " + e.toString(), e);
                }
            }
            if (line.indexOf(BEG_STRING_RSA_PUBLIC) == -1) continue;
            try {
                return (RSAPublicKey)PEMInputOutput.readPublicKey(reader, "RSA", "-----END RSA PUBLIC KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating RSA public key: " + e.toString(), e);
            }
        }
        return null;
    }

    public static KeyPair readRSAPrivateKey(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader reader = PEMInputOutput.makeBuffered(in);
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(BEG_STRING_RSA) == -1) continue;
            try {
                return PEMInputOutput.readKeyPair(reader, f, "RSA", "-----END RSA PRIVATE KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating RSA private key: " + e.toString(), e);
            }
        }
        return null;
    }

    public static CMSSignedData readPKCS7(Reader in, char[] f) throws IOException {
        String line;
        String BEG_STRING_PKCS7 = "-----BEGIN PKCS7";
        BufferedReader reader = PEMInputOutput.makeBuffered(in);
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("-----BEGIN PKCS7") == -1) continue;
            try {
                return PEMInputOutput.readPKCS7(reader, f, "-----END PKCS7");
            }
            catch (Exception e) {
                throw new IOException("problem creating PKCS7: " + e.toString(), e);
            }
        }
        return null;
    }

    public static X509AuxCertificate readX509Certificate(Reader in, char[] passwd) throws IOException {
        return PEMInputOutput.readX509Certificate(PEMInputOutput.makeBuffered(in), passwd);
    }

    public static X509AuxCertificate readX509Certificate(BufferedReader reader, char[] passwd) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(BEG_STRING_X509_OLD) != -1) {
                try {
                    return new X509AuxCertificate(PEMInputOutput.readCertificate(reader, "-----END X509 CERTIFICATE"));
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 certificate: " + e.toString(), e);
                }
            }
            if (line.indexOf(BEG_STRING_X509) != -1) {
                try {
                    return new X509AuxCertificate(PEMInputOutput.readCertificate(reader, "-----END CERTIFICATE"));
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 certificate: " + e.toString(), e);
                }
            }
            if (line.indexOf(BEG_STRING_X509_TRUSTED) == -1) continue;
            try {
                return new X509AuxCertificate(PEMInputOutput.readCertificate(reader, "-----END TRUSTED CERTIFICATE"));
            }
            catch (Exception e) {
                throw new IOException("problem creating X509 certificate: " + e.toString(), e);
            }
        }
        return null;
    }

    public static X509AuxCertificate readX509Aux(Reader in, char[] passwd) throws IOException {
        return PEMInputOutput.readX509Aux(PEMInputOutput.makeBuffered(in), passwd);
    }

    public static X509AuxCertificate readX509Aux(BufferedReader reader, char[] passwd) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(BEG_STRING_X509_OLD) != -1) {
                try {
                    return PEMInputOutput.readAuxCertificate(reader, "-----END X509 CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 Aux certificate: " + e.toString(), e);
                }
            }
            if (line.indexOf(BEG_STRING_X509) != -1) {
                try {
                    return PEMInputOutput.readAuxCertificate(reader, "-----END CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 Aux certificate: " + e.toString(), e);
                }
            }
            if (line.indexOf(BEG_STRING_X509_TRUSTED) == -1) continue;
            try {
                return PEMInputOutput.readAuxCertificate(reader, "-----END TRUSTED CERTIFICATE");
            }
            catch (Exception e) {
                throw new IOException("problem creating X509 Aux certificate: " + e.toString(), e);
            }
        }
        return null;
    }

    public static X509CRL readX509CRL(Reader reader, char[] passwd) throws IOException {
        return PEMInputOutput.readX509CRL(PEMInputOutput.makeBuffered(reader), passwd);
    }

    public static X509CRL readX509CRL(BufferedReader reader, char[] passwd) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(BEG_STRING_X509_CRL) == -1) continue;
            try {
                return PEMInputOutput.readCRL(reader, "-----END X509 CRL");
            }
            catch (Exception e) {
                throw new IOException("problem creating X509 CRL: " + e.toString(), e);
            }
        }
        return null;
    }

    public static PKCS10Request readX509Request(Reader in, char[] passwd) throws IOException {
        String line;
        BufferedReader reader = PEMInputOutput.makeBuffered(in);
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(BEG_STRING_X509_REQ) == -1) continue;
            try {
                return PEMInputOutput.readCertificateRequest(reader, "-----END CERTIFICATE REQUEST");
            }
            catch (Exception e) {
                throw new IOException("problem creating X509 REQ: " + e.toString(), e);
            }
        }
        return null;
    }

    public static DHParameterSpec readDHParameters(Reader in) throws IOException {
        String line;
        String BEG_STRING_DHPARAMS = "-----BEGIN DH PARAMETERS";
        BufferedReader reader = PEMInputOutput.makeBuffered(in);
        StringBuilder lines = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("-----BEGIN DH PARAMETERS") < 0) continue;
            String endParams = "-----END DH PARAMETERS";
            do {
                lines.append(line.trim());
            } while (line.indexOf("-----END DH PARAMETERS") < 0 && (line = reader.readLine()) != null);
        }
        Pattern DH_PARAMS_PATTERN = Pattern.compile("(-----BEGIN DH PARAMETERS-----)(.*)(-----END DH PARAMETERS-----)", 8);
        int DH_PARAMS_GROUP = 2;
        Matcher matcher = DH_PARAMS_PATTERN.matcher(lines.toString());
        if (matcher.find()) {
            try {
                byte[] decoded = Base64.decode((String)matcher.group(2));
                return PKey.readDHParameter(decoded);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static byte[] getEncoded(Key key) {
        if (key == null) {
            return new byte[]{48, 0};
        }
        return key.getEncoded();
    }

    private static byte[] getEncoded(ASN1Encodable obj) throws IOException {
        if (obj == null) {
            return new byte[]{48, 0};
        }
        return obj.toASN1Primitive().getEncoded();
    }

    private static byte[] getEncoded(CMSSignedData obj) throws IOException {
        if (obj == null) {
            return new byte[]{48, 0};
        }
        return obj.getEncoded();
    }

    private static byte[] getEncoded(X509Certificate cert2) throws IOException {
        if (cert2 == null) {
            return new byte[]{48, 0};
        }
        try {
            return cert2.getEncoded();
        }
        catch (GeneralSecurityException e) {
            throw new IOException("problem with encoding object in write_X509", e);
        }
    }

    private static byte[] getEncoded(X509CRL crl2) throws IOException {
        if (crl2 == null) {
            return new byte[]{48, 0};
        }
        try {
            return crl2.getEncoded();
        }
        catch (GeneralSecurityException e) {
            throw new IOException("problem with encoding object in write_X509_CRL", e);
        }
    }

    public static void writeDSAPublicKey(Writer _out, DSAPublicKey obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding = PEMInputOutput.getEncoded(obj);
        out.write("-----BEGIN DSA PUBLIC KEY-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding);
        out.write("-----END DSA PUBLIC KEY-----");
        out.newLine();
        out.flush();
    }

    public static void writeRSAPublicKey(Writer _out, RSAPublicKey obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding = PEMInputOutput.getEncoded(obj);
        out.write("-----BEGIN RSA PUBLIC KEY-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding);
        out.write("-----END RSA PUBLIC KEY-----");
        out.newLine();
        out.flush();
    }

    public static void writePKCS7(Writer _out, ContentInfo obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding = PEMInputOutput.getEncoded((ASN1Encodable)obj);
        out.write("-----BEGIN PKCS7-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding);
        out.write("-----END PKCS7-----");
        out.newLine();
        out.flush();
    }

    public static void writePKCS7(Writer _out, CMSSignedData obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding = PEMInputOutput.getEncoded(obj);
        out.write("-----BEGIN PKCS7-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding);
        out.write("-----END PKCS7-----");
        out.newLine();
        out.flush();
    }

    public static void writePKCS7(Writer _out, byte[] encoded) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        out.write("-----BEGIN PKCS7-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoded);
        out.write("-----END PKCS7-----");
        out.newLine();
        out.flush();
    }

    public static void writeX509Certificate(Writer _out, X509Certificate cert2) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding = PEMInputOutput.getEncoded(cert2);
        out.write("-----BEGIN CERTIFICATE-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding);
        out.write("-----END CERTIFICATE-----");
        out.newLine();
        out.flush();
    }

    public static void writeX509Aux(Writer _out, X509AuxCertificate cert2) throws IOException {
        byte[] encoding;
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        try {
            if (cert2.aux == null) {
                encoding = cert2.getEncoded();
            } else {
                ASN1EncodableVector a2;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] enc = cert2.getEncoded();
                baos.write(enc, 0, enc.length);
                X509Aux aux = cert2.aux;
                ASN1EncodableVector a1 = new ASN1EncodableVector();
                if (aux.trust.size() > 0) {
                    a2 = new ASN1EncodableVector();
                    for (String trust : aux.trust) {
                        a2.add((ASN1Encodable)new ASN1ObjectIdentifier(trust));
                    }
                    a1.add((ASN1Encodable)new DLSequence(a2));
                }
                if (aux.reject.size() > 0) {
                    a2 = new ASN1EncodableVector();
                    for (String reject : aux.reject) {
                        a2.add((ASN1Encodable)new ASN1ObjectIdentifier(reject));
                    }
                    a1.add((ASN1Encodable)new DERTaggedObject(0, (ASN1Encodable)new DLSequence(a2)));
                }
                if (aux.alias != null) {
                    a1.add((ASN1Encodable)new DERUTF8String(aux.alias));
                }
                if (aux.keyid != null) {
                    a1.add((ASN1Encodable)new DEROctetString(aux.keyid));
                }
                if (aux.other.size() > 0) {
                    a2 = new ASN1EncodableVector();
                    for (ASN1Primitive other : aux.other) {
                        a2.add((ASN1Encodable)other);
                    }
                    a1.add((ASN1Encodable)new DERTaggedObject(1, (ASN1Encodable)new DLSequence(a2)));
                }
                enc = new DLSequence(a1).getEncoded();
                baos.write(enc, 0, enc.length);
                encoding = baos.toByteArray();
            }
        }
        catch (CertificateEncodingException e) {
            throw new IOException("problem with encoding object in write_X509_AUX", e);
        }
        out.write("-----BEGIN TRUSTED CERTIFICATE-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding);
        out.write("-----END TRUSTED CERTIFICATE-----");
        out.newLine();
        out.flush();
    }

    public static void writeX509CRL(Writer _out, X509CRL obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding = PEMInputOutput.getEncoded(obj);
        out.write("-----BEGIN X509 CRL-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding);
        out.write("-----END X509 CRL-----");
        out.newLine();
        out.flush();
    }

    public static void writeX509Request(Writer _out, PKCS10Request obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding = PEMInputOutput.getEncoded((ASN1Encodable)obj.toASN1Structure());
        out.write("-----BEGIN CERTIFICATE REQUEST-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding);
        out.write("-----END CERTIFICATE REQUEST-----");
        out.newLine();
        out.flush();
    }

    public static void writeDSAPrivateKey(Writer _out, DSAPrivateKey obj, CipherSpec cipher2, char[] passwd) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        PrivateKeyInfo info = new PrivateKeyInfo((ASN1Sequence)new ASN1InputStream(PEMInputOutput.getEncoded(obj)).readObject());
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream((OutputStream)bOut);
        DSAParameter p = DSAParameter.getInstance((Object)info.getPrivateKeyAlgorithm().getParameters());
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(BigInteger.ZERO));
        v.add((ASN1Encodable)new ASN1Integer(p.getP()));
        v.add((ASN1Encodable)new ASN1Integer(p.getQ()));
        v.add((ASN1Encodable)new ASN1Integer(p.getG()));
        BigInteger x = obj.getX();
        BigInteger y = p.getG().modPow(x, p.getP());
        v.add((ASN1Encodable)new ASN1Integer(y));
        v.add((ASN1Encodable)new ASN1Integer(x));
        aOut.writeObject((ASN1Encodable)new DLSequence(v));
        byte[] encoding = bOut.toByteArray();
        if (cipher2 != null && passwd != null) {
            PEMInputOutput.writePemEncrypted(out, PEM_STRING_DSA, encoding, cipher2, passwd);
        } else {
            PEMInputOutput.writePemPlain(out, PEM_STRING_DSA, encoding);
        }
    }

    public static void writeRSAPrivateKey(Writer _out, RSAPrivateCrtKey obj, CipherSpec cipher2, char[] passwd) throws IOException {
        assert (obj != null);
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        RSAPrivateKey keyStruct = new RSAPrivateKey(obj.getModulus(), obj.getPublicExponent(), obj.getPrivateExponent(), obj.getPrimeP(), obj.getPrimeQ(), obj.getPrimeExponentP(), obj.getPrimeExponentQ(), obj.getCrtCoefficient());
        if (cipher2 != null && passwd != null) {
            PEMInputOutput.writePemEncrypted(out, PEM_STRING_RSA, keyStruct.getEncoded(), cipher2, passwd);
        } else {
            PEMInputOutput.writePemPlain(out, PEM_STRING_RSA, keyStruct.getEncoded());
        }
    }

    private static void writePemPlain(BufferedWriter out, String pemHeader, byte[] encoding) throws IOException {
        out.write(BEF_G + pemHeader + "-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding);
        out.write(BEF_E + pemHeader + "-----");
        out.newLine();
        out.flush();
    }

    private static void writePemEncrypted(BufferedWriter out, String pemHeader, byte[] encoding, CipherSpec cipherSpec, char[] passwd) throws IOException {
        byte[] encData;
        Cipher cipher2 = cipherSpec.getCipher();
        byte[] iv = new byte[cipher2.getBlockSize()];
        PEMInputOutput.secureRandom().nextBytes(iv);
        byte[] salt = new byte[8];
        System.arraycopy(iv, 0, salt, 0, 8);
        OpenSSLPBEParametersGenerator pGen = new OpenSSLPBEParametersGenerator();
        pGen.init(PBEParametersGenerator.PKCS5PasswordToBytes((char[])passwd), salt);
        KeyParameter param = (KeyParameter)pGen.generateDerivedParameters(cipherSpec.getKeyLenInBits());
        SecretKeySpec secretKey = new SecretKeySpec(param.getKey(), Cipher.Algorithm.getAlgorithmBase(cipher2));
        try {
            cipher2.init(1, (Key)secretKey, new IvParameterSpec(iv));
            encData = cipher2.doFinal(encoding);
        }
        catch (InvalidKeyException e) {
            String msg = e.getMessage();
            if (msg != null && msg.startsWith("Invalid key length")) {
                throw new IOException("Invalid key length. See http://wiki.jruby.org/UnlimitedStrengthCrypto", e);
            }
            throw new IOException("exception using cipher: " + cipherSpec.getOsslName() + " (" + e + ")", e);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("exception using cipher: " + cipherSpec.getOsslName() + " (" + e + ")", e);
        }
        out.write(BEF_G + pemHeader + "-----");
        out.newLine();
        out.write("Proc-Type: 4,ENCRYPTED");
        out.newLine();
        out.write("DEK-Info: " + cipherSpec.getOsslName() + ",");
        PEMInputOutput.writeHexEncoded(out, iv);
        out.newLine();
        out.newLine();
        PEMInputOutput.writeEncoded(out, encData);
        out.write(BEF_E + pemHeader + "-----");
        out.flush();
    }

    private static SecureRandom secureRandom() {
        if (random == null) {
            try {
                random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                random = new SecureRandom();
            }
        }
        return random;
    }

    public static void writeDHParameters(Writer _out, DHParameterSpec params2) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        ASN1EncodableVector v = new ASN1EncodableVector();
        BigInteger value2 = params2.getP();
        if (value2 != null) {
            v.add((ASN1Encodable)new ASN1Integer(value2));
        }
        if ((value2 = params2.getG()) != null) {
            v.add((ASN1Encodable)new ASN1Integer(value2));
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream((OutputStream)bOut);
        aOut.writeObject((ASN1Encodable)new DLSequence(v));
        byte[] encoding = bOut.toByteArray();
        out.write(BEF_G);
        out.write(PEM_STRING_DHPARAMS);
        out.write("-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding);
        out.write(BEF_E);
        out.write(PEM_STRING_DHPARAMS);
        out.write("-----");
        out.newLine();
        out.flush();
    }

    private static String getPrivateKeyTypeFromObjectId(ASN1ObjectIdentifier oid2) {
        if (ASN1Registry.oid2nid(oid2) == 6) {
            return "RSA";
        }
        return "DSA";
    }

    private static RSAPublicKey readRSAPublicKey(BufferedReader in, String endMarker) throws IOException {
        ASN1Primitive asnObject = new ASN1InputStream(PEMInputOutput.readBase64Bytes(in, endMarker)).readObject();
        ASN1Sequence sequence = (ASN1Sequence)asnObject;
        org.bouncycastle.asn1.pkcs.RSAPublicKey rsaPubStructure = org.bouncycastle.asn1.pkcs.RSAPublicKey.getInstance((Object)sequence);
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(rsaPubStructure.getModulus(), rsaPubStructure.getPublicExponent());
        try {
            return (RSAPublicKey)SecurityHelper.getKeyFactory("RSA").generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        return null;
    }

    private static PublicKey readPublicKey(byte[] input, String alg, String endMarker) throws IOException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(input);
        try {
            return SecurityHelper.getKeyFactory(alg).generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        return null;
    }

    private static PublicKey readPublicKey(BufferedReader in, String alg, String endMarker) throws IOException {
        return PEMInputOutput.readPublicKey(PEMInputOutput.readBase64Bytes(in, endMarker), alg, endMarker);
    }

    private static PublicKey readPublicKey(BufferedReader in, String endMarker) throws IOException {
        byte[] input = PEMInputOutput.readBase64Bytes(in, endMarker);
        String[] algs = new String[]{"RSA", "DSA"};
        for (int i2 = 0; i2 < algs.length; ++i2) {
            PublicKey key = PEMInputOutput.readPublicKey(input, algs[i2], endMarker);
            if (key == null) continue;
            return key;
        }
        return null;
    }

    private static KeyPair readKeyPair(BufferedReader in, char[] passwd, String type, String endMarker) throws Exception {
        String line;
        boolean isEncrypted = false;
        String dekInfo = null;
        StringBuilder buffer = new StringBuilder(512);
        while ((line = in.readLine()) != null) {
            if (line.startsWith("Proc-Type: 4,ENCRYPTED")) {
                isEncrypted = true;
                continue;
            }
            if (line.startsWith("DEK-Info:")) {
                dekInfo = line.substring(10);
                continue;
            }
            if (line.contains(endMarker)) break;
            buffer.append(line.trim());
        }
        byte[] decoded = Base64.decode((String)buffer.toString());
        byte[] keyBytes = isEncrypted ? PEMInputOutput.decrypt(decoded, dekInfo, passwd) : decoded;
        return PKey.readPrivateKey(keyBytes, type);
    }

    private static byte[] decrypt(byte[] decoded, String dekInfo, char[] passwd) throws IOException, GeneralSecurityException {
        if (passwd == null) {
            throw new IOException("Password is null, but a password is required");
        }
        StringTokenizer tknz = new StringTokenizer(dekInfo, ",");
        String algorithm = tknz.nextToken();
        byte[] iv = Hex.decode((String)tknz.nextToken());
        String realName = Cipher.Algorithm.getRealName(algorithm);
        int[] lengths = Cipher.Algorithm.osslKeyIvLength(algorithm);
        int keyLen = lengths[0];
        int ivLen = lengths[1];
        if (iv.length != ivLen) {
            throw new IOException("Illegal IV length");
        }
        byte[] salt = new byte[8];
        System.arraycopy(iv, 0, salt, 0, 8);
        OpenSSLPBEParametersGenerator pGen = new OpenSSLPBEParametersGenerator();
        pGen.init(PBEParametersGenerator.PKCS5PasswordToBytes((char[])passwd), salt);
        KeyParameter param = (KeyParameter)pGen.generateDerivedParameters(keyLen * 8);
        SecretKeySpec secretKey = new SecretKeySpec(param.getKey(), realName);
        Cipher cipher2 = SecurityHelper.getCipher(realName);
        cipher2.init(2, (Key)secretKey, new IvParameterSpec(iv));
        return cipher2.doFinal(decoded);
    }

    private static X509Certificate readCertificate(BufferedReader in, String endMarker) throws IOException {
        byte[] bytes = PEMInputOutput.readBase64Bytes(in, endMarker);
        try {
            return (X509Certificate)PEMInputOutput.getX509CertificateFactory().generateCertificate(new ByteArrayInputStream(bytes));
        }
        catch (CertificateException e) {
            throw new IOException("failed to read certificate: " + e, e);
        }
    }

    private static X509AuxCertificate readAuxCertificate(BufferedReader in, String endMarker) throws IOException {
        byte[] bytes = PEMInputOutput.readBase64Bytes(in, endMarker);
        ASN1InputStream asn1 = new ASN1InputStream(bytes);
        ByteArrayInputStream certBytes = new ByteArrayInputStream(asn1.readObject().getEncoded());
        try {
            X509Aux aux;
            X509Certificate cert2 = (X509Certificate)PEMInputOutput.getX509CertificateFactory().generateCertificate(certBytes);
            ASN1Sequence auxSeq = (ASN1Sequence)asn1.readObject();
            if (auxSeq != null) {
                List other;
                byte[] keyid;
                String alias;
                List reject;
                int i2;
                List trust;
                int ix = 0;
                ASN1Encodable obj = null;
                if (auxSeq.size() > ix) {
                    obj = auxSeq.getObjectAt(ix);
                }
                if (obj instanceof ASN1Sequence) {
                    trust = new ArrayList();
                    ASN1Sequence trustSeq = (ASN1Sequence)obj;
                    for (i2 = 0; i2 < trustSeq.size(); ++i2) {
                        trust.add(((ASN1ObjectIdentifier)trustSeq.getObjectAt(i2)).getId());
                    }
                    obj = auxSeq.size() > ++ix ? auxSeq.getObjectAt(ix) : null;
                } else {
                    trust = Collections.emptyList();
                }
                if (obj instanceof ASN1TaggedObject && ((ASN1TaggedObject)obj).getTagNo() == 0) {
                    reject = new ArrayList();
                    ASN1Sequence rejectSeq = (ASN1Sequence)((ASN1TaggedObject)obj).getObject();
                    for (i2 = 0; i2 < rejectSeq.size(); ++i2) {
                        reject.add(((ASN1ObjectIdentifier)rejectSeq.getObjectAt(i2)).getId());
                    }
                    obj = auxSeq.size() > ++ix ? auxSeq.getObjectAt(ix) : null;
                } else {
                    reject = Collections.emptyList();
                }
                if (obj instanceof DERUTF8String) {
                    alias = ((DERUTF8String)obj).getString();
                    obj = auxSeq.size() > ++ix ? auxSeq.getObjectAt(ix) : null;
                } else {
                    alias = null;
                }
                if (obj instanceof DEROctetString) {
                    keyid = ((DEROctetString)obj).getOctets();
                    obj = auxSeq.size() > ++ix ? auxSeq.getObjectAt(ix) : null;
                } else {
                    keyid = null;
                }
                if (obj instanceof ASN1TaggedObject && ((ASN1TaggedObject)obj).getTagNo() == 1) {
                    other = new ArrayList();
                    ASN1Sequence otherSeq = (ASN1Sequence)((ASN1TaggedObject)obj).getObject();
                    for (i2 = 0; i2 < otherSeq.size(); ++i2) {
                        other.add((ASN1Primitive)otherSeq.getObjectAt(i2));
                    }
                } else {
                    other = Collections.emptyList();
                }
                aux = new X509Aux(alias, keyid, Collections.unmodifiableList(trust), Collections.unmodifiableList(reject), Collections.unmodifiableList(other));
            } else {
                aux = null;
            }
            return new X509AuxCertificate(cert2, aux);
        }
        catch (CertificateException e) {
            throw new IOException("failed to read aux cert: " + e, e);
        }
    }

    private static X509CRL readCRL(BufferedReader in, String endMarker) throws IOException {
        byte[] bytes = PEMInputOutput.readBase64Bytes(in, endMarker);
        try {
            return (X509CRL)PEMInputOutput.getX509CertificateFactory().generateCRL(new ByteArrayInputStream(bytes));
        }
        catch (CRLException e) {
            throw new IOException("failed to read crl: " + e, e);
        }
    }

    private static PKCS10Request readCertificateRequest(BufferedReader in, String endMarker) throws IOException {
        byte[] bytes = PEMInputOutput.readBase64Bytes(in, endMarker);
        try {
            return new PKCS10Request(bytes);
        }
        catch (RuntimeException e) {
            throw new IOException("problem parsing cert: " + e.toString(), e);
        }
    }

    private static CMSSignedData readPKCS7(BufferedReader in, char[] p, String endMarker) throws IOException {
        String line;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        StringBuilder buffer = new StringBuilder();
        while ((line = in.readLine()) != null && !line.contains(endMarker)) {
            buffer.append(line.trim());
            int len = buffer.length();
            Base64.decode((String)buffer.substring(0, len / 4 * 4), (OutputStream)bytes);
            buffer.delete(0, len / 4 * 4);
        }
        if (buffer.length() != 0) {
            throw new IOException("base64 data appears to be truncated");
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        try {
            ASN1InputStream aIn = new ASN1InputStream(bytes.toByteArray());
            return new CMSSignedData(ContentInfo.getInstance((Object)aIn.readObject()));
        }
        catch (CMSException e) {
            throw new IOException("problem parsing PKCS7 object: " + (Object)((Object)e), e);
        }
    }

    public static KeyFactory getKeyFactory(AlgorithmIdentifier algId) throws NoSuchAlgorithmException {
        ASN1ObjectIdentifier algIdentifier = algId.getAlgorithm();
        String algorithm = null;
        if (X9ObjectIdentifiers.id_ecPublicKey.equals((Object)algIdentifier)) {
            algorithm = "ECDSA";
        } else if (PKCSObjectIdentifiers.rsaEncryption.equals((Object)algIdentifier)) {
            algorithm = "RSA";
        } else if (X9ObjectIdentifiers.id_dsa.equals((Object)algIdentifier)) {
            algorithm = "DSA";
        }
        if (algorithm == null) {
            algorithm = algIdentifier.getId();
        }
        return SecurityHelper.getKeyFactory(algorithm);
    }

    private static CertificateFactory getX509CertificateFactory() {
        try {
            return SecurityHelper.getCertificateFactory("X.509");
        }
        catch (CertificateException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void writeHexEncoded(BufferedWriter out, byte[] bytes) throws IOException {
        bytes = Hex.encode((byte[])bytes);
        for (int i2 = 0; i2 != bytes.length; ++i2) {
            out.write((char)bytes[i2]);
        }
    }

    private static void writeEncoded(BufferedWriter out, byte[] bytes) throws IOException {
        char[] buf = new char[64];
        bytes = Base64.encode((byte[])bytes);
        for (int i2 = 0; i2 < bytes.length; i2 += buf.length) {
            int index;
            for (index = 0; index != buf.length && i2 + index < bytes.length; ++index) {
                buf[index] = (char)bytes[i2 + index];
            }
            out.write(buf, 0, index);
            out.newLine();
        }
    }

    private static byte[] readBase64Bytes(BufferedReader in, String endMarker) throws IOException {
        return Base64.decode((String)PEMInputOutput.readLines(in, endMarker).toString());
    }

    private static StringBuilder readLines(BufferedReader reader, String endMarker) throws IOException {
        String line;
        StringBuilder lines = new StringBuilder(64);
        while ((line = reader.readLine()) != null && !line.contains(endMarker)) {
            lines.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        return lines;
    }
}

