/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyEncoding;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNil;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Encoder {
    private static final int CACHE_LINE_SIZE = 64;
    private static final int ARRAY_HEADER_SIZE = 24;
    private final Ruby runtime;
    private final Encoding binaryEncoding;
    private final Encoding utf8Encoding;
    private ByteBuffer buffer;

    public Encoder(Ruby ruby) {
        this.runtime = ruby;
        this.buffer = ByteBuffer.allocate(40);
        this.binaryEncoding = ruby.getEncodingService().getAscii8bitEncoding();
        this.utf8Encoding = UTF8Encoding.INSTANCE;
    }

    private void ensureRemainingCapacity(int n) {
        if (this.buffer.remaining() < n) {
            int n2 = Math.max(this.buffer.capacity() + (this.buffer.capacity() >> 1), this.buffer.capacity() + n);
            n2 += 64 - (24 + n2) % 64;
            this.buffer = ByteBuffer.allocate(n2).put(this.buffer.array(), 0, this.buffer.position());
        }
    }

    public IRubyObject encode(IRubyObject iRubyObject) {
        this.encodeObject(iRubyObject);
        return this.runtime.newString(new ByteList(this.buffer.array(), 0, this.buffer.position(), this.binaryEncoding, false));
    }

    private void encodeObject(IRubyObject iRubyObject) {
        if (iRubyObject == null || iRubyObject instanceof RubyNil) {
            this.ensureRemainingCapacity(1);
            this.buffer.put((byte)-64);
        } else if (iRubyObject instanceof RubyBoolean) {
            this.ensureRemainingCapacity(1);
            this.buffer.put(((RubyBoolean)iRubyObject).isTrue() ? (byte)-61 : -62);
        } else if (iRubyObject instanceof RubyBignum) {
            this.encodeBignum((RubyBignum)iRubyObject);
        } else if (iRubyObject instanceof RubyInteger) {
            this.encodeInteger((RubyInteger)iRubyObject);
        } else if (iRubyObject instanceof RubyFloat) {
            this.encodeFloat((RubyFloat)iRubyObject);
        } else if (iRubyObject instanceof RubyString) {
            this.encodeString((RubyString)iRubyObject);
        } else if (iRubyObject instanceof RubySymbol) {
            this.encodeString(((RubySymbol)iRubyObject).asString());
        } else if (iRubyObject instanceof RubyArray) {
            this.encodeArray((RubyArray)iRubyObject);
        } else if (iRubyObject instanceof RubyHash) {
            this.encodeHash((RubyHash)iRubyObject);
        } else if (iRubyObject.respondsTo("to_msgpack")) {
            this.appendCustom(iRubyObject);
        } else {
            throw this.runtime.newArgumentError(String.format("Cannot pack type: %s", iRubyObject.getClass().getName()));
        }
    }

    private void encodeBignum(RubyBignum rubyBignum) {
        BigInteger bigInteger = rubyBignum.getBigIntegerValue();
        if (bigInteger.bitLength() > 64 || bigInteger.bitLength() > 63 && bigInteger.signum() < 0) {
            throw this.runtime.newArgumentError(String.format("Cannot pack big integer: %s", bigInteger));
        }
        this.ensureRemainingCapacity(9);
        this.buffer.put(bigInteger.signum() < 0 ? (byte)-45 : -49);
        byte[] byArray = bigInteger.toByteArray();
        this.buffer.put(byArray, byArray.length - 8, 8);
    }

    private void encodeInteger(RubyInteger rubyInteger) {
        long l = rubyInteger.getLongValue();
        if (l < 0L) {
            if (l < -32768L) {
                if (l < Integer.MIN_VALUE) {
                    this.ensureRemainingCapacity(9);
                    this.buffer.put((byte)-45);
                    this.buffer.putLong(l);
                } else {
                    this.ensureRemainingCapacity(5);
                    this.buffer.put((byte)-46);
                    this.buffer.putInt((int)l);
                }
            } else if (l >= -32L) {
                this.ensureRemainingCapacity(1);
                byte by = (byte)(l | 0xE0L);
                this.buffer.put(by);
            } else if (l < -128L) {
                this.ensureRemainingCapacity(3);
                this.buffer.put((byte)-47);
                this.buffer.putShort((short)l);
            } else {
                this.ensureRemainingCapacity(2);
                this.buffer.put((byte)-48);
                this.buffer.put((byte)l);
            }
        } else if (l < 65536L) {
            if (l < 128L) {
                this.ensureRemainingCapacity(1);
                this.buffer.put((byte)l);
            } else if (l < 256L) {
                this.ensureRemainingCapacity(2);
                this.buffer.put((byte)-52);
                this.buffer.put((byte)l);
            } else {
                this.ensureRemainingCapacity(3);
                this.buffer.put((byte)-51);
                this.buffer.putShort((short)l);
            }
        } else if (l < 0x100000000L) {
            this.ensureRemainingCapacity(5);
            this.buffer.put((byte)-50);
            this.buffer.putInt((int)l);
        } else {
            this.ensureRemainingCapacity(9);
            this.buffer.put((byte)-45);
            this.buffer.putLong(l);
        }
    }

    private void encodeFloat(RubyFloat rubyFloat) {
        double d = rubyFloat.getDoubleValue();
        float f = (float)d;
        if (Double.compare(f, d) == 0) {
            this.ensureRemainingCapacity(5);
            this.buffer.put((byte)-54);
            this.buffer.putFloat(f);
        } else {
            this.ensureRemainingCapacity(9);
            this.buffer.put((byte)-53);
            this.buffer.putDouble(d);
        }
    }

    private void encodeString(RubyString rubyString) {
        ByteList byteList;
        int n;
        boolean bl;
        Encoding encoding = rubyString.getEncoding();
        boolean bl2 = bl = encoding == this.binaryEncoding;
        if (encoding != this.utf8Encoding && encoding != this.binaryEncoding) {
            rubyString = (RubyString)rubyString.encode(this.runtime.getCurrentContext(), (IRubyObject)RubyEncoding.newEncoding((Ruby)this.runtime, (Encoding)this.utf8Encoding));
        }
        if ((n = (byteList = rubyString.getByteList()).length()) < 32 && !bl) {
            this.ensureRemainingCapacity(1 + n);
            this.buffer.put((byte)(n | 0xA0));
        } else if (n < 255) {
            this.ensureRemainingCapacity(2 + n);
            this.buffer.put(bl ? (byte)-60 : -39);
            this.buffer.put((byte)n);
        } else if (n < 65535) {
            this.ensureRemainingCapacity(3 + n);
            this.buffer.put(bl ? (byte)-59 : -38);
            this.buffer.putShort((short)n);
        } else {
            this.ensureRemainingCapacity(5 + n);
            this.buffer.put(bl ? (byte)-58 : -37);
            this.buffer.putInt(n);
        }
        this.buffer.put(byteList.unsafeBytes(), byteList.begin(), n);
    }

    private void encodeArray(RubyArray rubyArray) {
        int n = rubyArray.size();
        if (n < 16) {
            this.ensureRemainingCapacity(1);
            this.buffer.put((byte)(n | 0x90));
        } else if (n < 65536) {
            this.ensureRemainingCapacity(3);
            this.buffer.put((byte)-36);
            this.buffer.putShort((short)n);
        } else {
            this.ensureRemainingCapacity(5);
            this.buffer.put((byte)-35);
            this.buffer.putInt(n);
        }
        for (int i = 0; i < n; ++i) {
            this.encodeObject(rubyArray.eltOk((long)i));
        }
    }

    private void encodeHash(RubyHash rubyHash) {
        int n = rubyHash.size();
        if (n < 16) {
            this.ensureRemainingCapacity(1);
            this.buffer.put((byte)(n | 0x80));
        } else if (n < 65536) {
            this.ensureRemainingCapacity(3);
            this.buffer.put((byte)-34);
            this.buffer.putShort((short)n);
        } else {
            this.ensureRemainingCapacity(5);
            this.buffer.put((byte)-33);
            this.buffer.putInt(n);
        }
        HashVisitor hashVisitor = new HashVisitor(n);
        rubyHash.visitAll((RubyHash.Visitor)hashVisitor);
        if (hashVisitor.remain != 0) {
            rubyHash.getRuntime().newConcurrencyError("Hash size changed while packing");
        }
    }

    private void appendCustom(IRubyObject iRubyObject) {
        RubyString rubyString = (RubyString)iRubyObject.callMethod(this.runtime.getCurrentContext(), "to_msgpack");
        ByteList byteList = rubyString.getByteList();
        int n = byteList.length();
        this.ensureRemainingCapacity(n);
        this.buffer.put(byteList.unsafeBytes(), byteList.begin(), n);
    }

    private class HashVisitor
    extends RubyHash.Visitor {
        public int remain;

        public HashVisitor(int n) {
            this.remain = n;
        }

        public void visit(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            if (this.remain-- > 0) {
                Encoder.this.encodeObject(iRubyObject);
                Encoder.this.encodeObject(iRubyObject2);
            }
        }
    }
}

