/*
 * Decompiled with CFR 0.152.
 */
package com.jrjackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.jrjackson.RubyDateFormat;
import com.jrjackson.RubyUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.RubyTime;
import org.jruby.ext.bigdecimal.RubyBigDecimal;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyAnySerializer
extends JsonSerializer<IRubyObject> {
    public static final RubyAnySerializer instance = new RubyAnySerializer();

    private void serializeUnknownRubyObject(ThreadContext ctx, IRubyObject rubyObject, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        RubyClass meta = rubyObject.getMetaClass();
        DynamicMethod method = meta.searchMethod("to_json_data");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, rubyObject, (RubyModule)meta, "to_json_data");
            if (obj instanceof RubyString) {
                RubyUtils.writeBytes((IRubyObject)obj, jgen);
            } else {
                this.serialize((IRubyObject)obj, jgen, provider);
            }
            return;
        }
        method = meta.searchMethod("to_time");
        if (!method.isUndefined()) {
            RubyTime dt = (RubyTime)method.call(ctx, rubyObject, (RubyModule)meta, "to_time");
            this.serializeTime(dt, jgen, provider);
            return;
        }
        method = meta.searchMethod("to_h");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, rubyObject, (RubyModule)meta, "to_h");
            this.serializeHash((IRubyObject)obj, jgen, provider);
            return;
        }
        method = meta.searchMethod("to_hash");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, rubyObject, (RubyModule)meta, "to_hash");
            this.serializeHash((IRubyObject)obj, jgen, provider);
            return;
        }
        method = meta.searchMethod("to_a");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, rubyObject, (RubyModule)meta, "to_a");
            this.serializeArray((IRubyObject)obj, jgen, provider);
            return;
        }
        method = meta.searchMethod("to_json");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, rubyObject, (RubyModule)meta, "to_json");
            if (obj instanceof RubyString) {
                jgen.writeRawValue(obj.toString());
            } else {
                this.serialize((IRubyObject)obj, jgen, provider);
            }
            return;
        }
        throw new JsonGenerationException("Cannot find Serializer for class: " + rubyObject.getClass().getName());
    }

    @Override
    public void serialize(IRubyObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (value.isNil()) {
            jgen.writeNull();
        } else if (value instanceof JavaProxy) {
            provider.defaultSerializeValue(((JavaProxy)value).getObject(), jgen);
        } else if (value instanceof RubyString) {
            RubyUtils.writeBytes(value, jgen);
        } else if (value instanceof RubySymbol) {
            RubyString s = ((RubySymbol)value).asString();
            jgen.writeUTF8String(s.getBytes(), 0, s.size());
        } else if (value instanceof RubyBoolean) {
            jgen.writeBoolean(value.isTrue());
        } else if (value instanceof RubyFloat) {
            jgen.writeNumber(RubyNumeric.num2dbl((IRubyObject)value));
        } else if (value instanceof RubyFixnum) {
            jgen.writeNumber(RubyNumeric.num2long((IRubyObject)value));
        } else if (value instanceof RubyBignum) {
            jgen.writeNumber(((RubyBignum)value).getBigIntegerValue());
        } else if (value instanceof RubyBigDecimal) {
            jgen.writeNumber(((RubyBigDecimal)value).getBigDecimalValue());
        } else if (value instanceof RubyHash) {
            this.serializeHash(value, jgen, provider);
        } else if (value instanceof RubyArray) {
            this.serializeArray(value, jgen, provider);
        } else if (value instanceof RubyStruct) {
            IRubyObject obj = value.callMethod(value.getRuntime().getCurrentContext(), "to_a");
            this.serializeArray(obj, jgen, provider);
        } else if (value instanceof RubyTime) {
            this.serializeTime((RubyTime)value, jgen, provider);
        } else {
            this.serializeUnknownRubyObject(value.getRuntime().getCurrentContext(), value, jgen, provider);
        }
    }

    private void serializeArray(IRubyObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        RubyArray arr = (RubyArray)value;
        IRubyObject[] a = arr.toJavaArray();
        jgen.writeStartArray();
        for (IRubyObject val : a) {
            this.serialize(val, jgen, provider);
        }
        jgen.writeEndArray();
    }

    private void serializeHash(IRubyObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        RubyHash h = (RubyHash)value;
        jgen.writeStartObject();
        for (Object o : h.directEntrySet()) {
            RubyHash.RubyHashEntry next = (RubyHash.RubyHashEntry)o;
            this.serializeKey((IRubyObject)next.getKey(), jgen, provider);
            this.serialize((IRubyObject)next.getValue(), jgen, provider);
        }
        jgen.writeEndObject();
    }

    private void serializeTime(RubyTime dt, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        DateFormat df = provider.getConfig().getDateFormat();
        if (df == null) {
            provider.defaultSerializeDateValue(dt.getJavaDate(), jgen);
        } else if (df instanceof RubyDateFormat) {
            RubyDateFormat rdf = (RubyDateFormat)df.clone();
            jgen.writeString(rdf.format(dt.getJavaDate()));
        } else {
            SimpleDateFormat sdf = (SimpleDateFormat)df.clone();
            jgen.writeString(df.format(dt.getJavaDate()));
        }
    }

    private void serializeKey(IRubyObject key, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (key instanceof RubyString) {
            jgen.writeFieldName(((RubyString)key).decodeString());
        } else {
            jgen.writeFieldName(key.toString());
        }
    }

    @Override
    public void serializeWithType(IRubyObject value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForScalar(value, jgen);
        this.serialize(value, jgen, provider);
        typeSer.writeTypeSuffixForScalar(value, jgen);
    }
}

