/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.cli;

import com.headius.options.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jruby.RubyInstanceConfig;
import org.jruby.runtime.Constants;
import org.jruby.util.KCode;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.cli.Category;

public class Options {
    private static final List<Option> _loadedOptions = new ArrayList<Option>();
    private static final boolean INVOKEDYNAMIC_DEFAULT = Options.calculateInvokedynamicDefault();
    public static final Option<String> COMPILE_MODE = Options.string(Category.COMPILER, "compile.mode", new String[]{"JIT", "FORCE", "OFF", "OFFIR"}, "JIT", "Set compilation mode. JIT = at runtime; FORCE = before execution.");
    public static final Option<Boolean> COMPILE_DUMP = Options.bool(Category.COMPILER, "compile.dump", false, "Dump to console all bytecode generated at runtime.");
    public static final Option<Boolean> COMPILE_THREADLESS = Options.bool(Category.COMPILER, "compile.threadless", false, "(EXPERIMENTAL) Turn on compilation without polling for \"unsafe\" thread events.");
    public static final Option<Boolean> COMPILE_FASTOPS = Options.bool(Category.COMPILER, "compile.fastops", true, "Turn on fast operators for Fixnum and Float.");
    public static final Option<Integer> COMPILE_CHAINSIZE = Options.integer(Category.COMPILER, "compile.chainsize", 500, "Set the number of lines at which compiled bodies are \"chained\".");
    public static final Option<Boolean> COMPILE_LAZYHANDLES = Options.bool(Category.COMPILER, "compile.lazyHandles", false, "Generate method bindings (handles) for compiled methods lazily.");
    public static final Option<Boolean> COMPILE_PEEPHOLE = Options.bool(Category.COMPILER, "compile.peephole", true, "Enable or disable peephole optimizations.");
    public static final Option<Boolean> COMPILE_NOGUARDS = Options.bool(Category.COMPILER, "compile.noguards", false, "Compile calls without guards, for experimentation.");
    public static final Option<Boolean> COMPILE_FASTEST = Options.bool(Category.COMPILER, "compile.fastest", false, "Compile with all \"mostly harmless\" compiler optimizations.");
    public static final Option<Boolean> COMPILE_FASTSEND = Options.bool(Category.COMPILER, "compile.fastsend", false, "Compile obj.__send__(<literal>, ...) as obj.<literal>(...).");
    public static final Option<Boolean> COMPILE_FASTMASGN = Options.bool(Category.COMPILER, "compile.fastMasgn", false, "Return true from multiple assignment instead of a new array.");
    public static final Option<Boolean> COMPILE_INVOKEDYNAMIC = Options.bool(Category.COMPILER, "compile.invokedynamic", INVOKEDYNAMIC_DEFAULT, "Use invokedynamic for optimizing Ruby code.");
    public static final Option<Integer> COMPILE_OUTLINE_CASECOUNT = Options.integer(Category.COMPILER, "compile.outline.casecount", 50, "Outline when bodies when number of cases exceeds this value.");
    public static final Option<Integer> INVOKEDYNAMIC_MAXFAIL = Options.integer(Category.INVOKEDYNAMIC, "invokedynamic.maxfail", 1000, "Maximum call site failures after which to inline cache.");
    public static final Option<Integer> INVOKEDYNAMIC_MAXPOLY = Options.integer(Category.INVOKEDYNAMIC, "invokedynamic.maxpoly", 6, "Maximum polymorphism of PIC binding.");
    public static final Option<Boolean> INVOKEDYNAMIC_LOG_BINDING = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.log.binding", false, "Log binding of invokedynamic call sites.");
    public static final Option<Boolean> INVOKEDYNAMIC_LOG_CONSTANTS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.log.constants", false, "Log invokedynamic-based constant lookups.");
    public static final Option<Boolean> INVOKEDYNAMIC_LOG_GLOBALS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.log.globals", false, "Log invokedynamic-based global lookups.");
    public static final Option<Boolean> INVOKEDYNAMIC_ALL = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.all", false, "Enable all possible uses of invokedynamic.");
    public static final Option<Boolean> INVOKEDYNAMIC_SAFE = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.safe", false, "Enable all safe (but maybe not fast) uses of invokedynamic.");
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation", true, "Enable invokedynamic for method invocations.");
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_SWITCHPOINT = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.switchpoint", true, "Use SwitchPoint for class modification guards on invocations.");
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_INDIRECT = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.indirect", true, "Also bind indirect method invokers to invokedynamic.");
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_JAVA = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.java", true, "Bind Ruby to Java invocations with invokedynamic.");
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_ATTR = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.attr", true, "Bind Ruby attribue invocations directly to invokedynamic.");
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_FASTOPS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.fastops", true, "Bind Fixnum and Float math using optimized logic.");
    public static final Option<Boolean> INVOKEDYNAMIC_CACHE = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.cache", true, "Use invokedynamic to load cached values like literals and constants.");
    public static final Option<Boolean> INVOKEDYNAMIC_CACHE_CONSTANTS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.cache.constants", true, "Use invokedynamic to load constants.");
    public static final Option<Boolean> INVOKEDYNAMIC_CACHE_LITERALS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.cache.literals", true, "Use invokedynamic to load literals.");
    public static final Option<Boolean> INVOKEDYNAMIC_CACHE_IVARS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.cache.ivars", true, "Use invokedynamic to get/set instance variables.");
    public static final Option<Boolean> INVOKEDYNAMIC_CLASS_VALUES = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.class.values", false, "Use ClassValue to store class-specific data.");
    public static final Option<Integer> INVOKEDYNAMIC_GLOBAL_MAXFAIL = Options.integer(Category.INVOKEDYNAMIC, "invokedynamic.global.maxfail", 100, "Maximum global cache failures after which to use slow path.");
    public static final Option<Boolean> INVOKEDYNAMIC_HANDLES = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.handles", false, "Use MethodHandles rather than generated code to bind Ruby methods.");
    public static final Option<Integer> JIT_THRESHOLD = Options.integer(Category.JIT, "jit.threshold", 50, "Set the JIT threshold to the specified method invocation count.");
    public static final Option<Integer> JIT_MAX = Options.integer(Category.JIT, "jit.max", 4096, "Set the max count of active methods eligible for JIT-compilation.");
    public static final Option<Integer> JIT_MAXSIZE = Options.integer(Category.JIT, "jit.maxsize", 30000, "Set the maximum full-class byte size allowed for jitted methods.");
    public static final Option<Boolean> JIT_LOGGING = Options.bool(Category.JIT, "jit.logging", false, "Enable JIT logging (reports successful compilation).");
    public static final Option<Boolean> JIT_LOGGING_VERBOSE = Options.bool(Category.JIT, "jit.logging.verbose", false, "Enable verbose JIT logging (reports failed compilation).");
    public static final Option<Boolean> JIT_DUMPING = Options.bool(Category.JIT, "jit.dumping", false, "Enable stdout dumping of JITed bytecode.");
    public static final Option<Integer> JIT_LOGEVERY = Options.integer(Category.JIT, "jit.logEvery", 0, "Log a message every n methods JIT compiled.");
    public static final Option<String> JIT_EXCLUDE = Options.string(Category.JIT, "jit.exclude", new String[]{"ClsOrMod", "ClsOrMod::method_name", "-::method_name"}, "", "Exclude methods from JIT. Comma delimited.");
    public static final Option<Boolean> JIT_CACHE = Options.bool(Category.JIT, "jit.cache", COMPILE_INVOKEDYNAMIC.load() == false, "Cache jitted method in-memory bodies across runtimes and loads.");
    public static final Option<Boolean> JIT_DEBUG = Options.bool(Category.JIT, "jit.debug", false, "Log loading of JITed bytecode.");
    public static final Option<Boolean> JIT_BACKGROUND = Options.bool(Category.JIT, "jit.background", true, "Run the JIT compiler in a background thread.");
    public static final Option<Boolean> IR_DEBUG = Options.bool(Category.IR, "ir.debug", false, "Debug generation of JRuby IR.");
    public static final Option<Boolean> IR_PROFILE = Options.bool(Category.IR, "ir.profile", false, "[EXPT]: Profile IR code during interpretation.");
    public static final Option<Boolean> IR_COMPILER_DEBUG = Options.bool(Category.IR, "ir.compiler.debug", false, "Debug compilation of JRuby IR.");
    public static final Option<Boolean> IR_VISUALIZER = Options.bool(Category.IR, "ir.visualizer", false, "Visualization of JRuby IR.");
    public static final Option<String> IR_COMPILER_PASSES = Options.string(Category.IR, "ir.passes", "Specify comma delimeted list of passes to run.");
    public static final Option<String> IR_INLINE_COMPILER_PASSES = Options.string(Category.IR, "ir.inline_passes", "Specify comma delimeted list of passes to run after inlining a method.");
    public static final Option<Boolean> NATIVE_ENABLED = Options.bool(Category.NATIVE, "native.enabled", true, "Enable/disable native code, including POSIX features and C exts.");
    public static final Option<Boolean> NATIVE_VERBOSE = Options.bool(Category.NATIVE, "native.verbose", false, "Enable verbose logging of native extension loading.");
    public static final Option<Boolean> CEXT_ENABLED = Options.bool(Category.NATIVE, "cext.enabled", false, "Enable or disable C extension support.");
    public static final Option<Boolean> FFI_COMPILE_DUMP = Options.bool(Category.NATIVE, "ffi.compile.dump", false, "Dump bytecode-generated FFI stubs to console.");
    public static final Option<Integer> FFI_COMPILE_THRESHOLD = Options.integer(Category.NATIVE, "ffi.compile.threshold", 100, "Number of FFI invocations before generating a bytecode stub.");
    public static final Option<Boolean> FFI_COMPILE_INVOKEDYNAMIC = Options.bool(Category.NATIVE, "ffi.compile.invokedynamic", false, "Use invokedynamic to bind FFI invocations.");
    public static final Option<Boolean> FFI_COMPILE_REIFY = Options.bool(Category.NATIVE, "ffi.compile.reify", false, "Reify FFI compiled classes.");
    public static final Option<Boolean> THREADPOOL_ENABLED = Options.bool(Category.THREADPOOL, "thread.pool.enabled", false, "Enable reuse of native threads via a thread pool.");
    public static final Option<Integer> THREADPOOL_MIN = Options.integer(Category.THREADPOOL, "thread.pool.min", 0, "The minimum number of threads to keep alive in the pool.");
    public static final Option<Integer> THREADPOOL_MAX = Options.integer(Category.THREADPOOL, "thread.pool.max", Integer.MAX_VALUE, "The maximum number of threads to allow in the pool.");
    public static final Option<Integer> THREADPOOL_TTL = Options.integer(Category.THREADPOOL, "thread.pool.ttl", 60, "The maximum number of seconds to keep alive an idle thread.");
    public static final Option<Integer> FIBER_THREADPOOL_TTL = Options.integer(Category.THREADPOOL, "fiber.thread.pool.ttl", 60, "The maximum number of seconds to keep alive a pooled fiber thread.");
    public static final Option<String> COMPAT_VERSION = Options.string(Category.MISCELLANEOUS, "compat.version", new String[]{"1.8", "1.9", "2.0"}, Constants.DEFAULT_RUBY_VERSION, "Specify the major Ruby version to be compatible with.");
    public static final Option<Boolean> OBJECTSPACE_ENABLED = Options.bool(Category.MISCELLANEOUS, "objectspace.enabled", false, "Enable or disable ObjectSpace.each_object.");
    public static final Option<Boolean> SIPHASH_ENABLED = Options.bool(Category.MISCELLANEOUS, "siphash.enabled", false, "Enable or disable SipHash for String hash function.");
    public static final Option<Boolean> LAUNCH_INPROC = Options.bool(Category.MISCELLANEOUS, "launch.inproc", false, "Set in-process launching of e.g. system('ruby ...').");
    public static final Option<String> BYTECODE_VERSION = Options.string(Category.MISCELLANEOUS, "bytecode.version", new String[]{"1.5", "1.6", "1.7"}, SafePropertyAccessor.getProperty("java.specification.version", "1.5"), "Specify the major Java bytecode version.");
    public static final Option<Boolean> MANAGEMENT_ENABLED = Options.bool(Category.MISCELLANEOUS, "management.enabled", false, "Set whether JMX management is enabled.");
    public static final Option<Boolean> JUMP_BACKTRACE = Options.bool(Category.MISCELLANEOUS, "jump.backtrace", false, "Make non-local flow jumps generate backtraces.");
    public static final Option<Boolean> PROCESS_NOUNWRAP = Options.bool(Category.MISCELLANEOUS, "process.noUnwrap", false, "Do not unwrap process streams (issue on some recent JVMs).");
    public static final Option<Boolean> REIFY_CLASSES = Options.bool(Category.MISCELLANEOUS, "reify.classes", false, "Before instantiation, stand up a real Java class for every Ruby class.");
    public static final Option<Boolean> REIFY_LOGERRORS = Options.bool(Category.MISCELLANEOUS, "reify.logErrors", false, "Log errors during reification (reify.classes=true).");
    public static final Option<Boolean> REFLECTED_HANDLES = Options.bool(Category.MISCELLANEOUS, "reflected.handles", false, "Use reflection for binding methods, not generated bytecode.");
    public static final Option<Boolean> BACKTRACE_COLOR = Options.bool(Category.MISCELLANEOUS, "backtrace.color", false, "Enable colorized backtraces.");
    public static final Option<String> BACKTRACE_STYLE = Options.string(Category.MISCELLANEOUS, "backtrace.style", new String[]{"normal", "raw", "full", "mri"}, "normal", "Set the style of exception backtraces.");
    public static final Option<Boolean> BACKTRACE_MASK = Options.bool(Category.MISCELLANEOUS, "backtrace.mask", false, "Mask .java lines in Ruby backtraces.");
    public static final Option<String> THREAD_DUMP_SIGNAL = Options.string(Category.MISCELLANEOUS, "thread.dump.signal", new String[]{"USR1", "USR2", "etc"}, "USR2", "Set the signal used for dumping thread stacks.");
    public static final Option<Boolean> NATIVE_NET_PROTOCOL = Options.bool(Category.MISCELLANEOUS, "native.net.protocol", false, "Use native impls for parts of net/protocol.");
    public static final Option<Boolean> FIBER_COROUTINES = Options.bool(Category.MISCELLANEOUS, "fiber.coroutines", false, "Use JVM coroutines for Fiber.");
    public static final Option<Boolean> GLOBAL_REQUIRE_LOCK = Options.bool(Category.MISCELLANEOUS, "global.require.lock", false, "Use a single global lock for requires.");
    public static final Option<Boolean> NATIVE_EXEC = Options.bool(Category.MISCELLANEOUS, "native.exec", true, "Do a true process-obliterating native exec for Kernel#exec.");
    public static final Option<Boolean> ENUMERATOR_LIGHTWEIGHT = Options.bool(Category.MISCELLANEOUS, "enumerator.lightweight", true, "Use lightweight Enumerator#next logic when possible.");
    public static final Option<Boolean> CONSISTENT_HASHING = Options.bool(Category.MISCELLANEOUS, "consistent.hashing", false, "Generate consistent object hashes across JVMs");
    public static final Option<Boolean> REIFY_VARIABLES = Options.bool(Category.MISCELLANEOUS, "reify.variables", false, "Attempt to expand instance vars into Java fields");
    public static final Option<Boolean> PREFER_IPV4 = Options.bool(Category.MISCELLANEOUS, "net.preferIPv4", true, "Prefer IPv4 network stack");
    public static final Option<Boolean> FCNTL_LOCKING = Options.bool(Category.MISCELLANEOUS, "file.flock.fcntl", true, "Use fcntl rather than flock for File#flock");
    public static final Option<Boolean> DEBUG_LOADSERVICE = Options.bool(Category.DEBUG, "debug.loadService", false, "Log require/load file searches.");
    public static final Option<Boolean> DEBUG_LOADSERVICE_TIMING = Options.bool(Category.DEBUG, "debug.loadService.timing", false, "Log require/load parse+evaluate times.");
    public static final Option<Boolean> DEBUG_LAUNCH = Options.bool(Category.DEBUG, "debug.launch", false, "Log externally-launched processes.");
    public static final Option<Boolean> DEBUG_FULLTRACE = Options.bool(Category.DEBUG, "debug.fullTrace", false, "Set whether full traces are enabled (c-call/c-return).");
    public static final Option<Boolean> DEBUG_SCRIPTRESOLUTION = Options.bool(Category.DEBUG, "debug.scriptResolution", false, "Print which script is executed by '-S' flag.");
    public static final Option<Boolean> DEBUG_PARSER = Options.bool(Category.DEBUG, "debug.parser", false, "disables JRuby impl script loads and prints parse exceptions");
    public static final Option<Boolean> ERRNO_BACKTRACE = Options.bool(Category.DEBUG, "errno.backtrace", false, "Generate backtraces for heavily-used Errno exceptions (EAGAIN).");
    public static final Option<Boolean> STOPITERATION_BACKTRACE = Options.bool(Category.DEBUG, "stop_iteration.backtrace", false, "Generate backtraces for heavily-used Errno exceptions (EAGAIN).");
    public static final Option<Boolean> LOG_EXCEPTIONS = Options.bool(Category.DEBUG, "log.exceptions", false, "Log every time an exception is constructed.");
    public static final Option<Boolean> LOG_BACKTRACES = Options.bool(Category.DEBUG, "log.backtraces", false, "Log every time an exception backtrace is generated.");
    public static final Option<Boolean> LOG_CALLERS = Options.bool(Category.DEBUG, "log.callers", false, "Log every time a Kernel#caller backtrace is generated.");
    public static final Option<Boolean> LOG_WARNINGS = Options.bool(Category.DEBUG, "log.warnings", false, "Log every time a built-in warning backtrace is generated.");
    public static final Option<String> LOGGER_CLASS = Options.string(Category.DEBUG, "logger.class", new String[]{"class name"}, "org.jruby.util.log.StandardErrorLogger", "Use specified class for logging.");
    public static final Option<Boolean> DUMP_INSTANCE_VARS = Options.bool(Category.DEBUG, "dump.variables", false, "Dump class + instance var names on first new of Object subclasses.");
    public static final Option<Boolean> REWRITE_JAVA_TRACE = Options.bool(Category.DEBUG, "rewrite.java.trace", true, "Rewrite stack traces from exceptions raised in Java calls.");
    public static final Option<Boolean> JI_SETACCESSIBLE = Options.bool(Category.JAVA_INTEGRATION, "ji.setAccessible", true, "Try to set inaccessible Java methods to be accessible.");
    public static final Option<Boolean> JI_LOGCANSETACCESSIBLE = Options.bool(Category.JAVA_INTEGRATION, "ji.logCanSetAccessible", false, "Log whether setAccessible is working.");
    public static final Option<Boolean> JI_UPPER_CASE_PACKAGE_NAME_ALLOWED = Options.bool(Category.JAVA_INTEGRATION, "ji.upper.case.package.name.allowed", false, "Allow Capitalized Java pacakge names.");
    public static final Option<Boolean> INTERFACES_USEPROXY = Options.bool(Category.JAVA_INTEGRATION, "interfaces.useProxy", false, "Use java.lang.reflect.Proxy for interface impl.");
    public static final Option<Boolean> JAVA_HANDLES = Options.bool(Category.JAVA_INTEGRATION, "java.handles", false, "Use generated handles instead of reflection for calling Java.");
    public static final Option<Boolean> JI_NEWSTYLEEXTENSION = Options.bool(Category.JAVA_INTEGRATION, "ji.newStyleExtension", false, "Extend Java classes without using a proxy object.");
    public static final Option<Boolean> JI_OBJECTPROXYCACHE = Options.bool(Category.JAVA_INTEGRATION, "ji.objectProxyCache", true, "Cache Java object wrappers between calls.");
    public static final Option<String> JI_PROXYCLASSFACTORY = Options.string(Category.JAVA_INTEGRATION, "ji.proxyClassFactory", "Allow external envs to replace JI proxy class factory");
    public static final Option<Integer> PROFILE_MAX_METHODS = Options.integer(Category.PROFILING, "profile.max.methods", 100000, "Maximum number of methods to consider for profiling.");
    public static final Option<Boolean> CLI_AUTOSPLIT = Options.bool(Category.CLI, "cli.autosplit", false, "Split $_ into $F for -p or -n. Same as -a.");
    public static final Option<Boolean> CLI_DEBUG = Options.bool(Category.CLI, "cli.debug", false, "Enable debug mode logging. Same as -d.");
    public static final Option<Boolean> CLI_PROCESS_LINE_ENDS = Options.bool(Category.CLI, "cli.process.line.ends", false, "Enable line ending processing. Same as -l.");
    public static final Option<Boolean> CLI_ASSUME_LOOP = Options.bool(Category.CLI, "cli.assume.loop", false, "Wrap execution with a gets() loop. Same as -n.");
    public static final Option<Boolean> CLI_ASSUME_PRINT = Options.bool(Category.CLI, "cli.assume.print", false, "Print $_ after each execution of script. Same as -p.");
    public static final Option<Boolean> CLI_VERBOSE = Options.bool(Category.CLI, "cli.verbose", false, "Verbose mode, as -w or -W2. Sets default for cli.warning.level.");
    public static final Option<RubyInstanceConfig.Verbosity> CLI_WARNING_LEVEL = Options.enumeration(Category.CLI, "cli.warning.level", RubyInstanceConfig.Verbosity.class, CLI_VERBOSE.load() != false ? RubyInstanceConfig.Verbosity.TRUE : RubyInstanceConfig.Verbosity.FALSE, "Warning level (off=0,normal=1,on=2). Same as -W.");
    public static final Option<Boolean> CLI_PARSER_DEBUG = Options.bool(Category.CLI, "cli.parser.debug", false, "Enable parser debug logging. Same as -y.");
    public static final Option<Boolean> CLI_VERSION = Options.bool(Category.CLI, "cli.version", false, "Print version to stderr. Same as --version.");
    public static final Option<Boolean> CLI_BYTECODE = Options.bool(Category.CLI, "cli.bytecode", false, "Print target script bytecode to stderr. Same as --bytecode.");
    public static final Option<Boolean> CLI_COPYRIGHT = Options.bool(Category.CLI, "cli.copyright", false, "Print copyright to stderr. Same as --copyright but runs script.");
    public static final Option<Boolean> CLI_CHECK_SYNTAX = Options.bool(Category.CLI, "cli.check.syntax", false, "Check syntax of target script. Same as -c but runs script.");
    public static final Option<String> CLI_AUTOSPLIT_SEPARATOR = Options.string(Category.CLI, "cli.autosplit.separator", "Set autosplit separator. Same as -F.");
    public static final Option<KCode> CLI_KCODE = Options.enumeration(Category.CLI, "cli.kcode", KCode.class, KCode.NONE, "Set kcode character set. Same as -K (1.8).");
    public static final Option<Boolean> CLI_HELP = Options.bool(Category.CLI, "cli.help", false, "Print command-line usage. Same as --help but runs script.");
    public static final Option<Boolean> CLI_PROPERTIES = Options.bool(Category.CLI, "cli.properties", false, "Print config properties. Same as --properties but runs script.");
    public static final Option<String> CLI_ENCODING_INTERNAL = Options.string(Category.CLI, "cli.encoding.internal", "Encoding name to use internally.");
    public static final Option<String> CLI_ENCODING_EXTERNAL = Options.string(Category.CLI, "cli.encoding.external", "Encoding name to treat external data.");
    public static final Option<String> CLI_ENCODING_SOURCE = Options.string(Category.CLI, "cli.encoding.source", "Encoding name to treat source code.");
    public static final Option<String> CLI_RECORD_SEPARATOR = Options.string(Category.CLI, "cli.record.separator", "\n", "Default record separator.");
    public static final Option<String> CLI_BACKUP_EXTENSION = Options.string(Category.CLI, "cli.backup.extension", "Backup extension for in-place ARGV files. Same as -i.");
    public static final Option<RubyInstanceConfig.ProfilingMode> CLI_PROFILING_MODE = Options.enumeration(Category.CLI, "cli.profiling.mode", RubyInstanceConfig.ProfilingMode.class, RubyInstanceConfig.ProfilingMode.OFF, "Enable instrumented profiling modes.");
    public static final Option<Boolean> CLI_RUBYGEMS_ENABLE = Options.bool(Category.CLI, "cli.rubygems.enable", true, "Enable/disable RubyGems.");
    public static final Option<Boolean> CLI_STRIP_HEADER = Options.bool(Category.CLI, "cli.strip.header", false, "Strip text before shebang in script. Same as -x.");
    public static final Option<Boolean> CLI_LOAD_GEMFILE = Options.bool(Category.CLI, "cli.load.gemfile", false, "Load a bundler Gemfile in cwd before running. Same as -G.");
    public static final Collection<Option> PROPERTIES = Collections.unmodifiableCollection(_loadedOptions);
    @Deprecated
    public static final Option<String> JIT_CODECACHE = Option.string("jit.codeCache", (Enum)Category.JIT, new String[]{"dir"}, "Save jitted methods to <dir> as they're compiled, for future runs.");

    public static String dump() {
        return "# JRuby configuration options with current values\n" + Option.formatValues(_loadedOptions);
    }

    private static Option<String> string(Category category, String name2, String[] options2, String defval, String description) {
        Option<String> option = Option.string("jruby", name2, category, options2, defval, description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<String> string(Category category, String name2, String defval, String description) {
        Option<String> option = Option.string("jruby", name2, (Enum)category, defval, description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<String> string(Category category, String name2, String[] options2, String description) {
        Option<String> option = Option.string("jruby", name2, (Enum)category, options2, description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<String> string(Category category, String name2, String description) {
        Option<String> option = Option.string("jruby", name2, category, description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<Boolean> bool(Category category, String name2, Boolean defval, String description) {
        Option<Boolean> option = Option.bool("jruby", name2, category, defval, description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<Integer> integer(Category category, String name2, Integer defval, String description) {
        Option<Integer> option = Option.integer("jruby", name2, (Enum)category, defval, description);
        _loadedOptions.add(option);
        return option;
    }

    private static <T extends Enum<T>> Option<T> enumeration(Category category, String name2, Class<T> enumClass, T defval, String description) {
        Option<T> option = Option.enumeration("jruby", name2, (Enum)category, defval, description);
        _loadedOptions.add(option);
        return option;
    }

    private static boolean calculateInvokedynamicDefault() {
        return false;
    }
}

