/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import com.sun.org.apache.xml.internal.utils.PrefixResolver;
import com.sun.org.apache.xpath.internal.XPath;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.jaxp.JAXPExtensionsProvider;
import com.sun.org.apache.xpath.internal.jaxp.JAXPPrefixResolver;
import com.sun.org.apache.xpath.internal.jaxp.JAXPVariableStack;
import com.sun.org.apache.xpath.internal.objects.XObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import nokogiri.NokogiriService;
import nokogiri.XmlNode;
import nokogiri.XmlNodeSet;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.NokogiriNamespaceContext;
import nokogiri.internals.NokogiriXPathFunctionResolver;
import nokogiri.internals.NokogiriXPathVariableResolver;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@JRubyClass(name={"Nokogiri::XML::XPathContext"})
public class XmlXpathContext
extends RubyObject {
    public static final String XPATH_CONTEXT = "CACHCED_XPATH_CONTEXT";
    private XmlNode context;
    private final NokogiriXPathFunctionResolver functionResolver;
    private final NokogiriXPathVariableResolver variableResolver;
    private PrefixResolver prefixResolver;
    private XPathContext xpathSupport = null;
    private NokogiriNamespaceContext nsContext;

    public XmlXpathContext(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.functionResolver = NokogiriXPathFunctionResolver.create(ruby.getCurrentContext().nil);
        this.variableResolver = NokogiriXPathVariableResolver.create();
    }

    private void setNode(XmlNode xmlNode) throws IllegalArgumentException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Node node = xmlNode.getNode().getOwnerDocument();
        if (node == null) {
            node = xmlNode.getNode();
        }
        this.xpathSupport = (XPathContext)node.getUserData(XPATH_CONTEXT);
        if (this.xpathSupport == null) {
            JAXPExtensionsProvider jAXPExtensionsProvider = this.getProviderInstance();
            this.xpathSupport = new XPathContext(jAXPExtensionsProvider);
            this.xpathSupport.setVarStack(new JAXPVariableStack(this.variableResolver));
            node.setUserData(XPATH_CONTEXT, this.xpathSupport, null);
        }
        this.context = xmlNode;
        this.nsContext = NokogiriNamespaceContext.create();
        this.prefixResolver = new JAXPPrefixResolver(this.nsContext);
    }

    private JAXPExtensionsProvider getProviderInstance() throws ClassNotFoundException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName("com.sun.org.apache.xpath.internal.jaxp.JAXPExtensionsProvider");
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            Class<?>[] classArray = constructorArray[i].getParameterTypes();
            if (classArray.length == 2) {
                return (JAXPExtensionsProvider)constructorArray[i].newInstance(this.functionResolver, false);
            }
            if (classArray.length != 1) continue;
            return (JAXPExtensionsProvider)constructorArray[i].newInstance(this.functionResolver);
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject rbNew(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        XmlNode xmlNode = (XmlNode)iRubyObject2;
        XmlXpathContext xmlXpathContext = (XmlXpathContext)NokogiriService.XML_XPATHCONTEXT_ALLOCATOR.allocate(threadContext.getRuntime(), (RubyClass)iRubyObject);
        XPathFactory.newInstance().newXPath();
        try {
            xmlXpathContext.setNode(xmlNode);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw threadContext.getRuntime().newRuntimeError(illegalArgumentException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw threadContext.getRuntime().newRuntimeError(classNotFoundException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw threadContext.getRuntime().newRuntimeError(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw threadContext.getRuntime().newRuntimeError(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw threadContext.getRuntime().newRuntimeError(invocationTargetException.getMessage());
        }
        return xmlXpathContext;
    }

    @JRubyMethod
    public IRubyObject evaluate(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.functionResolver.setHandler(iRubyObject2);
        String string = (String)iRubyObject.toJava(String.class);
        if (!iRubyObject2.isNil() && !this.isContainsPrefix(string)) {
            Set set = iRubyObject2.getMetaClass().getMethods().keySet();
            for (String string2 : set) {
                string = string.replaceAll(string2, "nokogiri:" + string2);
            }
        }
        return this.node_set(threadContext, string);
    }

    protected IRubyObject node_set(ThreadContext threadContext, String string) {
        try {
            return this.tryGetNodeSet(threadContext, string);
        }
        catch (XPathExpressionException xPathExpressionException) {
            RubyException rubyException = XmlSyntaxError.createXPathSyntaxError(this.getRuntime(), xPathExpressionException);
            throw new RaiseException(rubyException);
        }
    }

    private IRubyObject tryGetNodeSet(ThreadContext threadContext, String string) throws XPathExpressionException {
        XObject xObject = null;
        Node node = this.context.node;
        try {
            XPath xPath = new XPath(string, null, this.prefixResolver, 0);
            xObject = node == null ? xPath.execute(this.xpathSupport, -1, this.prefixResolver) : xPath.execute(this.xpathSupport, node, this.prefixResolver);
            switch (xObject.getType()) {
                case 1: {
                    return threadContext.getRuntime().newBoolean(xObject.bool());
                }
                case 2: {
                    return threadContext.getRuntime().newFloat(xObject.num());
                }
                case 4: {
                    NodeList nodeList = xObject.nodelist();
                    XmlNodeSet xmlNodeSet = (XmlNodeSet)NokogiriService.XML_NODESET_ALLOCATOR.allocate(this.getRuntime(), NokogiriHelpers.getNokogiriClass(this.getRuntime(), "Nokogiri::XML::NodeSet"));
                    xmlNodeSet.setNodeList(nodeList);
                    xmlNodeSet.initialize(threadContext.getRuntime(), (IRubyObject)this.context);
                    return xmlNodeSet;
                }
            }
            return threadContext.getRuntime().newString(xObject.str());
        }
        catch (TransformerException transformerException) {
            throw new XPathExpressionException(string);
        }
    }

    private boolean isContainsPrefix(String string) {
        Set<String> set = this.nsContext.getAllPrefixes();
        for (String string2 : set) {
            if (!string.contains(string2 + ":")) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod
    public IRubyObject evaluate(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.evaluate(threadContext, iRubyObject, threadContext.getRuntime().getNil());
    }

    @JRubyMethod
    public IRubyObject register_ns(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.nsContext.registerNamespace((String)iRubyObject.toJava(String.class), (String)iRubyObject2.toJava(String.class));
        return this;
    }

    @JRubyMethod
    public IRubyObject register_variable(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.variableResolver.registerVariable((String)iRubyObject.toJava(String.class), (String)iRubyObject2.toJava(String.class));
        return this;
    }
}

