/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.openfile.FileChooser;
import org.netbeans.modules.openfile.OpenFile;
import org.openide.util.HelpCtx;
import org.openide.util.UserCancelException;
import org.openide.windows.WindowManager;

public class OpenFileAction
implements ActionListener {
    private static File currentDirectory = null;
    private static boolean running;

    private HelpCtx getHelpCtx() {
        return new HelpCtx(OpenFileAction.class);
    }

    protected JFileChooser prepareFileChooser() {
        FileChooser chooser = new FileChooser();
        chooser.setCurrentDirectory(OpenFileAction.getCurrentDirectory());
        HelpCtx.setHelpIDString((JComponent)chooser, (String)this.getHelpCtx().getHelpID());
        return chooser;
    }

    public static File[] chooseFilesToOpen(JFileChooser chooser) throws UserCancelException {
        File[] files;
        do {
            int selectedOption;
            if ((selectedOption = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow())) == 0) continue;
            throw new UserCancelException();
        } while ((files = chooser.getSelectedFiles()).length == 0);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (running) {
            return;
        }
        try {
            File[] files;
            running = true;
            JFileChooser chooser = this.prepareFileChooser();
            try {
                files = OpenFileAction.chooseFilesToOpen(chooser);
                currentDirectory = chooser.getCurrentDirectory();
            }
            catch (UserCancelException ex) {
                running = false;
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                OpenFile.openFile(files[i], -1);
            }
        }
        finally {
            running = false;
        }
    }

    private static File getCurrentDirectory() {
        if (currentDirectory != null && currentDirectory.exists()) {
            return currentDirectory;
        }
        currentDirectory = FileSystemView.getFileSystemView().getDefaultDirectory();
        return currentDirectory;
    }
}

