/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.modules.search.AbstractSearchScope;
import org.netbeans.modules.search.SearchScope;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchInfoFactory;

final class SearchScopeNodeSelection
extends AbstractSearchScope
implements PropertyChangeListener {
    private PropertyChangeListener currentNodesWeakListener;

    @Override
    public String getTypeId() {
        return "node selection";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"SearchScopeNameSelectedNodes");
    }

    @Override
    protected String getAdditionalInfo() {
        Node[] nodes = this.getNodes();
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        return nodes.length == 1 ? nodes[0].getDisplayName() : NbBundle.getMessage(this.getClass(), (String)"SearchScopeSelectionAddInfo", (Object)nodes.length);
    }

    @Override
    protected boolean checkIsApplicable() {
        return SearchScopeNodeSelection.checkIsApplicable(this.getNodes());
    }

    private Node[] getNodes() {
        return TopComponent.getRegistry().getActivatedNodes();
    }

    private static boolean checkIsApplicable(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return false;
        }
        for (Node node : nodes) {
            if (SearchScopeNodeSelection.canSearch(node)) continue;
            return false;
        }
        return true;
    }

    private static boolean canSearch(Node node) {
        Lookup nodeLookup = node.getLookup();
        SearchInfo searchInfo = (SearchInfo)nodeLookup.lookup(SearchInfo.class);
        if (searchInfo != null) {
            return searchInfo.canSearch();
        }
        DataObject dataObj = (DataObject)nodeLookup.lookup(DataObject.class);
        return dataObj != null && dataObj.isValid();
    }

    @Override
    protected void startListening() {
        TopComponent.Registry tcRegistry = TopComponent.getRegistry();
        this.currentNodesWeakListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)tcRegistry);
        tcRegistry.addPropertyChangeListener(this.currentNodesWeakListener);
    }

    @Override
    protected void stopListening() {
        TopComponent.getRegistry().removePropertyChangeListener(this.currentNodesWeakListener);
        this.currentNodesWeakListener = null;
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent e) {
        if ("activatedNodes".equals(e.getPropertyName())) {
            this.updateIsApplicable();
        }
    }

    @Override
    public SearchInfo getSearchInfo() {
        return this.getSearchInfo(TopComponent.getRegistry().getActivatedNodes());
    }

    private SearchInfo getSearchInfo(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return this.createEmptySearchInfo();
        }
        if ((nodes = SearchScopeNodeSelection.normalizeNodes(nodes)).length == 1) {
            SearchInfo searchInfo = SearchScopeNodeSelection.getSearchInfo(nodes[0]);
            return searchInfo != null ? searchInfo : this.createEmptySearchInfo();
        }
        ArrayList<SearchInfo> searchInfos = new ArrayList<SearchInfo>(nodes.length);
        for (Node node : nodes) {
            SearchInfo searchInfo = SearchScopeNodeSelection.getSearchInfo(node);
            if (searchInfo == null) continue;
            searchInfos.add(searchInfo);
        }
        if (searchInfos.isEmpty()) {
            return this.createEmptySearchInfo();
        }
        int searchInfoCount = searchInfos.size();
        if (searchInfoCount == 1) {
            return (SearchInfo)searchInfos.get(0);
        }
        return SearchInfoFactory.createCompoundSearchInfo((SearchInfo[])searchInfos.toArray(new SearchInfo[searchInfoCount]));
    }

    private static SearchInfo getSearchInfo(Node node) {
        SearchInfo info = (SearchInfo)node.getLookup().lookup(SearchInfo.class);
        if (info != null) {
            return info;
        }
        Lookup nodeLookup = node.getLookup();
        DataFolder dataFolder = (DataFolder)nodeLookup.lookup(DataFolder.class);
        if (dataFolder != null) {
            return SearchInfoFactory.createSearchInfo((FileObject)dataFolder.getPrimaryFile(), (boolean)true, (FileObjectFilter[])new FileObjectFilter[]{SearchInfoFactory.VISIBILITY_FILTER});
        }
        DataObject dataObj = (DataObject)nodeLookup.lookup(DataObject.class);
        if (dataObj != null) {
            return new DataObjectSearchInfo(dataObj);
        }
        return null;
    }

    private static Node[] normalizeNodes(Node[] nodes) {
        if (nodes.length < 2) {
            return nodes;
        }
        HashMap<Node, Boolean> badNodes = new HashMap<Node, Boolean>(2 * nodes.length, 0.75f);
        HashMap<Node, Boolean> goodNodes = new HashMap<Node, Boolean>(2 * nodes.length, 0.75f);
        ArrayList<Node> path = new ArrayList<Node>(10);
        ArrayList<Node> result = new ArrayList<Node>(nodes.length);
        for (Node node : nodes) {
            badNodes.put(node, Boolean.FALSE);
        }
        for (Node node : nodes) {
            path.clear();
            boolean isBad = false;
            for (Node n = node.getParentNode(); n != null; n = n.getParentNode()) {
                if (badNodes.containsKey(n)) {
                    isBad = true;
                    break;
                }
                if (goodNodes.containsKey(n)) break;
                path.add(n);
            }
            if (isBad) {
                badNodes.put(node, Boolean.TRUE);
                for (Node n : path) {
                    badNodes.put(n, Boolean.TRUE);
                }
                continue;
            }
            for (Node n : path) {
                goodNodes.put(n, Boolean.TRUE);
            }
            result.add(node);
        }
        return result.toArray(new Node[result.size()]);
    }

    @Override
    protected SearchScope getContextSensitiveInstance(Lookup context) {
        return new LookupSensitive(this, context);
    }

    static final class LookupSensitive
    extends AbstractSearchScope
    implements LookupListener {
        private static final Node[] emptyNodesArray = new Node[0];
        private final SearchScopeNodeSelection delegate;
        private final Lookup.Result<Node> lookupResult;
        private LookupListener lookupListener;

        LookupSensitive(SearchScopeNodeSelection delegate, Lookup lookup) {
            this.delegate = delegate;
            this.lookupResult = lookup.lookupResult(Node.class);
        }

        private Node[] nodes() {
            Collection nodesColl = this.lookupResult.allInstances();
            return nodesColl.isEmpty() ? emptyNodesArray : nodesColl.toArray(emptyNodesArray);
        }

        @Override
        protected void startListening() {
            this.lookupListener = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.lookupResult);
            this.lookupResult.addLookupListener(this.lookupListener);
        }

        @Override
        protected void stopListening() {
            if (this.lookupListener != null) {
                this.lookupResult.removeLookupListener(this.lookupListener);
            }
        }

        public void resultChanged(LookupEvent ev) {
            this.updateIsApplicable();
        }

        @Override
        protected boolean checkIsApplicable() {
            return SearchScopeNodeSelection.checkIsApplicable(this.nodes());
        }

        @Override
        protected SearchInfo getSearchInfo() {
            return this.delegate.getSearchInfo(this.nodes());
        }

        @Override
        public String getTypeId() {
            return this.delegate.getTypeId();
        }

        @Override
        protected String getDisplayName() {
            return this.delegate.getDisplayName();
        }

        @Override
        protected String getAdditionalInfo() {
            return this.delegate.getAdditionalInfo();
        }
    }

    private static final class DataObjectSearchInfo
    implements SearchInfo {
        private final DataObject dataObj;

        DataObjectSearchInfo(DataObject dataObj) {
            this.dataObj = dataObj;
        }

        public boolean canSearch() {
            return this.dataObj.isValid();
        }

        public Iterator<DataObject> objectsToSearch() {
            return Collections.singleton(this.dataObj).iterator();
        }
    }
}

