/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.nio.charset.Charset;
import java.util.List;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.SearchScope;
import org.netbeans.modules.search.SpecialSearchGroup;
import org.openide.LifecycleManager;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openidex.search.SearchType;

final class SearchTask
implements Runnable,
Cancellable {
    private final SearchScope searchScope;
    private final List<SearchType> customizedSearchTypes;
    private final BasicSearchCriteria basicSearchCriteria;
    private ResultModel resultModel;
    private SpecialSearchGroup searchGroup;
    private boolean notifyWhenFinished = true;
    private volatile boolean interrupted = false;
    private volatile boolean finished = false;
    private final String replaceString;
    private ProgressHandle progressHandle;

    public SearchTask(SearchScope searchScope, BasicSearchCriteria basicSearchCriteria, List<SearchType> customizedSearchTypes) {
        this.searchScope = searchScope;
        this.basicSearchCriteria = basicSearchCriteria;
        this.customizedSearchTypes = customizedSearchTypes;
        this.replaceString = basicSearchCriteria != null ? basicSearchCriteria.getReplaceExpr() : null;
    }

    private boolean isSearchAndReplace() {
        return this.replaceString != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isSearchAndReplace()) {
            LifecycleManager.getDefault().saveAll();
        }
        this.ensureResultModelExists();
        if (this.searchGroup == null) {
            return;
        }
        this.progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ResultView.class, (String)"TEXT_PREPARE_SEARCH___"), (Cancellable)this);
        this.progressHandle.start();
        this.searchGroup.setListeningSearchTask(this);
        try {
            this.searchGroup.search();
        }
        catch (RuntimeException ex) {
            this.resultModel.searchException(ex);
            ex.printStackTrace();
        }
        finally {
            this.searchGroup.setListeningSearchTask(null);
            this.finished = true;
            this.progressHandle.finish();
            this.progressHandle = null;
        }
    }

    SearchTask createNewGeneration() {
        return new SearchTask(this.searchScope, this.basicSearchCriteria, this.customizedSearchTypes);
    }

    BasicSearchCriteria getSearchCriteria() {
        return this.basicSearchCriteria;
    }

    ResultModel getResultModel() {
        this.ensureResultModelExists();
        return this.resultModel;
    }

    private void ensureResultModelExists() {
        if (this.resultModel == null) {
            this.searchGroup = new SpecialSearchGroup(this.basicSearchCriteria, this.customizedSearchTypes, this.searchScope);
            this.resultModel = new ResultModel(this.searchGroup, this.replaceString);
        }
    }

    void matchingObjectFound(Object object, Charset charset) {
        boolean canContinue = this.resultModel.objectFound(object, charset);
        if (!canContinue) {
            this.searchGroup.stopSearch();
        }
    }

    void searchStarted(int searchUnitsCount) {
        this.progressHandle.finish();
        this.progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ResultView.class, (String)"TEXT_SEARCHING___"), (Cancellable)this);
        this.progressHandle.start(searchUnitsCount);
    }

    void progress(int progress) {
        this.progressHandle.progress(progress);
    }

    void stop(boolean notifyWhenFinished) {
        if (!notifyWhenFinished) {
            this.notifyWhenFinished = notifyWhenFinished;
        }
        this.stop();
    }

    void stop() {
        if (!this.finished) {
            this.interrupted = true;
        }
        if (this.searchGroup != null) {
            this.searchGroup.stopSearch();
        }
    }

    public boolean cancel() {
        this.stop();
        return true;
    }

    boolean notifyWhenFinished() {
        return this.notifyWhenFinished;
    }

    boolean wasInterrupted() {
        return this.interrupted;
    }
}

