/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.sql.Connection;
import java.sql.SQLException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.dataview.meta.DBConnectionFactory;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.SQLExecutionHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

abstract class SQLStatementExecutor
implements Runnable,
Cancellable {
    protected final DataView dataView;
    protected Connection conn = null;
    protected boolean error = false;
    protected volatile Throwable ex;
    protected String errorMsg = "";
    protected boolean lastCommitState;
    private String title;
    private String titleMsg;
    private volatile RequestProcessor.Task task;
    private long startTime;

    public SQLStatementExecutor(DataView parent, String title, String msg) {
        this.title = title;
        this.titleMsg = msg;
        this.dataView = parent;
    }

    public void setTask(RequestProcessor.Task task) {
        this.task = task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        assert (this.task != null);
        try {
            this.startTime = System.currentTimeMillis();
            ProgressHandle handle = ProgressHandleFactory.createHandle((String)this.title, (Cancellable)this);
            handle.setDisplayName(this.titleMsg);
            handle.start();
            try {
                handle.switchToIndeterminate();
                this.dataView.setInfoStatusText("");
                this.errorMsg = "";
                this.dataView.disableButtons();
                this.conn = DBConnectionFactory.getInstance().getConnection(this.dataView.getDatabaseConnection());
                String msg = "";
                if (this.conn == null) {
                    Throwable connEx = DBConnectionFactory.getInstance().getLastException();
                    msg = connEx != null ? connEx.getMessage() : NbBundle.getMessage(SQLStatementExecutor.class, (String)"MSG_connection_failure", (Object)this.dataView.getDatabaseConnection());
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    return;
                }
                this.lastCommitState = this.setAutocommit(this.conn, false);
                this.execute();
            }
            finally {
                handle.finish();
            }
        }
        catch (Exception e) {
            this.ex = e;
        }
        finally {
            if (this.ex != null) {
                this.errorMsg = this.errorMsg + this.ex.getMessage();
                this.error = true;
            }
            this.finished();
            this.resetAutocommitState(this.conn, this.lastCommitState);
        }
    }

    public boolean cancel() {
        return this.task.cancel();
    }

    public abstract void finished();

    public abstract void execute() throws SQLException, DBException;

    protected void executeOnSucess() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reinstateToolbar() {
        DataView dataView = this.dataView;
        synchronized (dataView) {
            this.dataView.resetToolbar(false);
        }
    }

    protected void commitOrRollback(String cmdName) {
        if (!this.error && this.commit(this.conn)) {
            long executionTime = System.currentTimeMillis() - this.startTime;
            String execTimeStr = SQLExecutionHelper.millisecondsToSeconds(executionTime);
            String infoMsg = cmdName + " " + NbBundle.getMessage(SQLStatementExecutor.class, (String)"MSG_execution_success", (Object)execTimeStr);
            this.dataView.setInfoStatusText(infoMsg);
            this.executeOnSucess();
        } else {
            this.rollback(this.conn);
            this.reinstateToolbar();
            String msg = cmdName + " " + NbBundle.getMessage(SQLStatementExecutor.class, (String)"MSG_failed");
            this.errorMsg = this.ex == null ? msg + " " + this.errorMsg : msg;
            this.ex = new DBException(this.errorMsg, this.ex);
            this.dataView.setErrorStatusText(this.ex);
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)this.ex.getMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }

    private boolean setAutocommit(Connection conn, boolean newState) {
        try {
            if (conn != null) {
                boolean lastState = conn.getAutoCommit();
                conn.setAutoCommit(newState);
                return lastState;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return newState;
    }

    private void resetAutocommitState(Connection conn, boolean lastState) {
        if (conn != null) {
            try {
                conn.setAutoCommit(lastState);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private boolean commit(Connection conn) {
        try {
            if (conn != null && !conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (SQLException sqlEx) {
            String msg = NbBundle.getMessage(SQLStatementExecutor.class, (String)"MSG_failure_to_commit");
            this.dataView.setErrorStatusText(msg, sqlEx);
            this.ex = sqlEx;
            return false;
        }
        return true;
    }

    private void rollback(Connection conn) {
        try {
            if (conn != null && !conn.getAutoCommit()) {
                conn.rollback();
            }
        }
        catch (SQLException e) {
            String msg = NbBundle.getMessage(SQLStatementExecutor.class, (String)"MSG_failure_rollback");
            this.dataView.setErrorStatusText(msg, e);
        }
    }
}

