/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Variable;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.InstantRenamer;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.VariableScopeVisitor;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.util.NbBundle;

public class GroovyInstantRenamer
implements InstantRenamer {
    private final Logger LOG = Logger.getLogger(GroovyInstantRenamer.class.getName());

    public boolean isRenameAllowed(ParserResult info, int caretOffset, String[] explanationRetValue) {
        this.LOG.log(Level.FINEST, "isRenameAllowed()");
        AstPath path = this.getPathUnderCaret(AstUtilities.getParseResult((Parser.Result)info), caretOffset);
        if (path != null) {
            ASTNode closest = path.leaf();
            if (closest instanceof Variable) {
                return true;
            }
            explanationRetValue[0] = NbBundle.getMessage(GroovyInstantRenamer.class, (String)"OnlyRenameLocalVars");
            return false;
        }
        return false;
    }

    public Set<OffsetRange> getRenameRegions(ParserResult info, int caretOffset) {
        this.LOG.log(Level.FINEST, "getRenameRegions()");
        GroovyParserResult gpr = AstUtilities.getParseResult((Parser.Result)info);
        BaseDocument doc = LexUtilities.getDocument(gpr, false);
        if (doc == null) {
            return Collections.emptySet();
        }
        AstPath path = this.getPathUnderCaret(gpr, caretOffset);
        HashSet<OffsetRange> regions = new HashSet<OffsetRange>();
        GroovyInstantRenamer.markOccurences(path, regions, doc, caretOffset);
        return regions;
    }

    private AstPath getPathUnderCaret(GroovyParserResult info, int caretOffset) {
        ModuleNode rootNode = AstUtilities.getRoot(info);
        if (rootNode == null) {
            return null;
        }
        int astOffset = AstUtilities.getAstOffset((Parser.Result)info, caretOffset);
        if (astOffset == -1) {
            return null;
        }
        BaseDocument document = LexUtilities.getDocument(info, false);
        if (document == null) {
            this.LOG.log(Level.FINEST, "Could not get BaseDocument. It's null");
            return null;
        }
        return new AstPath((ASTNode)rootNode, astOffset, document);
    }

    private static void markOccurences(AstPath path, Set<OffsetRange> regions, BaseDocument document, int cursorOffset) {
        ASTNode root = path.root();
        assert (root instanceof ModuleNode);
        ModuleNode moduleNode = (ModuleNode)root;
        VariableScopeVisitor scopeVisitor = new VariableScopeVisitor(moduleNode.getContext(), path, document, cursorOffset);
        scopeVisitor.collect();
        for (ASTNode astNode : scopeVisitor.getOccurrences()) {
            OffsetRange range = AstUtilities.getRange(astNode, document);
            regions.add(range);
        }
    }
}

