/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.parser;

import groovy.lang.GroovyClassLoader;
import java.io.IOException;
import java.security.CodeSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CancellationException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MixinNode;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParser;
import org.netbeans.modules.groovy.editor.java.ElementSearch;
import org.netbeans.modules.groovy.editor.java.Utilities;
import org.openide.util.Exceptions;

final class CompilationUnit
extends org.codehaus.groovy.control.CompilationUnit {
    public CompilationUnit(GroovyParser groovyParser, CompilerConfiguration compilerConfiguration, CodeSource codeSource, GroovyClassLoader groovyClassLoader, GroovyClassLoader groovyClassLoader2, JavaSource javaSource) {
        super(compilerConfiguration, codeSource, groovyClassLoader, groovyClassLoader2);
        this.ast = new CompileUnit(groovyParser, this.classLoader, codeSource, this.configuration, javaSource);
    }

    private static class CompileUnit
    extends org.codehaus.groovy.ast.CompileUnit {
        private final GroovyParser parser;
        private final JavaSource javaSource;
        private final Map<String, ClassNode> cache = new HashMap<String, ClassNode>();

        public CompileUnit(GroovyParser groovyParser, GroovyClassLoader groovyClassLoader, CodeSource codeSource, CompilerConfiguration compilerConfiguration, JavaSource javaSource) {
            super(groovyClassLoader, codeSource, compilerConfiguration);
            this.parser = groovyParser;
            this.javaSource = javaSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClassNode getClass(final String string) {
            ClassNode classNode;
            if (this.parser.isCancelled()) {
                throw new CancellationException();
            }
            Map<String, ClassNode> map = this.cache;
            synchronized (map) {
                classNode = this.cache.get(string);
                if (classNode != null) {
                    return this.cache.get(string);
                }
            }
            classNode = super.getClass(string);
            if (classNode != null) {
                return classNode;
            }
            map = this.cache;
            synchronized (map) {
                if (this.cache.containsKey(string)) {
                    return null;
                }
            }
            try {
                map = new Task<CompilationController>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(CompilationController compilationController) throws Exception {
                        Elements elements = compilationController.getElements();
                        TypeElement typeElement = ElementSearch.getClass(elements, string);
                        Map map = CompileUnit.this.cache;
                        synchronized (map) {
                            if (typeElement != null) {
                                ClassNode classNode = CompileUnit.this.createClassNode(string, typeElement);
                                if (classNode != null) {
                                    CompileUnit.this.cache.put(string, classNode);
                                }
                            } else if (!CompileUnit.this.cache.containsKey(string)) {
                                CompileUnit.this.cache.put(string, null);
                            }
                        }
                    }
                };
                this.javaSource.runUserActionTask(map, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            map = this.cache;
            synchronized (map) {
                return this.cache.get(string);
            }
        }

        private ClassNode createClassNode(String string, TypeElement typeElement) {
            int n = 0;
            ClassNode classNode = null;
            HashSet<ClassNode> hashSet = new HashSet<ClassNode>();
            if (typeElement.getKind().isInterface()) {
                if (typeElement.getKind() == ElementKind.ANNOTATION_TYPE) {
                    return null;
                }
                n |= 0x200;
                for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                    hashSet.add(new ClassNode(((Object)Utilities.getClassName(typeMirror)).toString(), 512, null));
                }
            } else {
                TypeMirror typeMirror;
                Stack<DeclaredType> stack = new Stack<DeclaredType>();
                while (typeElement != null && typeElement.asType().getKind() != TypeKind.NONE && (typeMirror = typeElement.getSuperclass()).getKind() == TypeKind.DECLARED) {
                    DeclaredType declaredType = (DeclaredType)typeElement.getSuperclass();
                    stack.push(declaredType);
                    Element element = declaredType.asElement();
                    if ((element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.ENUM) && element instanceof TypeElement) {
                        typeElement = (TypeElement)element;
                        continue;
                    }
                    typeElement = null;
                }
                while (!stack.empty()) {
                    classNode = this.createClassNode(((Object)Utilities.getClassName((TypeMirror)stack.pop())).toString(), 0, classNode, Collections.<ClassNode>emptySet());
                }
            }
            return this.createClassNode(string, n, classNode, hashSet);
        }

        private ClassNode createClassNode(String string, int n, ClassNode classNode, Set<ClassNode> set) {
            if ("java.lang.Object".equals(string) && classNode == null) {
                return ClassHelper.OBJECT_TYPE;
            }
            return new ClassNode(string, n, classNode, set.toArray(new ClassNode[set.size()]), MixinNode.EMPTY_ARRAY);
        }
    }
}

