/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.awt.Color;
import java.net.URL;
import javax.swing.Action;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.text.completion.XMLResultItem;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;

class ElementResultItem
extends XMLResultItem {
    private final boolean startElement;
    private final boolean empty;
    private GrammarResult res;

    public ElementResultItem(GrammarResult res) {
        super(res.getNodeName());
        this.res = res;
        this.foreground = Color.blue;
        this.startElement = true;
        this.empty = res.isEmptyElement();
        this.icon = res.getIcon(1);
    }

    public ElementResultItem(String name) {
        super(name);
        this.foreground = Color.blue;
        this.startElement = false;
        this.empty = false;
    }

    @Override
    public String getReplacementText(int modifiers) {
        boolean shift;
        boolean bl = shift = (modifiers & 1) != 0;
        if (shift && this.startElement) {
            if (this.empty) {
                return this.displayText + "/>";
            }
            return this.displayText + ">";
        }
        if (this.startElement) {
            return this.displayText;
        }
        return this.displayText + '>';
    }

    @Override
    public CompletionTask createDocumentationTask() {
        return new CompletionTask(){

            public void query(CompletionResultSet resultSet) {
                if (ElementResultItem.this.res != null && ElementResultItem.this.res.getDescription() != null) {
                    resultSet.setDocumentation((CompletionDocumentation)new Docum(ElementResultItem.this.res.getDescription()));
                }
                resultSet.finish();
            }

            public void refresh(CompletionResultSet resultSet) {
                if (ElementResultItem.this.res != null && ElementResultItem.this.res.getDescription() != null) {
                    resultSet.setDocumentation((CompletionDocumentation)new Docum(ElementResultItem.this.res.getDescription()));
                }
                resultSet.finish();
            }

            public void cancel() {
            }
        };
    }

    @Override
    public boolean substituteText(JTextComponent c, int offset, int len, int modifiers) {
        boolean shift;
        String replacementText = this.getReplacementText(modifiers);
        this.replaceText(c, replacementText, offset, len);
        boolean bl = shift = (modifiers & 1) != 0;
        if (shift && this.startElement) {
            Caret caret = c.getCaret();
            int dot = caret.getDot();
            int rlen = replacementText.length();
            if (this.empty) {
                caret.setDot(dot - rlen + replacementText.indexOf(47));
            }
        }
        return false;
    }

    @Override
    Color getPaintColor() {
        return Color.blue;
    }

    private class Docum
    implements CompletionDocumentation {
        private String doc;

        private Docum(String doc) {
            this.doc = doc;
        }

        public String getText() {
            return this.doc;
        }

        public URL getURL() {
            return null;
        }

        public CompletionDocumentation resolveLink(String link) {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }
}

