/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.actions.ChangeCVSRootPanel;
import org.netbeans.modules.versioning.system.cvss.ui.actions.CvsRootRewriter;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ChangeCVSRootAction
extends AbstractAction {
    private final String RECENT_CHANGED_ROOTS = "recentChangedRoots";
    private final VCSContext ctx;

    public ChangeCVSRootAction(String name, VCSContext ctx) {
        super(name);
        this.ctx = ctx;
    }

    @Override
    public boolean isEnabled() {
        return this.ctx.getRootFiles().size() > 0 && this.allDirectories();
    }

    private boolean allDirectories() {
        for (File file : this.ctx.getRootFiles()) {
            if (file.isDirectory()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ResourceBundle loc = NbBundle.getBundle(ChangeCVSRootAction.class);
        final ChangeCVSRootPanel panel = new ChangeCVSRootPanel();
        panel.getWorkingCopy().setText(this.getWorkingCopy());
        panel.getCurrentCVSRoot().setText(this.getCurrentRoot());
        List roots = Utils.getStringList((Preferences)CvsModuleConfig.getDefault().getPreferences(), (String)"recentChangedRoots");
        panel.getNewRootCombo().setModel(new DefaultComboBoxModel<Object>(roots.toArray()));
        if (roots.size() > 0) {
            panel.getNewRootCombo().setSelectedItem(roots.get(0));
        } else {
            panel.getNewRootCombo().setSelectedItem(this.getNewRoot());
        }
        final JButton changeRoot = new JButton(loc.getString("CTL_CvsRootForm_Action_Change"));
        changeRoot.setToolTipText(loc.getString("TT_CvsRootForm_Action_Change"));
        JButton cancel = new JButton(loc.getString("CTL_CvsRootForm_Action_Cancel"));
        cancel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ChangeCVSRootAction.class, (String)"ACSD_CvsRootForm_Action_Cancel"));
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, loc.getString("CTL_CvsRootForm_Title"), true, new Object[]{changeRoot, cancel}, (Object)changeRoot, 0, null, null);
        descriptor.setClosingOptions(null);
        descriptor.setHelpCtx(new HelpCtx(ChangeCVSRootAction.class));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.getAccessibleContext().setAccessibleDescription(loc.getString("ACSD_CvsRootForm"));
        Component c = panel.getNewRootCombo().getEditor().getEditorComponent();
        if (c instanceof JTextComponent) {
            ((JTextComponent)c).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ChangeCVSRootAction.this.validate(panel, changeRoot);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ChangeCVSRootAction.this.validate(panel, changeRoot);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ChangeCVSRootAction.this.validate(panel, changeRoot);
                }
            });
        }
        panel.getNewRootCombo().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangeCVSRootAction.this.validate(panel, changeRoot);
            }
        });
        dialog.setVisible(true);
        if (descriptor.getValue() != changeRoot) {
            return;
        }
        final String newRoot = panel.getNewRootCombo().getEditor().getItem().toString();
        Utils.insert((Preferences)CvsModuleConfig.getDefault().getPreferences(), (String)"recentChangedRoots", (String)newRoot, (int)20);
        Utils.createTask((Runnable)new Runnable(){

            @Override
            public void run() {
                ChangeCVSRootAction.this.rewrite(newRoot);
            }
        }).schedule(0);
    }

    private void rewrite(String newRoot) {
        for (File root : this.ctx.getRootFiles()) {
            CvsRootRewriter rewriter = new CvsRootRewriter(root, newRoot);
            rewriter.rewrite();
        }
    }

    private String getCurrentRoot() {
        StringBuilder sb = new StringBuilder();
        for (File file : this.ctx.getRootFiles()) {
            try {
                String root = CvsRootRewriter.getCvsRoot(file);
                if (root == null) continue;
                sb.append(root);
                sb.append(", ");
            }
            catch (IOException e) {
                Logger.getLogger(ChangeCVSRootAction.class.getName()).log(Level.WARNING, "", e);
            }
        }
        if (sb.length() == 0) {
            return NbBundle.getMessage(ChangeCVSRootAction.class, (String)"MSG_CvsRootForm_NoCurrentRoot");
        }
        sb.delete(sb.length() - 2, sb.length());
        return sb.toString();
    }

    private String getNewRoot() {
        File file = (File)this.ctx.getRootFiles().iterator().next();
        try {
            return CvsRootRewriter.getCvsRoot(file);
        }
        catch (IOException e) {
            Logger.getLogger(ChangeCVSRootAction.class.getName()).log(Level.WARNING, "", e);
            return "";
        }
    }

    private String getWorkingCopy() {
        StringBuilder sb = new StringBuilder();
        for (File file : this.ctx.getRootFiles()) {
            sb.append(file.getAbsolutePath());
            sb.append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        return sb.toString();
    }

    public void validate(ChangeCVSRootPanel panel, JButton ok) {
        try {
            CVSRoot.parse((String)panel.getNewRootCombo().getEditor().getItem().toString());
            ok.setEnabled(true);
        }
        catch (Exception e) {
            ok.setEnabled(false);
        }
    }
}

