/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.commit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.ResourceBundle;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.spellchecker.api.Spellchecker;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitOptions;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitTable;
import org.netbeans.modules.versioning.system.cvss.ui.components.KTextArea;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.StringSelector;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CommitSettings
extends JPanel
implements PreferenceChangeListener,
TableModelListener,
DocumentListener {
    public static final String COLUMN_NAME_COMMIT = "commit";
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_STICKY = "sticky";
    static final String COLUMN_NAME_STATUS = "status";
    static final String COLUMN_NAME_ACTION = "action";
    static final String COLUMN_NAME_PATH = "path";
    static final Object EVENT_SETTINGS_CHANGED = new Object();
    private CommitTable commitTable;
    private JLabel errorLabel;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JButton loadTemplateButton;
    private JLabel messageErrorLabel;
    private JButton recentMessagesButton;
    private KTextArea taMessage;
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);

    public CommitSettings() {
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension(ss.width / 2, ss.height / 5 * 2));
        this.init();
    }

    void setColumns(String[] cols) {
        this.commitTable.setColumns(cols);
    }

    void setNodes(CvsFileNode[] nodes) {
        this.commitTable.setNodes(nodes);
    }

    public String getCommitMessage() {
        return this.taMessage.getText();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        CvsModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        this.commitTable.getTableModel().addTableModelListener(this);
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
        this.taMessage.selectAll();
        this.taMessage.requestFocus();
    }

    @Override
    public void removeNotify() {
        this.commitTable.getTableModel().removeTableModelListener(this);
        CvsModuleConfig.getDefault().getPreferences().removePreferenceChangeListener(this);
        super.removeNotify();
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.commitTable.dataChanged();
            this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
        }
    }

    public CommitFile[] getCommitFiles() {
        return this.commitTable.getCommitFiles();
    }

    private void init() {
        List messages;
        this.initComponents();
        this.errorLabel.setText("");
        this.messageErrorLabel.setText("");
        this.jScrollPane1.setMinimumSize(this.jScrollPane1.getPreferredSize());
        this.commitTable = new CommitTable(this.jLabel3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.commitTable.getComponent(), gridBagConstraints);
        String message = CvsModuleConfig.getDefault().getLastCanceledCommitMessage();
        if (message.isEmpty() && new StringSelector.RecentMessageSelector(CvsModuleConfig.getDefault().getPreferences()).isAutoFill() && (messages = Utils.getStringList((Preferences)CvsModuleConfig.getDefault().getPreferences(), (String)"commitAction.commitMessage")).size() > 0) {
            message = (String)messages.get(0);
        }
        if (!message.isEmpty()) {
            this.taMessage.setText(message);
        } else {
            this.loadTemplate(true);
        }
        this.taMessage.getDocument().addDocumentListener(this);
        this.onCommitMessageChanged();
        Spellchecker.register((JTextComponent)this.taMessage);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.onCommitMessageChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.onCommitMessageChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.onCommitMessageChanged();
    }

    private void onCommitMessageChanged() {
        if (this.taMessage.getText().trim().length() == 0) {
            this.messageErrorLabel.setText(NbBundle.getMessage(CommitSettings.class, (String)"MSG_CommitForm_MessageEmpty"));
        } else {
            this.messageErrorLabel.setText("");
        }
    }

    private void loadTemplate(boolean quiet) {
        CommitFile[] files;
        for (CommitFile commitFile : files = this.getCommitFiles()) {
            block6: {
                File file = commitFile.getNode().getFile();
                File templateFile = new File(file.getParentFile(), "CVS/Template");
                if (!templateFile.canRead()) continue;
                StringWriter sw = new StringWriter();
                try {
                    Utils.copyStreamsCloseAll((Writer)sw, (Reader)new FileReader(templateFile));
                    String message = sw.toString();
                    if (message.trim().length() == 0) {
                        NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(CommitSettings.class, (String)"CTL_LoadTemplate_Empty"), NbBundle.getMessage(CommitSettings.class, (String)"CTL_LoadTemplate_Title"), 0, 2, null, NotifyDescriptor.NO_OPTION);
                        if (DialogDisplayer.getDefault().notify(nd) != NotifyDescriptor.YES_OPTION) {
                            return;
                        }
                    }
                    this.taMessage.setText(message);
                }
                catch (IOException e) {
                    if (quiet) break block6;
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
            return;
        }
        if (!quiet) {
            NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(CommitSettings.class, (String)"CTL_LoadTemplate_NoTemplate"), NbBundle.getMessage(CommitSettings.class, (String)"CTL_LoadTemplate_Title"), -1, 0, null, null);
            DialogDisplayer.getDefault().notify(nd);
        }
    }

    private void onBrowseRecentMessages() {
        StringSelector.RecentMessageSelector selector = new StringSelector.RecentMessageSelector(CvsModuleConfig.getDefault().getPreferences());
        String message = selector.getRecentMessage(NbBundle.getMessage(CommitSettings.class, (String)"CTL_RecentMessages_Prompt"), NbBundle.getMessage(CommitSettings.class, (String)"CTL_RecentMessages_Title"), Utils.getStringList((Preferences)CvsModuleConfig.getDefault().getPreferences(), (String)"commitAction.commitMessage"));
        if (message != null) {
            this.taMessage.replaceSelection(message);
        }
    }

    void setErrorLabel(String htmlErrorLabel) {
        this.errorLabel.setText(htmlErrorLabel);
        this.revalidate();
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.taMessage = new KTextArea();
        this.jLabel3 = new JLabel();
        this.errorLabel = new JLabel();
        this.messageErrorLabel = new JLabel();
        this.recentMessagesButton = new JButton();
        this.loadTemplateButton = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        this.setLayout(new GridBagLayout());
        this.jLabel2.setLabelFor(this.taMessage);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/commit/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)bundle.getString("CTL_CommitForm_Message"));
        this.jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.taMessage.setColumns(30);
        this.taMessage.setLineWrap(true);
        this.taMessage.setRows(6);
        this.taMessage.setTabSize(4);
        this.taMessage.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.taMessage);
        this.taMessage.getAccessibleContext().setAccessibleDescription(bundle.getString("TT_CommitForm_Message"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)bundle.getString("CTL_CommitForm_FilesToCommit"));
        this.jLabel3.setBorder(BorderFactory.createEmptyBorder(12, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.errorLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.errorLabel, gridBagConstraints);
        this.messageErrorLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.messageErrorLabel, gridBagConstraints);
        this.recentMessagesButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/recent_messages.png")));
        this.recentMessagesButton.setToolTipText(NbBundle.getMessage(CommitSettings.class, (String)"CTL_CommitForm_RecentMessages"));
        this.recentMessagesButton.setBorderPainted(false);
        this.recentMessagesButton.setMargin(new Insets(2, 2, 2, 2));
        this.recentMessagesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommitSettings.this.recentMessagesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.recentMessagesButton, gridBagConstraints);
        this.loadTemplateButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/load_template.png")));
        this.loadTemplateButton.setToolTipText(NbBundle.getMessage(CommitSettings.class, (String)"TT_CommitForm_LoadTemplate"));
        this.loadTemplateButton.setBorderPainted(false);
        this.loadTemplateButton.setMargin(new Insets(2, 2, 2, 2));
        this.loadTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommitSettings.this.loadTemplateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.loadTemplateButton, gridBagConstraints);
    }

    private void loadTemplateButtonActionPerformed(ActionEvent evt) {
        this.loadTemplate(false);
    }

    private void recentMessagesButtonActionPerformed(ActionEvent evt) {
        this.onBrowseRecentMessages();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
    }

    public void addVersioningListener(VersioningListener listener) {
        this.listenerSupport.addListener(listener);
    }

    public void removeVersioningListener(VersioningListener listener) {
        this.listenerSupport.removeListener(listener);
    }

    public static class CommitFile {
        private final CommitOptions options;
        private final CvsFileNode node;

        CommitFile(CvsFileNode node, CommitOptions options) {
            this.node = node;
            this.options = options;
        }

        CommitOptions getOptions() {
            return this.options;
        }

        public CvsFileNode getNode() {
            return this.node;
        }
    }
}

