/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.tag;

import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JButton;
import org.netbeans.lib.cvsclient.command.tag.TagCommand;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.TagExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.TagSettings;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class TagAction
extends AbstractSystemAction {
    private static TagCommand commandTemplate = new TagCommand();
    private static final int enabledForStatus = 1208;

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_Tag";
    }

    @Override
    protected int getFileEnabledStatus() {
        return 1208;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    @Override
    public void performCvsAction(Node[] nodes) {
        File[] roots = this.getContext(nodes).getFiles();
        File[][] flatFiles = Utils.splitFlatOthers((File[])this.getContext(nodes).getFiles());
        TagCommand cmd = new TagCommand();
        this.copy(cmd, commandTemplate);
        String title = MessageFormat.format(NbBundle.getBundle(TagAction.class).getString("CTL_TagDialog_Title"), this.getContextDisplayName(nodes));
        TagSettings settings = new TagSettings(roots);
        settings.setCommand(cmd);
        JButton tag = new JButton(NbBundle.getMessage(TagAction.class, (String)"CTL_TagDialog_Action_Tag"));
        settings.putClientProperty("OKButton", tag);
        settings.refreshComponents();
        tag.setToolTipText(NbBundle.getMessage(TagAction.class, (String)"TT_TagDialog_Action_Tag"));
        DialogDescriptor descriptor = new DialogDescriptor((Object)settings, title, true, new Object[]{tag, DialogDescriptor.CANCEL_OPTION}, (Object)tag, 0, new HelpCtx(TagAction.class), null);
        descriptor.setClosingOptions(null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TagAction.class, (String)"ACSD_TagDialog"));
        dialog.setVisible(true);
        if (descriptor.getValue() != tag) {
            return;
        }
        settings.updateCommand(cmd);
        this.copy(commandTemplate, cmd);
        if (flatFiles[0].length > 0) {
            cmd.setRecursive(false);
        }
        cmd.setFiles(roots);
        ExecutorGroup group = new ExecutorGroup(this.getRunningName(nodes));
        group.addExecutors(TagExecutor.splitCommand(cmd, CvsVersioningSystem.getInstance(), null));
        group.execute();
    }

    protected boolean asynchronous() {
        return false;
    }

    private void copy(TagCommand c1, TagCommand c2) {
        c1.setTag(c2.getTag());
        c1.setCheckThatUnmodified(c2.isCheckThatUnmodified());
        c1.setDeleteTag(c2.isDeleteTag());
        c1.setOverrideExistingTag(c2.isOverrideExistingTag());
    }
}

