/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.overrides;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.modelutil.OverridesPopup;
import org.netbeans.modules.cnd.utils.ui.PopupUtil;
import org.openide.text.Annotation;
import org.openide.text.NbDocument;

abstract class BaseAnnotation
extends Annotation {
    static final Logger LOGGER = Logger.getLogger("cnd.overrides.annotations.logger");
    protected final StyledDocument document;
    protected final Position pos;
    protected final AnnotationType type;
    protected final Collection<CsmUID<? extends CsmOffsetableDeclaration>> baseUIDs;
    protected final Collection<CsmUID<? extends CsmOffsetableDeclaration>> descUIDs;

    protected BaseAnnotation(StyledDocument document, CsmOffsetableDeclaration decl, Collection<? extends CsmOffsetableDeclaration> baseDecls, Collection<? extends CsmOffsetableDeclaration> descDecls) {
        assert (decl != null);
        this.document = document;
        this.pos = new DeclarationPosition(decl);
        if (baseDecls.isEmpty() && !descDecls.isEmpty()) {
            this.type = AnnotationType.IS_OVERRIDDEN;
        } else if (!baseDecls.isEmpty() && descDecls.isEmpty()) {
            this.type = AnnotationType.OVERRIDES;
        } else if (!baseDecls.isEmpty() && !descDecls.isEmpty()) {
            this.type = AnnotationType.COMBINED;
        } else {
            throw new IllegalArgumentException("Either overrides or overridden should be non empty");
        }
        this.baseUIDs = new ArrayList<CsmUID<? extends CsmOffsetableDeclaration>>(baseDecls.size());
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : baseDecls) {
            this.baseUIDs.add((CsmUID<? extends CsmOffsetableDeclaration>)UIDs.get((Object)csmOffsetableDeclaration));
        }
        this.descUIDs = new ArrayList<CsmUID<? extends CsmOffsetableDeclaration>>(descDecls.size());
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : descDecls) {
            this.descUIDs.add((CsmUID<? extends CsmOffsetableDeclaration>)UIDs.get((Object)csmOffsetableDeclaration));
        }
    }

    public AnnotationType getType() {
        return this.type;
    }

    public String getAnnotationType() {
        switch (this.getType()) {
            case IS_OVERRIDDEN: {
                return "org-netbeans-modules-editor-annotations-is_overridden";
            }
            case OVERRIDES: {
                return "org-netbeans-modules-editor-annotations-overrides";
            }
            case COMBINED: {
                return "org-netbeans-modules-editor-annotations-override-is-overridden-combined";
            }
        }
        throw new IllegalStateException("Currently not implemented: " + (Object)((Object)this.type));
    }

    public void attach() {
        NbDocument.addAnnotation((StyledDocument)this.document, (Position)this.pos, (int)-1, (Annotation)this);
    }

    public void detachImpl() {
        NbDocument.removeAnnotation((StyledDocument)this.document, (Annotation)this);
    }

    public String toString() {
        return "[IsOverriddenAnnotation: " + this.getShortDescription() + "]";
    }

    public Position getPosition() {
        return this.pos;
    }

    protected abstract CharSequence debugTypeStirng();

    public CharSequence debugDump() {
        StringBuilder sb = new StringBuilder();
        int line = NbDocument.findLineNumber((StyledDocument)this.document, (int)this.getPosition().getOffset()) + 1;
        sb.append(line);
        sb.append(':');
        sb.append(this.debugTypeStirng());
        sb.append(' ');
        boolean first = true;
        Comparator<CsmOffsetableDeclaration> comparator = new Comparator<CsmOffsetableDeclaration>(){

            @Override
            public int compare(CsmOffsetableDeclaration o1, CsmOffsetableDeclaration o2) {
                return ((Object)o1.getQualifiedName()).toString().compareTo(((Object)o2.getQualifiedName()).toString());
            }
        };
        List<? extends CsmOffsetableDeclaration> baseDecls = BaseAnnotation.toDeclarations(this.baseUIDs);
        Collections.sort(baseDecls, comparator);
        List<? extends CsmOffsetableDeclaration> descDecls = BaseAnnotation.toDeclarations(this.descUIDs);
        Collections.sort(descDecls, comparator);
        ArrayList<Object> allDecls = new ArrayList<Object>();
        allDecls.addAll(baseDecls);
        allDecls.addAll(descDecls);
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : allDecls) {
            int gotoLine = csmOffsetableDeclaration.getStartPosition().getLine();
            String gotoFile = ((Object)csmOffsetableDeclaration.getContainingFile().getName()).toString();
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(csmOffsetableDeclaration.getQualifiedName());
            sb.append(' ');
            sb.append(gotoFile);
            sb.append(':');
            sb.append(gotoLine);
        }
        return sb;
    }

    void mouseClicked(JTextComponent c, Point p) {
        Point position = new Point(p);
        position.y += c.getFontMetrics(c.getFont()).getHeight();
        SwingUtilities.convertPointToScreen(position, c);
        this.performGoToAction(position);
    }

    private void performGoToAction(Point position) {
        if (this.baseUIDs.size() + this.descUIDs.size() == 1) {
            CsmUID<? extends CsmOffsetableDeclaration> uid = this.baseUIDs.isEmpty() ? this.descUIDs.iterator().next() : this.baseUIDs.iterator().next();
            CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)uid.getObject();
            if (decl != null) {
                CsmUtilities.openSource((CsmObject)decl);
            }
        } else if (this.baseUIDs.size() + this.descUIDs.size() > 1) {
            String caption = this.getShortDescription();
            OverridesPopup popup = new OverridesPopup(caption, BaseAnnotation.toDeclarations(this.baseUIDs), BaseAnnotation.toDeclarations(this.descUIDs));
            PopupUtil.showPopup((JComponent)popup, (String)caption, (int)position.x, (int)position.y, (boolean)true, (int)0);
        } else {
            throw new IllegalStateException("method list should not be empty");
        }
    }

    private static List<? extends CsmOffsetableDeclaration> toDeclarations(Collection<CsmUID<? extends CsmOffsetableDeclaration>> uids) {
        ArrayList<CsmOffsetableDeclaration> decls = new ArrayList<CsmOffsetableDeclaration>(uids.size());
        for (CsmUID<? extends CsmOffsetableDeclaration> uid : uids) {
            CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)uid.getObject();
            if (decl == null) continue;
            decls.add(decl);
        }
        return decls;
    }

    private static class DeclarationPosition
    implements Position {
        private final int offset;

        public DeclarationPosition(CsmOffsetableDeclaration decl) {
            this.offset = decl.getStartOffset();
        }

        @Override
        public int getOffset() {
            return this.offset;
        }
    }

    public static enum AnnotationType {
        IS_OVERRIDDEN,
        OVERRIDES,
        COMBINED;

    }
}

