/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.ant.tasks;

import com.sun.javacard.ant.tasks.JavacardTaskBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Commandline;

public class APDUToolTask
extends JavacardTaskBase {
    private File outputFile;
    private static final String apduToolClassName = "com.sun.javacard.apdutool.Main";
    protected String scriptFileName;
    protected String outEEFile;
    protected String inEEFile;
    protected String crefExecutable;
    protected boolean checkForDownloadFailure = false;
    private int crefCommandSize = 1;

    public void setCheckDownloadFailure(boolean on) {
        this.checkForDownloadFailure = on;
    }

    public void setOutEEFile(String outFileName) {
        this.outEEFile = outFileName;
        this.crefCommandSize += 2;
    }

    public void setInEEFile(String inFileName) {
        this.inEEFile = inFileName;
        this.crefCommandSize += 2;
    }

    public void setScriptFile(String scriptFileName) {
        this.scriptFileName = scriptFileName;
    }

    public void setCrefExe(String crefExe) {
        this.crefExecutable = crefExe;
    }

    protected void initCard() throws BuildException {
        if (!new File(this.crefExecutable).exists()) {
            throw new BuildException(messages.getString("apdutool.invalidCrefExe"));
        }
        if (this.inEEFile != null && !new File(this.inEEFile).exists()) {
            throw new BuildException(messages.getString("apdutool.invalidInEEFile"));
        }
        Execute crefExe = new Execute();
        String[] commandLineArray = new String[this.crefCommandSize];
        commandLineArray[0] = this.crefExecutable;
        if (this.outEEFile == null) {
            throw new BuildException(messages.getString("deploycap.noOutputFileName"));
        }
        commandLineArray[1] = "-o";
        commandLineArray[2] = this.outEEFile;
        if (this.inEEFile != null) {
            commandLineArray[3] = "-i";
            commandLineArray[4] = this.inEEFile;
        }
        crefExe.setSpawn(true);
        crefExe.setCommandline(commandLineArray);
        crefExe.setAntRun(this.getProject());
        try {
            crefExe.spawn();
        }
        catch (Exception e) {
            throw new BuildException(messages.getString("deploycap.crefError"));
        }
    }

    protected void sendAPDUSToCard(boolean checkForErrors) throws BuildException {
        if (checkForErrors) {
            try {
                this.outputFile = File.createTempFile("APDUToolOutputFile", "");
            }
            catch (IOException e) {
                throw new BuildException(messages.getString("deploycap.TempFileError"));
            }
            this.setOutput(this.outputFile);
        }
        this.clearArgs();
        Commandline.Argument scriptFile = this.createArg();
        scriptFile.setValue(this.scriptFileName);
        if (!this.isCrefRunning()) {
            throw new BuildException("dafadfadsfasdf");
        }
        this.setClassname(apduToolClassName);
        this.setFork(true);
        if (this.executeJava() != 0) {
            throw new BuildException(messages.getString("deploycap.apdutoolError"));
        }
        if (checkForErrors) {
            this.checkForFailures();
        }
    }

    private boolean isCrefRunning() {
        boolean status = true;
        return status;
    }

    protected void checkForFailures() throws BuildException {
        String line = null;
        String scriptFileName = this.outputFile.getAbsolutePath();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(scriptFileName));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
                if (line.indexOf("CLA:") != 0 || line.indexOf("SW1: 90, SW2: 00") >= 0) continue;
                throw new BuildException(messages.getString("apdutool.downloadFailed"));
            }
            reader.close();
        }
        catch (IOException e) {
            throw new BuildException(messages.getString("apdutool.scriptFileError"));
        }
    }

    public void execute() throws BuildException {
        this.printDisclaimer();
        if (this.scriptFileName == null) {
            throw new BuildException(messages.getString("apdutool.noScriptFile"));
        }
        if (!new File(this.scriptFileName).exists()) {
            throw new BuildException(messages.getString("apdutool.invalidScriptFile"));
        }
        this.initCard();
        this.sendAPDUSToCard(this.checkForDownloadFailure);
    }
}

