/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.ant.tasks;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class HttpRequestTask
extends Task {
    private String url;
    private String name;

    public void init() {
    }

    public void maybeConfigure() throws BuildException {
        if (this.isInvalid()) {
            super.maybeConfigure();
        } else {
            this.getRuntimeConfigurableWrapper().maybeConfigure(this.getProject(), false);
        }
    }

    public void execute() throws BuildException {
        if (this.url == null || this.url.trim().length() <= 0) {
            throw new BuildException("url not specified");
        }
        if (this.name == null || this.name.trim().length() <= 0) {
            throw new BuildException("name not specified");
        }
        try {
            URL u = new URL(this.url);
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            InputStream is = conn.getInputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int r = 0;
            while ((r = is.read(buffer)) > 0) {
                bos.write(buffer, 0, r);
            }
            bos.close();
            is.close();
            this.getProject().setProperty(this.name, new String(bos.toByteArray()));
        }
        catch (Exception ex) {
            this.getProject().setProperty(this.name, "EXCEPTION: " + ex.getLocalizedMessage());
        }
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(String url) {
        this.url = url;
    }
}

