/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.ant.tasks;

import com.sun.javacard.ant.tasks.ElseTask;
import com.sun.javacard.ant.tasks.ThenTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;

public class IfTask
extends Task
implements TaskContainer {
    private static final String[] CONDITIONS = new String[]{"equals", "contains", "startswith", "endswith", "not-equals", "not-contains", "not-startswith", "not-endswith", "exists", "not-exists", "file-exists", "file-not-exists"};
    private static ArrayList<String> opcodesList = new ArrayList<String>(Arrays.asList(CONDITIONS));
    private ThenTask thenTask;
    private ElseTask elseTask;
    private String condition;
    private String name;
    private String value;

    public void init() {
        this.getProject().addTaskDefinition("then", ThenTask.class);
        this.getProject().addTaskDefinition("else", ElseTask.class);
    }

    public void addTask(Task task) throws BuildException {
        if (task instanceof UnknownElement) {
            ((UnknownElement)task).maybeConfigure();
            task = ((UnknownElement)task).getTask();
            if (task == null) {
                return;
            }
        }
        if (task instanceof ThenTask) {
            if (this.thenTask != null) {
                throw new BuildException("Only one <then> is allowed");
            }
            this.thenTask = (ThenTask)task;
        } else if (task instanceof ElseTask) {
            if (this.elseTask != null) {
                throw new BuildException("Only one <else> is allowed");
            }
            this.elseTask = (ElseTask)task;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String opcode) {
        this.condition = opcode;
    }

    public void maybeConfigure() throws BuildException {
        if (this.isInvalid()) {
            super.maybeConfigure();
        } else {
            this.getRuntimeConfigurableWrapper().maybeConfigure(this.getProject(), false);
        }
    }

    public void execute() throws BuildException {
        if (this.condition == null || this.condition.trim().length() <= 0) {
            this.condition = "equals";
        }
        this.condition = this.condition.toLowerCase();
        int opcodeIndex = opcodesList.indexOf(this.condition);
        if (opcodeIndex == -1) {
            throw new BuildException("Invalid opcode " + this.condition);
        }
        if (this.name != null) {
            this.name = this.name.trim();
            if (this.name.length() <= 0) {
                this.name = null;
            }
        }
        if (this.value != null) {
            this.value = this.getProject().replaceProperties(this.value);
        }
        String pvalue = null;
        if (this.name != null) {
            pvalue = this.getProject().getProperty(this.name);
        }
        if (opcodeIndex < 8) {
            if (this.name == null) {
                throw new BuildException("name not set");
            }
            if (this.value == null) {
                throw new BuildException("value not set");
            }
        }
        if ((opcodeIndex == 8 || opcodeIndex == 9) && this.name == null) {
            throw new BuildException("name not set");
        }
        if ((opcodeIndex == 10 || opcodeIndex == 11) && this.value == null) {
            throw new BuildException("value not set");
        }
        boolean b = false;
        switch (opcodeIndex) {
            case 0: {
                b = pvalue != null && pvalue.equals(this.value);
                break;
            }
            case 1: {
                b = pvalue != null && pvalue.indexOf(this.value) != -1;
                break;
            }
            case 2: {
                b = pvalue != null && pvalue.startsWith(this.value);
                break;
            }
            case 3: {
                b = pvalue != null && pvalue.endsWith(this.value);
                break;
            }
            case 4: {
                b = pvalue != null && !pvalue.equals(this.value);
                break;
            }
            case 5: {
                b = pvalue != null && pvalue.indexOf(this.value) == -1;
                break;
            }
            case 6: {
                b = pvalue != null && !pvalue.startsWith(this.value);
                break;
            }
            case 7: {
                b = pvalue != null && !pvalue.endsWith(this.value);
                break;
            }
            case 8: {
                b = pvalue != null;
                break;
            }
            case 9: {
                b = pvalue == null;
                break;
            }
            case 10: {
                b = new File(this.value).exists();
                break;
            }
            case 11: {
                boolean bl = b = !new File(this.value).exists();
            }
        }
        if (b) {
            if (this.thenTask != null) {
                this.thenTask.perform();
            }
        } else if (this.elseTask != null) {
            this.elseTask.perform();
        }
    }
}

