/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.file;

import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.jumpto.file.FileDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ImageUtilities;

public class FileDescription
extends FileDescriptor {
    public static Icon UNKNOWN_PROJECT_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/jumpto/resources/find.gif", (boolean)false);
    private final FileObject fileObject;
    private final String ownerPath;
    private final Project project;
    private Icon icon;
    private String projectName;
    private Icon projectIcon;

    public FileDescription(FileObject file, String ownerPath, Project project) {
        this.fileObject = file;
        this.ownerPath = ownerPath;
        this.project = project;
    }

    @Override
    public String getFileName() {
        return this.fileObject.getNameExt();
    }

    @Override
    public synchronized Icon getIcon() {
        if (this.icon == null) {
            DataObject od = this.getDataObject();
            Image i = od.getNodeDelegate().getIcon(1);
            this.icon = new ImageIcon(i);
        }
        return this.icon;
    }

    @Override
    public String getOwnerPath() {
        return this.ownerPath;
    }

    @Override
    public synchronized String getProjectName() {
        if (this.projectName == null) {
            this.initProjectInfo();
        }
        return this.projectName;
    }

    @Override
    public synchronized Icon getProjectIcon() {
        if (this.projectIcon == null) {
            this.initProjectInfo();
        }
        return this.projectIcon;
    }

    @Override
    public void open() {
        DataObject od = this.getDataObject();
        if (od != null) {
            EditCookie ec = (EditCookie)od.getCookie(EditCookie.class);
            if (ec != null) {
                ec.edit();
            } else {
                OpenCookie oc = (OpenCookie)od.getCookie(OpenCookie.class);
                if (oc != null) {
                    oc.open();
                }
            }
        }
    }

    @Override
    public FileObject getFileObject() {
        return this.fileObject;
    }

    private DataObject getDataObject() {
        try {
            FileObject fo = this.getFileObject();
            return DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
    }

    private void initProjectInfo() {
        if (this.project != null) {
            ProjectInformation pi = ProjectUtils.getInformation((Project)this.project);
            this.projectName = pi.getDisplayName();
            this.projectIcon = pi.getIcon();
        } else {
            this.projectName = "";
            this.projectIcon = UNKNOWN_PROJECT_ICON;
        }
    }
}

