/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.util.List;
import org.netbeans.modules.cnd.apt.impl.support.PathsCollectionIterator;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.structure.APTIncludeNext;
import org.netbeans.modules.cnd.apt.support.APTIncludeResolver;
import org.netbeans.modules.cnd.apt.support.APTMacroCallback;
import org.netbeans.modules.cnd.apt.support.IncludeDirEntry;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.apt.utils.APTIncludeUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;

public class APTIncludeResolverImpl
implements APTIncludeResolver {
    private final int baseFileIncludeDirIndex;
    private final CharSequence baseFile;
    private final List<IncludeDirEntry> systemIncludePaths;
    private final List<IncludeDirEntry> userIncludePaths;

    public APTIncludeResolverImpl(CharSequence path, int baseFileIncludeDirIndex, List<IncludeDirEntry> systemIncludePaths, List<IncludeDirEntry> userIncludePaths) {
        this.baseFile = FilePathCache.getManager().getString(path);
        this.systemIncludePaths = systemIncludePaths;
        this.userIncludePaths = userIncludePaths;
        this.baseFileIncludeDirIndex = baseFileIncludeDirIndex;
    }

    @Override
    public ResolvedPath resolveInclude(APTInclude apt, APTMacroCallback callback) {
        return this.resolveFilePath(apt.getFileName(callback), apt.isSystem(callback), false);
    }

    @Override
    public ResolvedPath resolveIncludeNext(APTIncludeNext apt, APTMacroCallback callback) {
        return this.resolveFilePath(apt.getFileName(callback), apt.isSystem(callback), true);
    }

    public CharSequence getBasePath() {
        return this.baseFile;
    }

    private ResolvedPath resolveFilePath(String includedFile, boolean system, boolean includeNext) {
        ResolvedPath result = null;
        if (includedFile != null && includedFile.length() > 0) {
            result = APTIncludeUtils.resolveAbsFilePath(includedFile);
            if (result == null && !system && !includeNext) {
                result = APTIncludeUtils.resolveFilePath(includedFile, this.baseFile);
            }
            if (result == null) {
                int startOffset = includeNext ? this.baseFileIncludeDirIndex + 1 : 0;
                PathsCollectionIterator paths = new PathsCollectionIterator(this.userIncludePaths, this.systemIncludePaths, startOffset);
                result = APTIncludeUtils.resolveFilePath(paths, includedFile, startOffset);
            }
            if (result == null && system && !includeNext) {
                result = APTIncludeUtils.resolveFilePath(includedFile, this.baseFile);
            }
        }
        return result;
    }
}

