/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.utils.cache.TextCache;
import org.openide.util.CharSequences;

public class APTBaseToken
implements APTToken {
    private static final long serialVersionUID = 2834353662691067170L;
    protected int line;
    protected CharSequence text = null;
    protected short col;
    protected short type;
    private int offset;

    public APTBaseToken() {
    }

    public APTBaseToken(APTToken token) {
        this(token, token.getType());
    }

    public APTBaseToken(APTToken token, int ttype) {
        this.setColumn(token.getColumn());
        this.setFilename(token.getFilename());
        this.setLine(token.getLine());
        this.text = token.getTextID();
        assert (CharSequences.isCompact((CharSequence)this.text));
        this.setType(ttype);
        this.setOffset(token.getOffset());
        this.setEndOffset(token.getEndOffset());
        this.setEndColumn(token.getEndColumn());
        this.setEndLine(token.getEndLine());
        this.setTextID(token.getTextID());
    }

    public APTBaseToken(String text) {
        this.setText(text);
    }

    public final int getType() {
        return this.type;
    }

    public final void setType(int t) {
        assert (t <= Short.MAX_VALUE);
        this.type = (short)t;
    }

    public String getFilename() {
        return null;
    }

    public void setFilename(String name) {
    }

    @Override
    public final int getOffset() {
        return this.offset;
    }

    @Override
    public final void setOffset(int o) {
        this.offset = o;
    }

    @Override
    public int getEndOffset() {
        return this.getOffset() + this.getTextID().length();
    }

    @Override
    public void setEndOffset(int end) {
    }

    @Override
    public final CharSequence getTextID() {
        return this.text;
    }

    @Override
    public final void setTextID(CharSequence textID) {
        this.text = TextCache.getManager().getString(textID);
    }

    @Override
    public final String getText() {
        return ((Object)this.text).toString();
    }

    public final void setText(String t) {
        this.text = TextCache.getManager().getString((CharSequence)t);
    }

    public final int getLine() {
        return this.line;
    }

    public final void setLine(int l) {
        this.line = l;
    }

    public final int getColumn() {
        return this.col;
    }

    public final void setColumn(int c) {
        if (c > Short.MAX_VALUE) {
            c = Short.MAX_VALUE;
        } else {
            this.col = (short)c;
        }
    }

    public String toString() {
        return "[\"" + this.getTextID() + "\",<" + this.getType() + ">,line=" + this.getLine() + ",col=" + this.getColumn() + "]" + ",offset=" + this.getOffset() + ",file=" + this.getFilename();
    }

    @Override
    public int getEndColumn() {
        return this.getColumn() + this.getTextID().length();
    }

    @Override
    public void setEndColumn(int c) {
    }

    @Override
    public int getEndLine() {
        return this.getLine();
    }

    @Override
    public void setEndLine(int l) {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        APTBaseToken other = (APTBaseToken)obj;
        if (this.getType() != other.getType()) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        return this.text.equals(other.text);
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + this.getType();
        hash = 23 * hash + this.offset;
        hash = 23 * hash + this.text.hashCode();
        return hash;
    }
}

