/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.debugger.ui.actions.ConnectorPanel;
import org.netbeans.spi.debugger.ui.AttachType;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class ConnectAction
extends AbstractAction {
    private ConnectorPanel cp;
    private DialogDescriptor descr;
    private Dialog dialog;
    private JButton bOk;
    private JButton bCancel;
    private NotificationLineSupport notificationSupport;

    public ConnectAction() {
        this.putValue("Name", NbBundle.getMessage(ConnectAction.class, (String)"CTL_Connect"));
        this.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/Attach.gif");
    }

    @Override
    public boolean isEnabled() {
        List attachTypes = DebuggerManager.getDebuggerManager().lookup(null, AttachType.class);
        return attachTypes.size() > 0;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.bOk = new JButton(NbBundle.getMessage(ConnectAction.class, (String)"CTL_Ok"));
        this.bCancel = new JButton(NbBundle.getMessage(ConnectAction.class, (String)"CTL_Cancel"));
        this.bOk.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectAction.class, (String)"ACSD_CTL_Ok"));
        this.bCancel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectAction.class, (String)"ACSD_CTL_Cancel"));
        this.cp = new ConnectorPanel();
        this.descr = new DialogDescriptor((Object)this.cp, NbBundle.getMessage(ConnectAction.class, (String)"CTL_Connect_to_running_process"), true, (ActionListener)new ConnectListener(this.cp));
        this.descr.setOptions((Object[])new JButton[]{this.bOk, this.bCancel});
        this.notificationSupport = this.descr.createNotificationLineSupport();
        this.descr.setClosingOptions(new Object[0]);
        this.descr.setHelpCtx(HelpCtx.findHelp((Component)this.cp));
        this.dialog = DialogDisplayer.getDefault().createDialog(this.descr);
        this.dialog.setVisible(true);
    }

    private class ConnectListener
    implements ActionListener,
    PropertyChangeListener {
        ConnectorPanel connectorPanel;
        Controller controller;

        ConnectListener(ConnectorPanel connectorPanel) {
            this.connectorPanel = connectorPanel;
            this.startListening();
            this.setValid();
            connectorPanel.addPropertyChangeListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ConnectAction.this.dialog == null) {
                return;
            }
            boolean okPressed = ConnectAction.this.bOk.equals(e.getSource());
            boolean close = false;
            close = okPressed ? this.connectorPanel.ok() : this.connectorPanel.cancel();
            if (!close) {
                return;
            }
            this.connectorPanel.removePropertyChangeListener(this);
            this.stopListening();
            ConnectAction.this.dialog.setVisible(false);
            ConnectAction.this.dialog.dispose();
            ConnectAction.this.dialog = null;
        }

        void startListening() {
            this.controller = this.connectorPanel.getController();
            if (this.controller == null) {
                return;
            }
            this.controller.addPropertyChangeListener(this);
        }

        void stopListening() {
            if (this.controller == null) {
                return;
            }
            this.controller.removePropertyChangeListener(this);
            this.controller = null;
        }

        void setValid() {
            Controller controller = this.connectorPanel.getController();
            if (controller == null) {
                ConnectAction.this.bOk.setEnabled(false);
                return;
            }
            ConnectAction.this.bOk.setEnabled(controller.isValid());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "type") {
                this.stopListening();
                ConnectAction.this.notificationSupport.clearMessages();
                ConnectAction.this.descr.setHelpCtx(HelpCtx.findHelp((Component)ConnectAction.this.cp));
                this.setValid();
                this.startListening();
            } else if (evt.getPropertyName() == "valid") {
                this.setValid();
            } else if (evt.getPropertyName() == "errorNotification") {
                Object v = evt.getNewValue();
                String msg = v == null ? null : v.toString();
                ConnectAction.this.notificationSupport.setErrorMessage(msg);
            } else if (evt.getPropertyName() == "infoNotification") {
                Object v = evt.getNewValue();
                String msg = v == null ? null : v.toString();
                ConnectAction.this.notificationSupport.setInformationMessage(msg);
            } else if (evt.getPropertyName() == "warningNotification") {
                Object v = evt.getNewValue();
                String msg = v == null ? null : v.toString();
                ConnectAction.this.notificationSupport.setWarningMessage(msg);
            }
        }
    }
}

