/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;
import org.netbeans.modules.dbschema.jdbcimpl.DBschemaDataObject;
import org.netbeans.modules.dbschema.jdbcimpl.SchemaElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.ChooseConnectionPanel;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.DBSchemaTablesPanel;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.DBSchemaWizardData;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.ProgressFrame;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RecaptureSchema {
    private static final Logger LOGGER = Logger.getLogger(RecaptureSchema.class.getName());
    private static final boolean debug = Boolean.getBoolean("org.netbeans.modules.dbschema.recapture.debug");
    ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.dbschema.jdbcimpl.resources.Bundle");
    private DBSchemaWizardData data;
    private Node dbSchemaNode;

    public RecaptureSchema(Node dbSchemaNode) {
        this.dbSchemaNode = dbSchemaNode;
        this.data = new DBSchemaWizardData();
        this.data.setExistingConn(true);
    }

    public void start() throws ClassNotFoundException, SQLException {
        final DBschemaDataObject dobj = (DBschemaDataObject)this.dbSchemaNode.getCookie(DBschemaDataObject.class);
        final SchemaElement elem = dobj.getSchema();
        if (debug) {
            System.out.println("[dbschema] url='" + elem.getUrl() + "'");
        }
        final FileObject fo1 = dobj.getPrimaryFile();
        try {
            SchemaElement.removeFromCache(elem.getName().getFullName() + "#" + fo1.getURL().toString());
        }
        catch (FileStateInvalidException ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
        }
        TableElement[] tableAndViewElements = elem.getTables();
        final LinkedList<String> tables = new LinkedList<String>();
        final LinkedList<String> views = new LinkedList<String>();
        for (int i = 0; i < tableAndViewElements.length; ++i) {
            TableElement te = tableAndViewElements[i];
            if (te.isTable()) {
                if (debug) {
                    System.out.println("[dbschema] adding table='" + te.getName() + "'");
                }
                tables.add(te.getName().getName());
                continue;
            }
            if (debug) {
                System.out.println("[dbschema] adding view='" + te.getName() + "'");
            }
            views.add(te.getName().getName());
        }
        final boolean conned = this.data.isConnected();
        final boolean ec = this.data.isExistingConn();
        final DatabaseConnection dbconn = this.data.getDatabaseConnection();
        String dbIdentName = elem.getUrl();
        if (debug) {
            System.out.println("[dbschema] conned='" + conned + "'");
            System.out.println("[dbschema] ec='" + ec + "'");
            System.out.println("[dbschema] NEW dbIdentName='" + dbIdentName + "'");
        }
        ConnectionProvider cp = this.createConnectionProvider(this.data, elem);
        try {
            final ConnectionProvider c = cp;
            if (c == null) {
                String message = MessageFormat.format(this.bundle.getString("EXC_CouldNotCreateConnection"), elem.getUrl());
                throw new SQLException(message);
            }
            if (debug) {
                System.out.println("[dbschema] c.getConnection()='" + c.getConnection() + "'");
            }
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        StatusDisplayer.getDefault().setStatusText(RecaptureSchema.this.bundle.getString("CreatingDatabaseSchema"));
                        final ProgressFrame pf = new ProgressFrame();
                        final SchemaElementImpl sei = new SchemaElementImpl(c);
                        PropertyChangeListener listener = new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent event) {
                                if (event.getPropertyName().equals("totalCount")) {
                                    pf.setMaximum((Integer)event.getNewValue());
                                    return;
                                }
                                if (event.getPropertyName().equals("progress")) {
                                    pf.setValue((Integer)event.getNewValue());
                                    return;
                                }
                                if (event.getPropertyName().equals("tableName")) {
                                    String message = MessageFormat.format(RecaptureSchema.this.bundle.getString("CapturingTable"), ((String)event.getNewValue()).toUpperCase());
                                    pf.setMessage(message);
                                    return;
                                }
                                if (event.getPropertyName().equals("FKt")) {
                                    String message = MessageFormat.format(RecaptureSchema.this.bundle.getString("CaptureFK"), ((String)event.getNewValue()).toUpperCase(), RecaptureSchema.this.bundle.getString("CaptureFKtable"));
                                    pf.setMessage(message);
                                    return;
                                }
                                if (event.getPropertyName().equals("FKv")) {
                                    String message = MessageFormat.format(RecaptureSchema.this.bundle.getString("CaptureFK"), ((String)event.getNewValue()).toUpperCase(), RecaptureSchema.this.bundle.getString("CaptureFKview"));
                                    pf.setMessage(message);
                                    return;
                                }
                                if (event.getPropertyName().equals("viewName")) {
                                    String message = MessageFormat.format(RecaptureSchema.this.bundle.getString("CapturingView"), ((String)event.getNewValue()).toUpperCase());
                                    pf.setMessage(message);
                                    return;
                                }
                                if (event.getPropertyName().equals("cancel")) {
                                    sei.setStop(true);
                                    StatusDisplayer.getDefault().setStatusText("");
                                    return;
                                }
                            }
                        };
                        pf.propertySupport.addPropertyChangeListener(listener);
                        pf.setVisible(true);
                        sei.propertySupport.addPropertyChangeListener(listener);
                        final SchemaElement se = new SchemaElement(sei);
                        se.setName(elem.getName());
                        sei.initTables(c, tables, views, false);
                        pf.finishProgress();
                        if (!sei.isStop()) {
                            fo1.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                                public void run() throws IOException {
                                    FileLock fl;
                                    OutputStream out;
                                    if (debug) {
                                        System.out.println("SchemaElement: " + RecaptureSchema.this.dumpSe(se));
                                    }
                                    if ((out = fo1.getOutputStream(fl = fo1.lock())) == null) {
                                        throw new IOException("Unable to open output stream");
                                    }
                                    pf.setMessage(RecaptureSchema.this.bundle.getString("SavingDatabaseSchema"));
                                    StatusDisplayer.getDefault().setStatusText(RecaptureSchema.this.bundle.getString("SavingDatabaseSchema"));
                                    se.save(out);
                                    fl.releaseLock();
                                }
                            });
                            SchemaElement.addToCache(se);
                            dobj.setSchemaElementImpl(sei);
                            dobj.setSchema(se);
                            pf.setMessage(RecaptureSchema.this.bundle.getString("SchemaSaved"));
                            StatusDisplayer.getDefault().setStatusText(RecaptureSchema.this.bundle.getString("SchemaSaved"));
                            pf.setVisible(false);
                            pf.dispose();
                        }
                        if (conned) {
                            if (ec) {
                                ConnectionManager.getDefault().disconnect(dbconn);
                            } else {
                                c.closeConnection();
                            }
                        }
                    }
                    catch (Exception exc) {
                        Exceptions.printStackTrace((Throwable)exc);
                    }
                }
            }, 0);
        }
        catch (Exception exc) {
            String message = MessageFormat.format(this.bundle.getString("UnableToCreateSchema"), exc.getMessage());
            StatusDisplayer.getDefault().setStatusText(message);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)exc, (Object)exc.getMessage()));
            LOGGER.log(Level.INFO, null, exc);
            try {
                if (cp != null) {
                    cp.closeConnection();
                }
                if (this.data.isConnected()) {
                    if (this.data.isExistingConn()) {
                        ConnectionManager.getDefault().disconnect(this.data.getDatabaseConnection());
                    } else {
                        cp.closeConnection();
                    }
                }
            }
            catch (Exception exc1) {
                // empty catch block
            }
        }
    }

    private String dumpSe(SchemaElement se) {
        StringBuffer s = new StringBuffer();
        s.append("name " + se.getName());
        s.append("\n");
        s.append("driver " + se.getDriverName());
        s.append("\n");
        s.append("username " + se.getUsername());
        s.append("\n");
        TableElement[] tables = se.getTables();
        s.append("tables count " + tables.length);
        s.append("\n");
        for (int i = 0; i < tables.length; ++i) {
            s.append("    table " + tables[i].getName());
            s.append("\n");
            ColumnElement[] columns = tables[i].getColumns();
            for (int j = 0; j < columns.length; ++j) {
                s.append("        column " + columns[j].getName());
                s.append("\n");
            }
        }
        return s.toString();
    }

    public ConnectionProvider createConnectionProvider(DBSchemaWizardData data, SchemaElement elem) throws SQLException {
        DatabaseConnection dbconn = this.findDatabaseConnection(elem);
        if (dbconn == null) {
            if (debug) {
                System.out.println("[dbschema-ccp] not found dbconn='" + dbconn + "'");
            }
            String message = MessageFormat.format(this.bundle.getString("EXC_CouldNotCreateConnection"), elem.getUrl());
            throw new SQLException(message);
        }
        if (debug) {
            System.out.println("[dbschema-ccp] found dbconn='" + dbconn.getDatabaseURL() + "'");
        }
        data.setDatabaseConnection(dbconn);
        ConnectionHandler ch = new ConnectionHandler(data);
        if (ch.ensureConnection()) {
            dbconn = data.getDatabaseConnection();
            if (debug) {
                System.out.println("[dbschema-ccp] connection ensured ='" + dbconn.getDatabaseURL() + "'");
            }
            ConnectionProvider connectionProvider = new ConnectionProvider(dbconn.getJDBCConnection(), dbconn.getDriverClass());
            connectionProvider.setSchema(dbconn.getSchema());
            return connectionProvider;
        }
        if (debug) {
            System.out.println("[dbschema-ccp] connection not ensured, returning null");
        }
        String message = MessageFormat.format(this.bundle.getString("EXC_UnableToConnect"), elem.getUrl());
        throw new SQLException(message);
    }

    private DatabaseConnection findDatabaseConnection(final SchemaElement elem) {
        DatabaseConnection[] dbconns = ConnectionManager.getDefault().getConnections();
        String url = RecaptureSchema.trimUrl(elem.getUrl());
        for (int i = 0; i < dbconns.length; ++i) {
            String dburl = dbconns[i].getDatabaseURL();
            if (dburl == null || !dburl.startsWith(url)) continue;
            return dbconns[i];
        }
        DatabaseConnection conn = (DatabaseConnection)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<DatabaseConnection>(){

            public DatabaseConnection run() {
                return ChooseConnectionPanel.showChooseConnectionDialog(elem.getUrl());
            }
        });
        return conn;
    }

    private static String trimUrl(String url) {
        assert (url != null);
        url = url.split("[\\?\\&;]")[0];
        return url;
    }

    private DatabaseConnection createDatabaseConnection(SchemaElement elem) throws SQLException {
        final String url = elem.getUrl();
        final String user = elem.getUsername();
        String driver = elem.getDriver();
        JDBCDriver[] jdbcDrivers = JDBCDriverManager.getDefault().getDrivers(driver);
        if (jdbcDrivers.length == 0) {
            String message = MessageFormat.format(this.bundle.getString("EXC_NoDriverFound"), driver);
            throw new SQLException(message);
        }
        final JDBCDriver jdbcDriver = jdbcDrivers[0];
        DatabaseConnection conn = (DatabaseConnection)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<DatabaseConnection>(){

            public DatabaseConnection run() {
                return ConnectionManager.getDefault().showAddConnectionDialogFromEventThread(jdbcDriver, url, user, null);
            }
        });
        return conn;
    }

    private static class ConnectionHandler
    extends DBSchemaTablesPanel {
        public ConnectionHandler(DBSchemaWizardData data) {
            super(data, new ArrayList());
        }

        public boolean ensureConnection() {
            return this.init();
        }
    }
}

