/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.reflect;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.codeviation.commons.utils.StreamUtil;

public class ClassUtils {
    private static Map<Class, Class> P2O = new HashMap<Class, Class>();

    public static boolean isSuperinterface(Class implementor, Class iface) {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException("iface parameter " + iface + "must be an interface!");
        }
        return iface.isAssignableFrom(implementor);
    }

    public static boolean isSuperclass(Class clazz, Class superclass) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz parameter must not be null!");
        }
        if (superclass == null) {
            throw new IllegalArgumentException("superclass parameter must not be null!");
        }
        if (superclass.isInterface()) {
            throw new IllegalArgumentException("superclass parameter " + superclass + "must not be an interface!");
        }
        return superclass.isAssignableFrom(clazz);
    }

    public static String getDotClassName(Class clazz) {
        StringBuilder sb = new StringBuilder(clazz.getSimpleName());
        for (clazz = clazz.getEnclosingClass(); clazz != null; clazz = clazz.getEnclosingClass()) {
            sb.insert(0, clazz.getSimpleName() + ".");
        }
        return sb.toString();
    }

    public static String getResourceAsString(Class clazz, String resourceName) throws IOException {
        InputStream is = clazz.getResourceAsStream(resourceName);
        return is == null ? null : StreamUtil.asString(is);
    }

    public static Vector arrayToVector(Object array) {
        int len = Array.getLength(array);
        Vector<Object> result = new Vector<Object>(len);
        for (int i = 0; i < len; ++i) {
            result.add(Array.get(array, i));
        }
        return result;
    }

    public static Class primitive2Object(Class clazz) {
        if (!clazz.isPrimitive()) {
            throw new IllegalArgumentException(clazz + "is not primitive");
        }
        return P2O.get(clazz);
    }

    static {
        P2O.put(Boolean.TYPE, Boolean.class);
        P2O.put(Byte.TYPE, Byte.class);
        P2O.put(Character.TYPE, Character.class);
        P2O.put(Short.TYPE, Short.class);
        P2O.put(Integer.TYPE, Integer.class);
        P2O.put(Long.TYPE, Long.class);
        P2O.put(Float.TYPE, Float.class);
        P2O.put(Double.TYPE, Double.class);
        P2O.put(Void.TYPE, Void.class);
    }
}

