/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.codeviation.commons.patterns.Factory;

public class WriterUtils {
    public static final Factory<Writer, File> FILE = new FileWriterFactory(false, true);
    public static final Factory<Writer, File> FILE_DONT_OVERRIDE = new FileWriterFactory(false, false);
    public static final Factory<Writer, File> FILE_APPEND = new FileWriterFactory(true, false);

    private WriterUtils() {
    }

    private static class FileWriterFactory
    implements Factory<Writer, File> {
        private boolean append;
        private boolean override;

        public FileWriterFactory(boolean append, boolean override) {
            this.append = append;
            this.override = override;
        }

        @Override
        public Writer create(File file) {
            try {
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                } else if (!this.override && !this.append) {
                    throw new IllegalArgumentException("File " + file.getPath() + " already exists.");
                }
                return new FileWriter(file, this.append);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }
}

