/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.kenai.RestConnection;

public class RestResponse {
    private ByteArrayOutputStream os = new ByteArrayOutputStream();
    private String contentType = "text/plain";
    private String contentEncoding;
    private int responseCode;
    private String responseMsg;
    private long lastModified;

    public RestResponse() {
        String testUrl = System.getProperty("netbeans.t9y.kenai.testUrl");
        if (testUrl != null && testUrl.length() > 0) {
            byte[] buff = testUrl.getBytes();
            int r = 0;
            ByteArrayInputStream bis = new ByteArrayInputStream(buff);
            while ((r = bis.read()) != -1) {
                this.os.write(r);
            }
        }
    }

    public RestResponse(byte[] bytes) throws IOException {
        this();
        byte[] buffer = new byte[1024];
        int count = 0;
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        while ((count = bis.read(buffer)) != -1) {
            this.write(buffer, 0, count);
        }
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public void setResponseMessage(String msg) {
        this.responseMsg = msg;
    }

    public String getResponseMessage() {
        return this.responseMsg;
    }

    public void setResponseCode(int code) {
        this.responseCode = code;
    }

    public int getResponseCode() {
        String testUrl = System.getProperty("netbeans.t9y.kenai.testUrl");
        if (testUrl != null && testUrl.length() > 0) {
            return 200;
        }
        return this.responseCode;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void write(byte[] bytes, int start, int length) {
        this.os.write(bytes, start, length);
    }

    public byte[] getDataAsByteArray() {
        return this.os.toByteArray();
    }

    public String getDataAsString() {
        try {
            return this.os.toString("UTF-8");
        }
        catch (Exception ex) {
            Logger.getLogger(RestConnection.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public OutputStream getOutputStream() {
        return this.os;
    }
}

