/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Icon;
import org.codeviation.commons.patterns.Factory;
import org.codeviation.commons.utils.Iterators;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Presence;
import org.netbeans.modules.kenai.FeatureData;
import org.netbeans.modules.kenai.KenaiImpl;
import org.netbeans.modules.kenai.KenaiREST;
import org.netbeans.modules.kenai.LicensesListData;
import org.netbeans.modules.kenai.ProjectData;
import org.netbeans.modules.kenai.ServicesListData;
import org.netbeans.modules.kenai.UserData;
import org.netbeans.modules.kenai.api.KenaiActivity;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiLicense;
import org.netbeans.modules.kenai.api.KenaiManager;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiProjectMember;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.api.KenaiUser;
import org.netbeans.modules.kenai.api.Persistence;
import org.openide.util.ImageUtilities;

public final class Kenai
implements Comparable<Kenai> {
    public static final String PROP_LOGIN = "login";
    public static final String PROP_XMPP_LOGIN = "xmpp_login";
    public static final String PROP_LOGIN_STARTED = "login_started";
    public static final String PROP_XMPP_LOGIN_STARTED = "xmpp_login_started";
    public static final String PROP_LOGIN_FAILED = "login_failed";
    public static final String PROP_XMPP_LOGIN_FAILED = "xmpp_login_failed";
    @Deprecated
    public static final String PROP_URL_CHANGED = "url";
    private PasswordAuthentication auth = null;
    private KenaiImpl impl;
    private XMPPConnection xmppConnection;
    private PacketListener packetListener;
    final HashMap<String, KenaiUser> users = new HashMap();
    final HashSet<String> onlineUsers = new HashSet();
    final HashMap<String, WeakReference<KenaiProject>> projectsCache = new HashMap();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Icon icon;
    private String name;
    Collection<KenaiProject> myProjects = null;

    @Deprecated
    public static synchronized Kenai getDefault() {
        new Throwable("Kenai.getDefault() is deprecated. See http://wiki.netbeans.org/ParallelKenais").printStackTrace();
        return KenaiManager.getDefault().getKenai("https://kenai.com");
    }

    static synchronized Kenai createInstance(String name, String urlString) throws MalformedURLException {
        assert (urlString.startsWith("https://")) : "the only supported protocol is https";
        if (urlString.endsWith("/")) {
            urlString = urlString.substring(0, urlString.length() - 1);
        }
        URL url = new URL(urlString);
        KenaiREST impl = new KenaiREST(url);
        Kenai k = new Kenai(impl);
        k.name = name;
        return k;
    }

    public URL getUrl() {
        return this.impl.getUrl();
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = this.getUrl().getHost().contains("netbeans.org") ? ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/resources/netbeans-small.png", (boolean)false) : (this.getUrl().getHost().contains("testkenai.com") ? ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/resources/testkenai-small.png", (boolean)false) : (this.getUrl().getHost().contains("odftoolkit.org") ? ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/resources/odftoolkit-small.png", (boolean)false) : (this.getUrl().getHost().contains("java.net") ? ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/resources/javanet.png", (boolean)false) : ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/resources/kenai-small.png", (boolean)false))));
        }
        return this.icon;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getUrl().toString().substring("https://".length());
    }

    Kenai(KenaiImpl impl) {
        this.impl = impl;
    }

    public synchronized XMPPConnection getXMPPConnection() {
        return this.xmppConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String username, char[] password, boolean xmppLogin) throws KenaiException {
        if (this.auth != null && Arrays.equals(password, this.auth.getPassword()) && username.equals(this.auth.getUserName())) {
            if (xmppLogin && this.xmppConnection != null && this.xmppConnection.isConnected()) {
                return;
            }
            if (xmppLogin) {
                this.xmppConnect();
                return;
            }
            if (!xmppLogin && this.xmppConnection == null) {
                return;
            }
            this.xmppDisconnect(false);
            return;
        }
        PasswordAuthentication old = this.auth;
        this.firePropertyChange(new PropertyChangeEvent(this, PROP_LOGIN_STARTED, null, username));
        try {
            Kenai kenai = this;
            synchronized (kenai) {
                String shortName = this.impl.verify(username, password);
                this.auth = new PasswordAuthentication(shortName, password);
                this.myProjects = null;
                if (xmppLogin) {
                    this.xmppConnect();
                }
            }
        }
        catch (KenaiException ke) {
            this.firePropertyChange(new PropertyChangeEvent(this, PROP_LOGIN_FAILED, null, null));
            throw ke;
        }
        this.firePropertyChange(new PropertyChangeEvent(this, PROP_LOGIN, old, this.auth));
    }

    private void firePropertyChange(PropertyChangeEvent event) {
        this.propertyChangeSupport.firePropertyChange(event);
        KenaiManager.getDefault().propertyChangeSupport.firePropertyChange(event);
    }

    public void login(String username, char[] password) throws KenaiException {
        this.login(username, password, true);
    }

    public void logout() {
        this.logout(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logout(boolean setPropId) {
        PasswordAuthentication old = this.auth;
        Kenai kenai = this;
        synchronized (kenai) {
            this.auth = null;
            this.myProjects = null;
            this.xmppDisconnect(setPropId);
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_LOGIN, old, this.auth);
        if (setPropId) {
            propertyChangeEvent.setPropagationId(PROP_URL_CHANGED);
        }
        this.firePropertyChange(propertyChangeEvent);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(name, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(name, l);
    }

    public void register(String username, char[] password) throws KenaiException {
        this.impl.register(username, password);
    }

    public Collection<KenaiProject> searchProjects(String pattern) throws KenaiException {
        Collection<ProjectData> prjs = this.impl.searchProjects(pattern, this.auth);
        return new LazyCollection(prjs);
    }

    Collection<KenaiProjectMember> getProjectMembers(String name) throws KenaiException {
        Collection<UserData> usrs = this.impl.getProjectMembers(name, this.auth);
        return new LazyCollection(usrs);
    }

    public Collection<KenaiLicense> getLicenses() throws KenaiException {
        Collection<LicensesListData.LicensesListItem> licenses = this.impl.getLicenses();
        return new LazyCollection(licenses);
    }

    public Collection<KenaiService> getServices() throws KenaiException {
        Collection<ServicesListData.ServicesListItem> services = this.impl.getServices();
        return new LazyCollection(services);
    }

    public KenaiProject getProject(String name, boolean forceServerReload) throws KenaiException {
        if (forceServerReload) {
            return this._getProject(name);
        }
        KenaiProject result = KenaiProject.get(this, name);
        if (result != null) {
            return result;
        }
        return this._getProject(name);
    }

    public KenaiProject getProject(String name) throws KenaiException {
        return this.getProject(name, false);
    }

    ProjectData getDetails(String name) throws KenaiException {
        return this.impl.getProject(name, this.auth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KenaiProject createProject(String name, String displayName, String description, String[] licenses, String tags) throws KenaiException {
        if (this.auth.getUserName() == null) {
            throw new KenaiException("Guest user is not allowed to create new domains");
        }
        ProjectData prj = this.impl.createProject(name, displayName, description, licenses, tags, this.auth);
        KenaiProject result = KenaiProject.get(this, prj);
        Kenai kenai = this;
        synchronized (kenai) {
            if (this.myProjects != null) {
                this.myProjects.add(result);
            }
        }
        return result;
    }

    KenaiFeature createProjectFeature(String projectName, String name, String display_name, String description, String service, String url, String repository_url, String browse_url) throws KenaiException {
        if (this.getPasswordAuthentication() == null) {
            throw new KenaiException("Guest user is not allowed to create new domains");
        }
        FeatureData prj = this.impl.createProjectFeature(projectName, name, display_name, description, url, repository_url, browse_url, service, this.auth);
        return new KenaiFeature(prj);
    }

    public String checkProjectName(String name) throws KenaiException {
        return this.impl.checkName(name);
    }

    public boolean isAuthorized(KenaiProject project, KenaiActivity activity) throws KenaiException {
        return this.impl.isAuthorized(project.getName(), activity.getFeature().getId(), activity.getName(), this.getPasswordAuthentication());
    }

    public PasswordAuthentication getPasswordAuthentication() {
        return this.auth;
    }

    public synchronized Collection<KenaiProject> getMyProjects() throws KenaiException {
        if (this.auth == null) {
            return Collections.emptyList();
        }
        if (this.myProjects != null) {
            return this.myProjects;
        }
        return this.getMyProjects(true);
    }

    public Status getStatus() {
        if (this.auth == null) {
            return Status.OFFLINE;
        }
        if (this.xmppConnection == null) {
            return Status.LOGGED_IN;
        }
        return Status.ONLINE;
    }

    public synchronized Collection<KenaiProject> getMyProjects(boolean forceServerReload) throws KenaiException {
        if (this.auth == null) {
            return Collections.emptyList();
        }
        if (!forceServerReload) {
            return this.getMyProjects();
        }
        Collection<ProjectData> prjs = this.impl.getMyProjects(this.auth);
        this.myProjects = new LinkedList<KenaiProject>(new LazyCollection(prjs));
        return this.myProjects;
    }

    Collection<KenaiProject> loadProjects() {
        return Persistence.getInstance().loadProjects();
    }

    void storeProjects(Collection<KenaiProject> projects) {
        Persistence.getInstance().storeProjects(projects);
    }

    private KenaiProject _getProject(String name) throws KenaiException {
        ProjectData prj = this.impl.getProject(name, this.auth);
        return KenaiProject.get(this, prj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMember(KenaiProject project, KenaiUser user, KenaiProjectMember.Role role) throws KenaiException {
        assert (this.auth != null);
        this.impl.addMember(project.getName(), user.getUserName(), role.toString(), this.auth);
        Kenai kenai = this;
        synchronized (kenai) {
            if (this.myProjects != null) {
                this.myProjects.add(project);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteMember(KenaiProject project, KenaiUser user) throws KenaiException {
        assert (this.auth != null);
        this.impl.deleteMember(project.getName(), user.data.member_id, this.auth);
        Kenai kenai = this;
        synchronized (kenai) {
            if (this.myProjects != null) {
                this.myProjects.remove(project);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(KenaiProject project) throws KenaiException {
        assert (this.auth != null);
        this.impl.deleteProject(project.getName(), this.auth);
        Kenai kenai = this;
        synchronized (kenai) {
            if (this.myProjects != null) {
                this.myProjects.remove(project);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void xmppConnect() throws KenaiException {
        this.firePropertyChange(new PropertyChangeEvent(this, PROP_XMPP_LOGIN_STARTED, null, null));
        Kenai kenai = this;
        synchronized (kenai) {
            this.xmppConnection = new XMPPConnection(this.getUrl().getHost());
            this.packetListener = new KenaiUser.KenaiPacketListener();
            try {
                this.xmppConnection.removePacketListener(this.packetListener);
                this.xmppConnection.connect();
                this.xmppConnection.addPacketListener(this.packetListener, (PacketFilter)new PacketTypeFilter(Presence.class));
                this.xmppConnection.login(this.auth.getUserName(), new String(this.auth.getPassword()), "NetBeans");
            }
            catch (XMPPException xMPPException) {
                this.xmppConnection = null;
                this.firePropertyChange(new PropertyChangeEvent(this, PROP_XMPP_LOGIN_FAILED, null, null));
                throw new KenaiException(xMPPException);
            }
            catch (IllegalStateException ise) {
                this.xmppConnection = null;
                this.firePropertyChange(new PropertyChangeEvent(this, PROP_XMPP_LOGIN_FAILED, null, null));
                throw new KenaiException(ise);
            }
        }
        this.firePropertyChange(new PropertyChangeEvent(this, PROP_XMPP_LOGIN, null, this.xmppConnection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void xmppDisconnect(boolean setPropId) {
        if (this.xmppConnection == null) {
            return;
        }
        this.xmppConnection.disconnect();
        Cloneable cloneable = this.users;
        synchronized (cloneable) {
            this.users.clear();
        }
        cloneable = this.onlineUsers;
        synchronized (cloneable) {
            this.onlineUsers.clear();
        }
        XMPPConnection temp = this.xmppConnection;
        this.xmppConnection = null;
        temp.removePacketListener(this.packetListener);
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_XMPP_LOGIN, temp, null);
        if (setPropId) {
            propertyChangeEvent.setPropagationId(PROP_URL_CHANGED);
        }
        this.firePropertyChange(propertyChangeEvent);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Kenai other = (Kenai)obj;
        return !(this.getUrl() == null ? other.getUrl() != null : !this.getUrl().toString().equals(other.getUrl().toString()));
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.getUrl() != null ? this.getUrl().toString().hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(Kenai o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public String toString() {
        return this.getName() + " (" + this.getUrl().toString() + ")";
    }

    public static enum Status {
        ONLINE,
        LOGGED_IN,
        OFFLINE;

    }

    private class LazyCollection<I, O>
    extends AbstractCollection<O> {
        private Collection<I> delegate;

        private LazyCollection(Collection<I> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Iterator<O> iterator() {
            return Iterators.translating(this.delegate.iterator(), new Factory<O, I>(){

                @Override
                public O create(I param) {
                    if (param instanceof ProjectData) {
                        return KenaiProject.get(Kenai.this, (ProjectData)param);
                    }
                    if (param instanceof LicensesListData.LicensesListItem) {
                        return new KenaiLicense((LicensesListData.LicensesListItem)param);
                    }
                    if (param instanceof ServicesListData.ServicesListItem) {
                        return new KenaiService((ServicesListData.ServicesListItem)param);
                    }
                    if (param instanceof UserData) {
                        return new KenaiProjectMember(Kenai.this, (UserData)param);
                    }
                    throw new IllegalStateException();
                }
            });
        }

        @Override
        public int size() {
            return this.delegate.size();
        }
    }
}

