/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import org.netbeans.modules.kenai.api.Kenai;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public final class KenaiManager {
    private static KenaiManager instance;
    private TreeMap<String, Kenai> instances = new TreeMap();
    PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String PROP_INSTANCES = "prop_instances";
    private Preferences prefs = NbPreferences.forModule(Kenai.class);
    private static final String INSTANCES_PREF = "kenai.instances";
    private static final String UDPATED = "updated.";
    public static final String INSTANCES_URL;
    private boolean instancesInited = false;

    public static synchronized KenaiManager getDefault() {
        if (instance == null) {
            instance = new KenaiManager();
        }
        return instance;
    }

    private KenaiManager() {
    }

    public synchronized Kenai createKenai(String name, String url) throws MalformedURLException {
        return this.addInstance(Kenai.createInstance(name, url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Kenai addInstance(Kenai instance) {
        KenaiManager kenaiManager = this;
        synchronized (kenaiManager) {
            this.initInstances();
            this.instances.put(instance.getUrl().toString(), instance);
            this.store();
        }
        this.propertyChangeSupport.firePropertyChange(PROP_INSTANCES, null, instance);
        return instance;
    }

    private void store() {
        StringBuffer b = new StringBuffer();
        Iterator<Kenai> it = this.instances.values().iterator();
        while (it.hasNext()) {
            Kenai n = it.next();
            b.append(n.getUrl()).append(',').append(n.getName());
            if (!it.hasNext()) continue;
            b.append(';');
        }
        this.prefs.put(INSTANCES_PREF, b.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKenai(Kenai instance) {
        KenaiManager kenaiManager = this;
        synchronized (kenaiManager) {
            this.initInstances();
            instance.logout();
            this.instances.remove(instance.getUrl().toString());
            this.store();
        }
        this.propertyChangeSupport.firePropertyChange(PROP_INSTANCES, instance, null);
    }

    public synchronized Collection<Kenai> getKenais() {
        this.initInstances();
        return this.instances.values();
    }

    private void initInstances() {
        if (this.instancesInited) {
            return;
        }
        String s = this.prefs.get(INSTANCES_PREF, "");
        if (s.length() > 1) {
            for (String inst : s.split(";")) {
                if (inst.length() <= 0) continue;
                try {
                    this.instances.put(inst.split(",")[0], Kenai.createInstance(inst.split(",")[1], inst.split(",")[0]));
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        } else if (this.instances.isEmpty()) {
            try {
                this.instances.put("https://kenai.com", Kenai.createInstance("kenai.com", "https://kenai.com"));
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (Boolean.parseBoolean(System.getProperty("kenai.team-servers.update", "true"))) {
            this.updateInstances();
        }
        this.instancesInited = true;
    }

    public synchronized Kenai getKenai(String url) {
        this.initInstances();
        return this.instances.get(url);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private void updateInstances() {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    URL url = new URL(INSTANCES_URL);
                    URLConnection conn = url.openConnection();
                    BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    try {
                        String line;
                        while ((line = rd.readLine()) != null) {
                            if ((line = line.trim()).length() == 0 || KenaiManager.this.getKenai(line) != null || KenaiManager.this.prefs.getBoolean(KenaiManager.UDPATED + line, false)) continue;
                            KenaiManager.this.addInstance(Kenai.createInstance(null, line));
                            KenaiManager.this.prefs.putBoolean(KenaiManager.UDPATED + line, true);
                        }
                    }
                    finally {
                        rd.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    static {
        INSTANCES_URL = System.getProperty("kenai.team-servers.url", "http://netbeans.org/team-servers");
    }
}

