/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.HashSet;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.packet.MUCUser;
import org.netbeans.modules.kenai.UserData;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiManager;

public final class KenaiUser {
    public static final String PROP_PRESENCE = "Presence";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    UserData data;
    private Kenai kenai;

    private KenaiUser(Kenai kenai, UserData data) {
        this.kenai = kenai;
        this.data = data;
    }

    private KenaiUser(Kenai kenai, String username) {
        this.data = new UserData();
        this.data.user_name = username.substring(0, username.indexOf(64));
        this.kenai = kenai;
    }

    public Kenai getKenai() {
        return this.kenai;
    }

    public String getUserName() {
        return this.data.user_name;
    }

    public String getFirstName() {
        return this.data.first_name;
    }

    public String getLastName() {
        return this.data.last_name;
    }

    public String getFQN() {
        return this.getUserName() + "@" + this.kenai.getUrl().getHost();
    }

    public Status getStatus() {
        if (this.kenai.getPasswordAuthentication() == null) {
            return Status.UNKNOWN;
        }
        if (this.isOnline()) {
            return Status.ONLINE;
        }
        return Status.OFFLINE;
    }

    public String toString() {
        return this.getUserName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KenaiUser forName(String name) {
        assert (name != null);
        assert (name.contains("@")) : "username must be FQN";
        assert (!name.contains("/")) : "username cannot contain '/'";
        Kenai kenai = KenaiUser.getKenai(name);
        assert (kenai != null) : "kenai instance not found for " + name;
        HashMap<String, KenaiUser> hashMap = kenai.users;
        synchronized (hashMap) {
            String shortName = StringUtils.parseName((String)name);
            KenaiUser user = kenai.users.get(shortName);
            if (user == null) {
                user = new KenaiUser(kenai, name);
                kenai.users.put(shortName, user);
            }
            return user;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOnlineUserCount() {
        int i = 0;
        for (Kenai k : KenaiManager.getDefault().getKenais()) {
            HashSet<String> hashSet = k.onlineUsers;
            synchronized (hashSet) {
                i += k.onlineUsers.size();
            }
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KenaiUser get(Kenai kenai, UserData data) {
        HashMap<String, KenaiUser> hashMap = kenai.users;
        synchronized (hashMap) {
            KenaiUser user = kenai.users.get(data.user_name);
            if (user != null) {
                user.data = data;
            } else {
                user = new KenaiUser(kenai, data);
                kenai.users.put(data.user_name, user);
            }
            return user;
        }
    }

    public boolean isOnline() {
        return KenaiUser.isOnline(this.getUserName() + "@" + this.kenai.getUrl().getHost());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOnline(String user) {
        assert (user != null);
        assert (user.contains("@")) : "username must be FQN";
        assert (!user.contains("/")) : "username cannot contain '/'";
        Kenai k = KenaiUser.getKenai(user);
        HashSet<String> hashSet = k.onlineUsers;
        synchronized (hashSet) {
            return k.onlineUsers.contains(StringUtils.parseName((String)user));
        }
    }

    private static Kenai getKenai(String jid) {
        if (jid.contains("@muc.")) {
            String server = StringUtils.parseServer((String)jid);
            return KenaiManager.getDefault().getKenai("https://" + server.substring(4));
        }
        return KenaiManager.getDefault().getKenai("https://" + StringUtils.parseServer((String)jid));
    }

    public static enum Status {
        ONLINE,
        OFFLINE,
        DND,
        UNKNOWN;

    }

    static class KenaiPacketListener
    implements PacketListener {
        KenaiPacketListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPacket(Packet packet) {
            Presence presence = (Presence)packet;
            String from = presence.getFrom();
            Kenai k = KenaiUser.getKenai(from);
            MUCUser mucUser = (MUCUser)packet.getExtension("x", "http://jabber.org/protocol/muc#user");
            if (null != mucUser) {
                String user = StringUtils.parseName((String)mucUser.getItem().getJid());
                if (presence.getType() == Presence.Type.available) {
                    Cloneable cloneable = k.onlineUsers;
                    synchronized (cloneable) {
                        k.onlineUsers.add(user);
                    }
                    cloneable = k.users;
                    synchronized (cloneable) {
                        KenaiUser u = k.users.get(user);
                        if (u != null) {
                            u.propertyChangeSupport.firePropertyChange(KenaiUser.PROP_PRESENCE, presence.getType() != Presence.Type.available, presence.getType() == Presence.Type.available);
                        }
                    }
                }
                if (presence.getType() == Presence.Type.unavailable) {
                    Cloneable cloneable = k.onlineUsers;
                    synchronized (cloneable) {
                        k.onlineUsers.remove(user);
                    }
                    cloneable = k.users;
                    synchronized (cloneable) {
                        KenaiUser u = k.users.get(user);
                        if (u != null) {
                            u.propertyChangeSupport.firePropertyChange(KenaiUser.PROP_PRESENCE, presence.getType() != Presence.Type.available, presence.getType() == Presence.Type.available);
                        }
                    }
                }
            }
        }
    }
}

