/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform.jdkselection;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JdkConfiguration {
    private static final String NS_GENERAL = "http://www.netbeans.org/ns/project/1";
    private static final String NBJDK_PROPERTIES = "nbproject/nbjdk.properties";
    private static final String NBJDK_ACTIVE = "nbjdk.active";
    public static final String NBJDK_XML = "nbproject/nbjdk.xml";
    public static final String JDK_XML = "nbproject/jdk.xml";
    private static final String PLATFORM_ID_DEFAULT = "default_platform";
    private final Project project;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;

    public JdkConfiguration(Project project, AntProjectHelper helper, PropertyEvaluator evaluator) {
        this.project = project;
        this.helper = helper;
        this.evaluator = evaluator;
    }

    private void initialize() throws IOException {
        this.project.getProjectDirectory().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                JdkConfiguration.this.createJdkXml();
                if (JdkConfiguration.this.project.getProjectDirectory().getFileObject(JdkConfiguration.NBJDK_XML) != null) {
                    return;
                }
                Element generalDataE = Util.getPrimaryConfigurationData((AntProjectHelper)JdkConfiguration.this.helper);
                Document nbjdkDoc = JdkConfiguration.this.createNbjdkXmlSkeleton();
                JdkConfiguration.this.rebindAllActions(generalDataE, nbjdkDoc);
                JdkConfiguration.this.writeXML(nbjdkDoc, JdkConfiguration.NBJDK_XML);
                Util.putPrimaryConfigurationData((AntProjectHelper)JdkConfiguration.this.helper, (Element)generalDataE);
                ProjectManager.getDefault().saveProject(JdkConfiguration.this.project);
            }
        });
    }

    private void createJdkXml() throws IOException {
        ProjectManager.getDefault().saveProject(this.project);
        new GeneratedFilesHelper(this.helper).refreshBuildScript(JDK_XML, JdkConfiguration.class.getResource("jdk.xsl"), true);
    }

    public static void insertJdkXmlImport(Document doc) {
        NodeList nl = doc.getElementsByTagName("import");
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!((Element)nl.item(i)).getAttribute("file").equals("jdk.xml")) continue;
            return;
        }
        Element projectE = doc.getDocumentElement();
        Element propE = doc.createElement("property");
        propE.setAttribute("file", NBJDK_PROPERTIES);
        projectE.appendChild(propE);
        propE = doc.createElement("property");
        propE.setAttribute("name", "user.properties.file");
        propE.setAttribute("location", "${netbeans.user}/build.properties");
        projectE.appendChild(propE);
        propE = doc.createElement("property");
        propE.setAttribute("file", "${user.properties.file}");
        projectE.appendChild(propE);
        Element importE = doc.createElement("import");
        importE.setAttribute("file", "jdk.xml");
        projectE.appendChild(importE);
    }

    private Document createNbjdkXmlSkeleton() {
        Document nbjdkDoc = XMLUtil.createDocument((String)"project", null, null, null);
        Element projectE = nbjdkDoc.getDocumentElement();
        projectE.setAttribute("name", ProjectUtils.getInformation((Project)this.project).getName());
        projectE.setAttribute("basedir", "..");
        JdkConfiguration.insertJdkXmlImport(nbjdkDoc);
        return nbjdkDoc;
    }

    private void rebindAllActions(Element generalDataE, Document nbjdkDoc) {
        Element contextMenuE;
        Element viewE;
        Element projectE = nbjdkDoc.getDocumentElement();
        HashSet<String> targetsCreated = new HashSet<String>();
        Element ideActionsE = XMLUtil.findElement((Element)generalDataE, (String)"ide-actions", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (ideActionsE != null) {
            for (Element actionE : XMLUtil.findSubElements((Element)ideActionsE)) {
                this.rebindAction(actionE, projectE, targetsCreated);
            }
        }
        if ((viewE = XMLUtil.findElement((Element)generalDataE, (String)"ide-actions", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null && (contextMenuE = XMLUtil.findElement((Element)viewE, (String)"context-menu", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
            for (Element actionE : XMLUtil.findSubElements((Element)contextMenuE)) {
                if (!actionE.getLocalName().equals("action")) continue;
                this.rebindAction(actionE, projectE, targetsCreated);
            }
        }
    }

    private void rebindAction(Element actionE, Element projectE, Set<String> targetsCreated) {
        String script;
        Element scriptE = XMLUtil.findElement((Element)actionE, (String)"script", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (scriptE != null) {
            script = XMLUtil.findText((Node)scriptE);
            actionE.removeChild(scriptE);
        } else {
            script = "build.xml";
        }
        scriptE = actionE.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/freeform-project/2", "script");
        scriptE.appendChild(actionE.getOwnerDocument().createTextNode(NBJDK_XML));
        actionE.insertBefore(scriptE, actionE.getFirstChild());
        ArrayList<String> targetNames = new ArrayList<String>();
        for (Element targetE : XMLUtil.findSubElements((Element)actionE)) {
            if (!targetE.getLocalName().equals("target")) continue;
            targetNames.add(XMLUtil.findText((Node)targetE));
        }
        if (targetNames.isEmpty()) {
            targetNames.add(null);
        }
        String scriptPath = this.evaluator.evaluate(script);
        for (String target : targetNames) {
            if (!targetsCreated.add(target)) continue;
            JdkConfiguration.createOverride(projectE, target, scriptPath);
        }
    }

    private static void createOverride(Element projectE, String target, String script) {
        Element targetE = projectE.getOwnerDocument().createElement("target");
        if (target != null) {
            targetE.setAttribute("name", target);
        }
        String depends = target != null && target.indexOf("debug") != -1 ? "-jdk-init,-jdk-presetdef-nbjpdastart" : "-jdk-init";
        targetE.setAttribute("depends", depends);
        Element antE = projectE.getOwnerDocument().createElement("ant");
        if (target != null) {
            antE.setAttribute("target", target);
        }
        if (!script.equals("build.xml")) {
            antE.setAttribute("antfile", script);
        }
        antE.setAttribute("inheritall", "false");
        targetE.appendChild(antE);
        projectE.appendChild(targetE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXML(Document doc, String path) throws IOException {
        FileObject fo = FileUtil.createData((FileObject)this.project.getProjectDirectory(), (String)path);
        FileLock lock = fo.lock();
        try {
            OutputStream os = fo.getOutputStream(lock);
            try {
                XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    public JavaPlatform getSelectedPlatform() {
        EditableProperties ep = this.helper.getProperties(NBJDK_PROPERTIES);
        String plaf = ep.getProperty(NBJDK_ACTIVE);
        if (plaf != null) {
            for (JavaPlatform p : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
                if (!plaf.equals(JdkConfiguration.getPlatformID(p))) continue;
                return p;
            }
        }
        return null;
    }

    public void setSelectedPlatform(JavaPlatform jdk) throws IOException {
        assert (jdk != null);
        this.initialize();
        EditableProperties ep = this.helper.getProperties(NBJDK_PROPERTIES);
        ep.setProperty(NBJDK_ACTIVE, JdkConfiguration.getPlatformID(jdk));
        this.helper.putProperties(NBJDK_PROPERTIES, ep);
        ProjectManager.getDefault().saveProject(this.project);
    }

    private static String getPlatformID(JavaPlatform platform) {
        String s = (String)platform.getProperties().get("platform.ant.name");
        if (s != null) {
            return s;
        }
        return PLATFORM_ID_DEFAULT;
    }
}

