/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventListener;
import javax.swing.JLabel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public abstract class SaveableSectionInnerPanel
extends SectionInnerPanel {
    private EnterKeyListener listener;

    public SaveableSectionInnerPanel(SectionView sectionView) {
        super(sectionView);
    }

    protected boolean isClient(Node node) {
        Client client = (Client)node.getLookup().lookup(Client.class);
        if (client != null) {
            return true;
        }
        JaxWsService jaxWsService = (JaxWsService)node.getLookup().lookup(JaxWsService.class);
        return jaxWsService != null && !jaxWsService.isServiceProvider();
    }

    protected void setModelDirty(WSDLModel wSDLModel) {
        try {
            ModelSource modelSource = wSDLModel.getModelSource();
            FileObject fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class);
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (!dataObject.isModified()) {
                dataObject.setModified(true);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    protected void disableEnterKey() {
        Component[] componentArray = this.getComponents();
        this.listener = new EnterKeyListener();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!component.isFocusable() || component instanceof JLabel) continue;
            KeyListener keyListener = (KeyListener)WeakListeners.create(KeyListener.class, (EventListener)this.listener, (Object)component);
            component.addKeyListener(keyListener);
        }
    }

    public abstract void save();

    public boolean jaxwsIsDirty() {
        return false;
    }

    public abstract boolean wsdlIsDirty();

    private class EnterKeyListener
    extends KeyAdapter {
        private EnterKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                keyEvent.consume();
            }
        }
    }
}

